/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyAxisIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public final class Orphan
implements MutableNodeInfo {
    private short kind;
    private NodeName nodeName = null;
    private CharSequence stringValue;
    private SchemaType typeAnnotation = null;
    private Configuration config;
    private String systemId;
    private boolean isId;
    private boolean isIdref;

    public Orphan(Configuration config) {
        this.config = config;
    }

    public Item head() {
        return this;
    }

    public SequenceIterator iterate() {
        return SingletonIterator.makeIterator(this);
    }

    public void setNodeKind(short kind) {
        this.kind = kind;
    }

    public void setNodeName(NodeName nodeName) {
        this.nodeName = nodeName;
    }

    public void setStringValue(CharSequence stringValue) {
        this.stringValue = stringValue;
    }

    public void setTypeAnnotation(SchemaType typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
    }

    public void setTypeAnnotation(int typeAnnotation) {
        this.typeAnnotation = this.getConfiguration().getSchemaType(typeAnnotation);
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setIsId(boolean id) {
        this.isId = id;
    }

    public void setIsIdref(boolean idref) {
        this.isIdref = idref;
    }

    public int getNodeKind() {
        return this.kind;
    }

    public AtomicSequence atomize() throws XPathException {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.stringValue);
            }
            case 3: 
            case 9: 
            case 13: {
                return new UntypedAtomicValue(this.stringValue);
            }
        }
        if (this.typeAnnotation == null || this.typeAnnotation == Untyped.getInstance() || this.typeAnnotation == BuiltInAtomicType.UNTYPED_ATOMIC) {
            return new UntypedAtomicValue(this.stringValue);
        }
        return this.typeAnnotation.atomize(this);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getTypeAnnotation() {
        SchemaType st = this.getSchemaType();
        return st == null ? -1 : st.getFingerprint();
    }

    public SchemaType getSchemaType() {
        if (this.typeAnnotation == null) {
            if (this.kind == 1) {
                return Untyped.getInstance();
            }
            if (this.kind == 2) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
        }
        return this.typeAnnotation;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        return this == other;
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getBaseURI() {
        if (this.kind == 7) {
            return this.systemId;
        }
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo other) {
        if (this.isSameNodeInfo(other)) {
            return 0;
        }
        return this.hashCode() < ((Object)other).hashCode() ? -1 : 1;
    }

    public int comparePosition(NodeInfo other) {
        if (this.kind == 2 || this.kind == 13) {
            throw new UnsupportedOperationException();
        }
        if (this.isSameNodeInfo(other)) {
            return 12;
        }
        throw new UnsupportedOperationException();
    }

    public String getStringValue() {
        return ((Object)this.stringValue).toString();
    }

    public CharSequence getStringValueCS() {
        return this.stringValue;
    }

    public int getNameCode() {
        NodeName nn = this.nodeName;
        if (nn == null) {
            return -1;
        }
        return nn.allocateNameCode(this.getNamePool());
    }

    public int getFingerprint() {
        if (this.nodeName == null) {
            return -1;
        }
        return this.getNameCode() & 0xFFFFF;
    }

    public String getLocalPart() {
        if (this.nodeName == null) {
            return "";
        }
        return this.nodeName.getLocalPart();
    }

    public String getURI() {
        if (this.nodeName == null) {
            return "";
        }
        return this.nodeName.getURI();
    }

    public String getPrefix() {
        if (this.nodeName == null) {
            return "";
        }
        return this.nodeName.getPrefix();
    }

    public String getDisplayName() {
        if (this.nodeName == null) {
            return "";
        }
        return this.nodeName.getDisplayName();
    }

    public NodeInfo getParent() {
        return null;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 1: 
            case 5: 
            case 12: {
                return SingleNodeIterator.makeIterator(this);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyAxisIterator.emptyAxisIterator();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 1: 
            case 5: 
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyAxisIterator.emptyAxisIterator();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public String getAttributeValue(String uri, String local) {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append('Q');
        buffer.append(Integer.toString(this.hashCode()));
    }

    public long getDocumentNumber() {
        return this.hashCode() & 0xFFFFFF;
    }

    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        Navigator.copy(this, out, copyOptions, locationId);
    }

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return null;
    }

    public boolean isId() {
        return this.isId || this.kind == 2 && this.nodeName.equals(StandardNames.XML_ID_NAME);
    }

    public boolean isIdref() {
        return this.isIdref;
    }

    public boolean isNilled() {
        return false;
    }

    public void insertChildren(NodeInfo[] source, boolean atStart, boolean inherit) {
    }

    public void insertSiblings(NodeInfo[] source, boolean before, boolean inherit) {
    }

    public void removeAttribute(NodeInfo attribute) {
    }

    public void addAttribute(NodeName nameCode, SimpleType attType, CharSequence value, int properties) {
    }

    public void delete() {
        this.kind = (short)-1;
    }

    public boolean isDeleted() {
        return this.kind == -1;
    }

    public void replace(NodeInfo[] replacement, boolean inherit) {
        throw new IllegalStateException("Cannot replace a parentless node");
    }

    public void replaceStringValue(CharSequence stringValue) {
        this.stringValue = stringValue;
    }

    public void rename(NodeName newNameCode) {
        if (this.kind == 2 || this.kind == 7) {
            this.nodeName = newNameCode;
        }
    }

    public void addNamespace(NamespaceBinding nscode, boolean inherit) {
    }

    public void removeTypeAnnotation() {
        this.typeAnnotation = BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public Builder newBuilder() {
        throw new UnsupportedOperationException("Cannot create children for an Orphan node");
    }
}

