/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntToIntHashMap;
import net.sf.saxon.z.IntToIntMap;

public class Translate
extends SystemFunctionCall
implements Callable {
    private IntToIntMap staticMap = null;

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.typeCheck(visitor, contextItemType);
        if (e == this && this.argument[1] instanceof StringLiteral && this.argument[2] instanceof StringLiteral) {
            this.staticMap = Translate.buildMap((StringValue)((StringLiteral)this.argument[1]).getValue(), (StringValue)((StringLiteral)this.argument[2]).getValue());
        }
        return e;
    }

    public StringValue evaluateItem(XPathContext context) throws XPathException {
        StringValue sv1 = (StringValue)this.argument[0].evaluateItem(context);
        if (sv1 == null) {
            return StringValue.EMPTY_STRING;
        }
        if (this.staticMap != null) {
            CharSequence in = sv1.getStringValueCS();
            CharSequence sb = Translate.translateUsingMap(in, this.staticMap);
            return new StringValue(sb);
        }
        StringValue sv2 = (StringValue)this.argument[1].evaluateItem(context);
        StringValue sv3 = (StringValue)this.argument[2].evaluateItem(context);
        return StringValue.makeStringValue(Translate.translate(sv1, sv2, sv3));
    }

    public IntToIntMap getStaticMap() {
        return this.staticMap;
    }

    public static CharSequence translate(StringValue sv0, StringValue sv1, StringValue sv2) {
        if (sv0.containsSurrogatePairs() || sv1.containsSurrogatePairs() || sv2.containsSurrogatePairs()) {
            return Translate.translateUsingMap(sv0.getStringValueCS(), Translate.buildMap(sv1, sv2));
        }
        if (sv0.getStringLength() * sv1.getStringLength() > 1000) {
            return Translate.translateUsingMap(sv0.getStringValueCS(), Translate.buildMap(sv1, sv2));
        }
        CharSequence cs0 = sv0.getStringValueCS();
        CharSequence cs1 = sv1.getStringValueCS();
        CharSequence cs2 = sv2.getStringValueCS();
        String st1 = ((Object)cs1).toString();
        FastStringBuffer sb = new FastStringBuffer(cs0.length());
        int s2len = cs2.length();
        int s0len = cs0.length();
        for (int i = 0; i < s0len; ++i) {
            char c = cs0.charAt(i);
            int j = st1.indexOf(c);
            if (j >= s2len) continue;
            sb.append(j < 0 ? c : cs2.charAt(j));
        }
        return sb;
    }

    private static IntToIntMap buildMap(StringValue arg1, StringValue arg2) {
        UnicodeString a1 = UnicodeString.makeUnicodeString(arg1.getStringValueCS());
        UnicodeString a2 = UnicodeString.makeUnicodeString(arg2.getStringValueCS());
        IntToIntHashMap map = new IntToIntHashMap(a1.length(), 0.5);
        for (int i = 0; i < a1.length(); ++i) {
            if (map.find(a1.charAt(i))) continue;
            map.put(a1.charAt(i), i > a2.length() - 1 ? -1 : a2.charAt(i));
        }
        return map;
    }

    public static CharSequence translateUsingMap(CharSequence in, IntToIntMap map) {
        UnicodeString us = UnicodeString.makeUnicodeString(in);
        int len = us.length();
        FastStringBuffer sb = new FastStringBuffer(len);
        for (int i = 0; i < len; ++i) {
            int c = us.charAt(i);
            int newchar = map.get(c);
            if (newchar == Integer.MAX_VALUE) {
                newchar = c;
            }
            if (newchar == -1) continue;
            sb.appendWideChar(newchar);
        }
        return sb;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue sv0 = (StringValue)arguments[0].head();
        StringValue sv1 = (StringValue)arguments[1].head();
        StringValue sv2 = (StringValue)arguments[2].head();
        return new StringValue(Translate.translate(sv0, sv1, sv2));
    }
}

