/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public class ResolveURI
extends SystemFunctionCall
implements Callable {
    String expressionBaseURI = null;

    public void bindStaticContext(StaticContext env) throws XPathException {
        this.expressionBaseURI = env.getBaseURI();
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        if (this.expressionBaseURI == null) {
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
            if (this.expressionBaseURI == null && this.argument.length == 1) {
                XPathException de = new XPathException("Base URI in static context of resolve-uri() is unknown");
                de.setErrorCode("FONS0005");
                throw de;
            }
        }
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public Expression copy() {
        ResolveURI d = (ResolveURI)super.copy();
        d.expressionBaseURI = this.expressionBaseURI;
        return d;
    }

    public boolean equals(Object o) {
        return o instanceof ResolveURI && super.equals(o) && ResolveURI.equalOrNull(this.expressionBaseURI, ((ResolveURI)o).expressionBaseURI);
    }

    public AnyURIValue evaluateItem(XPathContext context) throws XPathException {
        String base;
        AtomicValue arg0 = (AtomicValue)this.argument[0].evaluateItem(context);
        if (arg0 == null) {
            return null;
        }
        String relative = arg0.getStringValue();
        if (this.argument.length == 2) {
            base = ((Object)this.argument[1].evaluateAsString(context)).toString();
        } else {
            base = this.expressionBaseURI;
            if (this.expressionBaseURI == null) {
                this.dynamicError("Base URI in static context of resolve-uri() is unknown", "FONS0005", context);
                return null;
            }
        }
        return this.resolve(base, relative, context);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String base;
        AtomicValue arg0 = (AtomicValue)arguments[0].head();
        if (arg0 == null) {
            return EmptySequence.getInstance();
        }
        String relative = arg0.getStringValue();
        if (this.argument.length == 2) {
            base = arguments[1].head().getStringValue();
        } else {
            base = this.expressionBaseURI;
            if (this.expressionBaseURI == null) {
                this.dynamicError("Base URI in static context of resolve-uri() is unknown", "FONS0005", context);
                return null;
            }
        }
        return this.resolve(base, relative, context);
    }

    private AnyURIValue resolve(String base, String relative, XPathContext context) throws XPathException {
        try {
            URI absoluteURI = new URI(base);
            if (!absoluteURI.isAbsolute()) {
                URI relativeURI = new URI(relative);
                if (relativeURI.isAbsolute()) {
                    return new AnyURIValue(relative);
                }
                this.dynamicError("Base URI " + Err.wrap(base) + " is not an absolute URI", "FORG0002", context);
            }
            if (absoluteURI.isOpaque()) {
                if (base.startsWith("jar:file:")) {
                    try {
                        URL absoluteURL = new URL(base);
                        URL resolved = new URL(absoluteURL, relative);
                        return new AnyURIValue(resolved.toString());
                    }
                    catch (Exception err) {
                        // empty catch block
                    }
                }
                this.dynamicError("Base URI " + Err.wrap(base) + " is a non-hierarchic URI", "FORG0002", context);
            }
            if (absoluteURI.getRawFragment() != null) {
                this.dynamicError("Base URI " + Err.wrap(base) + " contains a fragment identifier", "FORG0002", context);
            }
            URI resolved = ResolveURI.makeAbsolute(relative, base);
            return new AnyURIValue(resolved.toString());
        }
        catch (URISyntaxException err) {
            this.dynamicError("Base URI " + Err.wrap(base) + " is invalid: " + err.getMessage(), "FORG0002", context);
            return new AnyURIValue("");
        }
    }

    public static String tryToExpand(String systemId) {
        if (systemId == null) {
            systemId = "";
        }
        try {
            new URL(systemId);
            return systemId;
        }
        catch (MalformedURLException err) {
            String dir;
            try {
                dir = System.getProperty("user.dir");
            }
            catch (Exception geterr) {
                return systemId;
            }
            if (!dir.endsWith("/") && !systemId.startsWith("/")) {
                dir = dir + '/';
            }
            try {
                URI currentDirectoryURI = new File(dir).toURI();
                URI baseURI = currentDirectoryURI.resolve(systemId);
                return baseURI.toString();
            }
            catch (Exception e) {
                return systemId;
            }
        }
    }

    public static URI makeAbsolute(String relativeURI, String base) throws URISyntaxException {
        URI absoluteURI;
        block18: {
            if (relativeURI == null) {
                if (base == null) {
                    throw new URISyntaxException("", "Relative and Base URI must not both be null");
                }
                URI absoluteURI2 = new URI(ResolveURI.escapeSpaces(base));
                if (!absoluteURI2.isAbsolute()) {
                    throw new URISyntaxException(base, "Relative URI not supplied, so base URI must be absolute");
                }
                return absoluteURI2;
            }
            relativeURI = ResolveURI.escapeSpaces(relativeURI);
            base = base == null ? null : ResolveURI.escapeSpaces(base);
            try {
                URI baseURI;
                if (base == null || base.length() == 0) {
                    String expandedBase;
                    absoluteURI = new URI(relativeURI);
                    if (!absoluteURI.isAbsolute() && !(expandedBase = ResolveURI.tryToExpand(base)).equals(base)) {
                        return ResolveURI.makeAbsolute(relativeURI, expandedBase);
                    }
                    break block18;
                }
                if (base != null && (base.startsWith("jar:") || base.startsWith("file:////"))) {
                    try {
                        URL baseURL = new URL(base);
                        URL absoluteURL = new URL(baseURL, relativeURI);
                        absoluteURI = absoluteURL.toURI();
                        break block18;
                    }
                    catch (MalformedURLException err) {
                        throw new URISyntaxException(base + " " + relativeURI, err.getMessage());
                    }
                }
                try {
                    baseURI = new URI(base);
                }
                catch (URISyntaxException e) {
                    throw new URISyntaxException(base, "Invalid base URI: " + e.getMessage());
                }
                if (baseURI.getFragment() != null) {
                    int hash = base.indexOf(35);
                    if (hash >= 0) {
                        base = base.substring(0, hash);
                    }
                    try {
                        baseURI = new URI(base);
                    }
                    catch (URISyntaxException e) {
                        throw new URISyntaxException(base, "Invalid base URI: " + e.getMessage());
                    }
                }
                try {
                    new URI(relativeURI);
                }
                catch (URISyntaxException e) {
                    throw new URISyntaxException(base, "Invalid relative URI: " + e.getMessage());
                }
                absoluteURI = relativeURI.length() == 0 ? baseURI : baseURI.resolve(relativeURI);
            }
            catch (IllegalArgumentException err0) {
                throw new URISyntaxException(relativeURI, "Cannot resolve URI against base " + Err.wrap(base));
            }
        }
        return absoluteURI;
    }

    public static String escapeSpaces(String s) {
        int i = s.indexOf(32);
        if (i < 0) {
            return s;
        }
        return (i == 0 ? "" : s.substring(0, i)) + "%20" + (i == s.length() - 1 ? "" : ResolveURI.escapeSpaces(s.substring(i + 1)));
    }
}

