/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Iterator;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.SubExpressionInfo;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceConstructor
extends SimpleNodeConstructor {
    private Expression name;

    public NamespaceConstructor(Expression name) {
        this.name = name;
        this.adoptChildExpression(name);
    }

    public Expression getNameExpression() {
        return this.name;
    }

    @Override
    public int getInstructionNameCode() {
        return 175;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.name = visitor.simplify(this.name);
        return super.simplify(visitor);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.NAMESPACE;
    }

    @Override
    public int getCardinality() {
        return 16384;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        this.name = this.doPromotion(this.name, offer);
        super.promoteInst(offer);
    }

    @Override
    public void localTypeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.name = visitor.typeCheck(this.name, contextItemType);
        this.adoptChildExpression(this.name);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (!th.isSubType(this.name.getItemType(th), BuiltInAtomicType.STRING)) {
            this.name = SystemFunctionCall.makeSystemFunction("string", new Expression[]{this.name});
        }
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator<Expression>(this.select, this.name);
    }

    @Override
    public Iterator<SubExpressionInfo> iterateSubExpressionInfo() {
        return new PairIterator<SubExpressionInfo>(new SubExpressionInfo(this.name, true, false, 1), new SubExpressionInfo(this.select, true, false, 1));
    }

    @Override
    public Expression copy() {
        NamespaceConstructor exp = new NamespaceConstructor(this.name.copy());
        exp.setSelect(this.select.copy(), this.getExecutable().getConfiguration());
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.name == original) {
            this.name = replacement;
            found = true;
        }
        return found;
    }

    private String evaluatePrefix(XPathContext context) throws XPathException {
        String prefix = Whitespace.trim(this.name.evaluateAsString(context));
        assert (prefix != null);
        if (prefix.length() != 0 && !context.getConfiguration().getNameChecker().isValidNCName(prefix)) {
            XPathException err = new XPathException("Namespace prefix is invalid: " + prefix, this);
            err.setErrorCode(this.isXSLT() ? "XTDE0920" : "FORG0001");
            err.setXPathContext(context);
            throw NamespaceConstructor.dynamicError(this, err, context);
        }
        if (prefix.equals("xmlns")) {
            XPathException err = new XPathException("Namespace prefix 'xmlns' is not allowed", this);
            err.setErrorCode(this.isXSLT() ? "XTDE0920" : "XQDY0101");
            err.setXPathContext(context);
            throw NamespaceConstructor.dynamicError(this, err, context);
        }
        return prefix;
    }

    @Override
    public NodeName evaluateNodeName(XPathContext context) throws XPathException {
        String prefix = this.evaluatePrefix(context);
        return new NoNamespaceName(prefix);
    }

    @Override
    public void processValue(CharSequence value, XPathContext context) throws XPathException {
        String prefix = this.evaluatePrefix(context);
        String uri = ((Object)value).toString();
        this.checkPrefixAndUri(prefix, uri, context);
        NamespaceBinding nscode = new NamespaceBinding(prefix, uri);
        SequenceReceiver out = context.getReceiver();
        out.namespace(nscode, 32);
    }

    @Override
    public NodeInfo evaluateItem(XPathContext context) throws XPathException {
        NodeInfo node = (NodeInfo)super.evaluateItem(context);
        assert (node != null);
        String prefix = node.getLocalPart();
        String uri = node.getStringValue();
        this.checkPrefixAndUri(prefix, uri, context);
        return node;
    }

    private void checkPrefixAndUri(String prefix, String uri, XPathContext context) throws XPathException {
        if (prefix.equals("xml") != uri.equals("http://www.w3.org/XML/1998/namespace")) {
            XPathException err = new XPathException("Namespace prefix 'xml' and namespace uri http://www.w3.org/XML/1998/namespace must only be used together", this);
            err.setErrorCode(this.isXSLT() ? "XTDE0925" : "XQDY0101");
            err.setXPathContext(context);
            throw NamespaceConstructor.dynamicError(this, err, context);
        }
        if (uri.length() == 0) {
            XPathException err = new XPathException("Namespace URI is an empty string", this);
            err.setErrorCode(this.isXSLT() ? "XTDE0930" : "XQDY0101");
            err.setXPathContext(context);
            throw NamespaceConstructor.dynamicError(this, err, context);
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            XPathException err = new XPathException("A namespace node cannot have the reserved namespace http://www.w3.org/2000/xmlns/", this);
            err.setErrorCode("XTDE0935");
            err.setXPathContext(context);
            throw NamespaceConstructor.dynamicError(this, err, context);
        }
        if (!StandardURIChecker.getInstance().isValidURI(uri)) {
            XPathException de = new XPathException("The string value of the constructed namespace node must be a valid URI");
            de.setErrorCode("XTDE0905");
            de.setXPathContext(context);
            de.setLocator(this);
            throw de;
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("namespace");
        out.startSubsidiaryElement("name");
        this.name.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("select");
        this.getContentExpression().explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

