/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartTagBuffer
extends ProxyReceiver
implements NamespaceResolver {
    protected NodeName elementNameCode;
    protected SchemaType elementTypeCode;
    protected int elementLocationId;
    protected int elementProperties;
    protected AttributeCollectionImpl bufferedAttributes;
    private boolean acceptAttributes;
    private boolean inDocument;
    protected NamespaceBinding[] namespaces = new NamespaceBinding[50];
    protected int namespacesSize = 0;
    private int[] countStack = new int[50];
    private int depth = 0;
    private int attCount = 0;

    public StartTagBuffer(Receiver next) {
        super(next);
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.bufferedAttributes = new AttributeCollectionImpl(pipe.getConfiguration());
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.depth == 0) {
            ++this.depth;
            super.startDocument(properties);
        }
        this.acceptAttributes = false;
        this.inDocument = true;
    }

    @Override
    public void endDocument() throws XPathException {
        if (this.depth == 1) {
            --this.depth;
            super.endDocument();
        }
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, int locationId, int properties) throws XPathException {
        this.elementNameCode = nameCode;
        this.elementTypeCode = typeCode;
        this.elementLocationId = locationId;
        this.elementProperties = properties;
        this.bufferedAttributes.clear();
        this.countStack[this.depth] = 0;
        if (++this.depth >= this.countStack.length) {
            int[] newstack = new int[this.depth * 2];
            System.arraycopy(this.countStack, 0, newstack, 0, this.depth);
            this.countStack = newstack;
        }
        this.acceptAttributes = true;
        this.inDocument = false;
        if ((properties & 0x40) == 0) {
            this.namespace(nameCode.getNamespaceBinding(), 0);
        }
        this.attCount = 0;
    }

    @Override
    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (!this.acceptAttributes) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(13, namespaceBinding.getPrefix(), this.getPipelineConfiguration().getHostLanguage(), this.inDocument, false, null, -1);
        }
        for (int n = 0; n < this.countStack[this.depth - 1]; ++n) {
            if (!this.namespaces[this.namespacesSize - 1 - n].equals(namespaceBinding)) continue;
            return;
        }
        this.addToStack(namespaceBinding);
        int n = this.depth - 1;
        this.countStack[n] = this.countStack[n] + 1;
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (!this.acceptAttributes) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(2, attName.getDisplayName(), this.getPipelineConfiguration().getHostLanguage(), this.inDocument, false, null, -1);
        }
        if ((properties & 0x40) == 0 && !attName.isInNamespace("")) {
            attName = this.checkProposedPrefix(attName, this.attCount++);
        }
        this.bufferedAttributes.addAttribute(attName, typeCode, ((Object)value).toString(), locationId, properties);
    }

    private void addToStack(NamespaceBinding binding) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            NamespaceBinding[] newlist = new NamespaceBinding[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, newlist, 0, this.namespacesSize);
            this.namespaces = newlist;
        }
        this.namespaces[this.namespacesSize++] = binding;
    }

    @Override
    public void startContent() throws XPathException {
        this.nextReceiver.startElement(this.elementNameCode, this.elementTypeCode, this.elementLocationId, this.elementProperties | 0x40);
        this.declareNamespacesForStartElement();
        int length = this.bufferedAttributes.getLength();
        for (int i = 0; i < length; ++i) {
            this.nextReceiver.attribute(this.bufferedAttributes.getNodeName(i), this.bufferedAttributes.getTypeAnnotation(i), this.bufferedAttributes.getValue(i), this.bufferedAttributes.getLocationId(i), this.bufferedAttributes.getProperties(i) | 0x40);
        }
        this.acceptAttributes = false;
        this.nextReceiver.startContent();
    }

    protected void declareNamespacesForStartElement() throws XPathException {
        for (int i = this.namespacesSize - this.countStack[this.depth - 1]; i < this.namespacesSize; ++i) {
            this.nextReceiver.namespace(this.namespaces[i], 0);
        }
    }

    public NamespaceBinding[] getLocalNamespaces() {
        int size = this.countStack[this.depth - 1];
        if (size == 0) {
            return NamespaceBinding.EMPTY_ARRAY;
        }
        NamespaceBinding[] localBindings = new NamespaceBinding[this.countStack[this.depth - 1]];
        System.arraycopy(this.namespaces, this.namespacesSize - size, localBindings, 0, size);
        return localBindings;
    }

    protected void declareAllNamespaces() throws XPathException {
        for (int i = 0; i < this.namespacesSize; ++i) {
            this.nextReceiver.namespace(this.namespaces[i], 0);
        }
    }

    @Override
    public void endElement() throws XPathException {
        this.nextReceiver.endElement();
        this.undeclareNamespacesForElement();
    }

    protected void undeclareNamespacesForElement() {
        this.namespacesSize -= this.countStack[--this.depth];
    }

    public boolean hasAttributes() {
        return this.bufferedAttributes.getLength() > 0;
    }

    public String getAttribute(int nameCode) {
        return this.bufferedAttributes.getValueByFingerprint(nameCode & 0xFFFFF);
    }

    public String getAttribute(String uri, String local) {
        return this.bufferedAttributes.getValue(uri, local);
    }

    public AttributeCollection getAllAttributes() {
        return this.bufferedAttributes;
    }

    public boolean hasAttributeInNamespace(String uri) {
        return this.bufferedAttributes.hasAttributeInNamespace(uri);
    }

    @Override
    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (prefix.length() == 0 && !useDefault) {
            return "";
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            String uri;
            if (!this.namespaces[i].getPrefix().equals(prefix) || (uri = this.namespaces[i].getURI()).length() == 0) continue;
            return uri;
        }
        return prefix.length() == 0 ? "" : null;
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>(this.namespacesSize);
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            String prefix = this.namespaces[i].getPrefix();
            if (prefixes.contains(prefix)) continue;
            prefixes.add(prefix);
        }
        prefixes.add("xml");
        return prefixes.iterator();
    }

    private NodeName checkProposedPrefix(NodeName nameCode, int seq) throws XPathException {
        NamespaceBinding binding = nameCode.getNamespaceBinding();
        String prefix = binding.getPrefix();
        String existingURI = this.getURIForPrefix(prefix, true);
        if (existingURI == null) {
            this.namespace(binding, 0);
            return nameCode;
        }
        if (binding.getURI().equals(existingURI)) {
            return nameCode;
        }
        prefix = this.getSubstitutePrefix(binding, seq);
        FingerprintedQName newCode = new FingerprintedQName(prefix, nameCode.getURI(), nameCode.getLocalPart());
        this.namespace(newCode.getNamespaceBinding(), 0);
        return newCode;
    }

    private String getSubstitutePrefix(NamespaceBinding binding, int seq) {
        String prefix = binding.getPrefix();
        return prefix + '_' + seq;
    }
}

