/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chain
implements GroundedValue {
    private List<GroundedValue> children = new ArrayList<GroundedValue>();

    public Chain(List<GroundedValue> children) {
        this.children = children;
        int size = 0;
        boolean copy = false;
        for (GroundedValue gv : children) {
            if (gv instanceof Chain) {
                if (((Chain)gv).children.size() < 30) {
                    size += ((Chain)gv).children.size();
                    copy = true;
                    continue;
                }
                ++size;
                continue;
            }
            ++size;
        }
        if (copy) {
            this.children = new ArrayList<GroundedValue>(size);
            for (GroundedValue gv : children) {
                if (gv instanceof Chain) {
                    if (((Chain)gv).children.size() < 30) {
                        this.children.addAll(((Chain)gv).children);
                        continue;
                    }
                    this.children.add(gv);
                    continue;
                }
                this.children.add(gv);
            }
        } else {
            this.children = children;
        }
    }

    @Override
    public Item head() throws XPathException {
        for (Sequence sequence : this.children) {
            Item head = sequence.head();
            if (head == null) continue;
            return head;
        }
        return null;
    }

    public SequenceIterator<Item> iterate() {
        return new ChainIterator();
    }

    public void append(GroundedValue sequence) {
        this.children.add(sequence);
    }

    public void append(Item item) {
        if (item instanceof GroundedValue) {
            this.children.add((GroundedValue)((Object)item));
        } else {
            this.children.add(new SingletonItem<Item>(item));
        }
    }

    private void consolidate() {
        try {
            Item item;
            ArrayList<Item> extent = new ArrayList<Item>();
            SequenceIterator<Item> iter = this.iterate();
            while ((item = iter.next()) != null) {
                extent.add(item);
            }
            SequenceExtent replacement = new SequenceExtent(extent);
            this.children = new ArrayList<GroundedValue>(1);
            this.children.add(replacement);
        }
        catch (XPathException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Item itemAt(int n) {
        if (n < 0 || this.children.size() == 0) {
            return null;
        }
        if (this.children.size() > 1) {
            this.consolidate();
        }
        return this.children.get(0).itemAt(n);
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        if (this.children.size() == 0) {
            return EmptySequence.getInstance();
        }
        if (this.children.size() > 1) {
            this.consolidate();
        }
        return this.children.get(0).subsequence(start, length);
    }

    @Override
    public int getLength() {
        int n = 0;
        for (GroundedValue v : this.children) {
            n += v.getLength();
        }
        return n;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public String getStringValue() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public CharSequence getStringValueCS() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public GroundedValue reduce() {
        if (this.children.size() != 1) {
            this.consolidate();
        }
        return this.children.get(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChainIterator
    implements SequenceIterator<Item>,
    GroundedIterator<Item> {
        private Queue<SequenceIterator> queue = new LinkedList<SequenceIterator>();
        private Stack<ChainPosition> stack = new Stack();
        private Item current;
        private int position = 0;

        public ChainIterator() {
            this.stack.push(new ChainPosition(Chain.this, 0));
        }

        @Override
        public Item next() throws XPathException {
            while (!this.queue.isEmpty()) {
                SequenceIterator ui = this.queue.peek();
                while (ui != null) {
                    this.current = ui.next();
                    if (this.current != null) {
                        ++this.position;
                        return this.current;
                    }
                    this.queue.remove();
                    ui = this.queue.peek();
                }
            }
            while (!this.stack.isEmpty()) {
                ChainPosition cp = this.stack.peek();
                if (cp == null) continue;
                GroundedValue gv = (GroundedValue)cp.chain.children.get(cp.offset);
                if (++cp.offset >= cp.chain.children.size()) {
                    this.stack.pop();
                }
                if (gv instanceof Chain) {
                    this.stack.push(new ChainPosition((Chain)gv, 0));
                    continue;
                }
                try {
                    this.queue.offer(gv.iterate());
                }
                catch (XPathException e) {
                    throw new AssertionError((Object)e);
                }
                return this.next();
            }
            this.current = null;
            this.position = -1;
            return null;
        }

        @Override
        public Item current() {
            return this.current;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void close() {
        }

        public ChainIterator getAnother() {
            return new ChainIterator();
        }

        @Override
        public int getProperties() {
            return 1;
        }

        @Override
        public GroundedValue materialize() throws XPathException {
            return Chain.this;
        }

        private class ChainPosition {
            Chain chain;
            int offset;

            public ChainPosition(Chain chain, int offset) {
                this.chain = chain;
                this.offset = offset;
            }
        }
    }
}

