/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicArray
implements AtomicSequence {
    private AtomicValue[] content;

    public AtomicArray(AtomicValue[] content) {
        this.content = content;
    }

    public AtomicArray(SequenceIterator iter) throws XPathException {
        Object item;
        ArrayList<AtomicValue> list = new ArrayList<AtomicValue>(10);
        while ((item = iter.next()) != null) {
            if (!(item instanceof AtomicValue)) {
                throw new IllegalArgumentException();
            }
            list.add((AtomicValue)item);
        }
        AtomicValue[] av = new AtomicValue[list.size()];
        this.content = list.toArray(av);
    }

    @Override
    public AtomicValue head() {
        return this.content.length > 0 ? this.content[0] : null;
    }

    public SequenceIterator<AtomicValue> iterate() {
        return new ArrayIterator((Item[])this.content);
    }

    @Override
    public AtomicValue itemAt(int n) {
        if (n >= 0 && n < this.content.length) {
            return this.content[n];
        }
        return null;
    }

    @Override
    public int getLength() {
        return this.content.length;
    }

    @Override
    public AtomicArray subsequence(int start, int length) {
        if (start < 0) {
            start = 0;
        }
        if (start + length > this.content.length) {
            length = this.content.length - start;
        }
        AtomicValue[] av = new AtomicValue[length];
        System.arraycopy(this.content, start, av, 0, length);
        return new AtomicArray(av);
    }

    @Override
    public CharSequence getCanonicalLexicalRepresentation() {
        return this.getStringValueCS();
    }

    @Override
    public CharSequence getStringValueCS() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        boolean first = true;
        for (AtomicValue av : this.content) {
            if (!first) {
                fsb.append(' ');
            } else {
                first = false;
            }
            fsb.append(av.getStringValueCS());
        }
        return fsb.condense();
    }

    @Override
    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public Comparable getSchemaComparable() {
        if (this.content.length == 1) {
            return this.content[0].getSchemaComparable();
        }
        return new ValueSchemaComparable();
    }

    @Override
    public GroundedValue reduce() {
        int len = this.getLength();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            return this.itemAt(0);
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueSchemaComparable
    implements Comparable<ValueSchemaComparable> {
        private ValueSchemaComparable() {
        }

        public AtomicArray getValue() {
            return AtomicArray.this;
        }

        @Override
        public int compareTo(ValueSchemaComparable obj) {
            try {
                AtomicValue item2;
                AtomicValue item1;
                int c;
                SequenceIterator<AtomicValue> iter1 = this.getValue().iterate();
                SequenceIterator<AtomicValue> iter2 = obj.getValue().iterate();
                do {
                    item1 = iter1.next();
                    item2 = iter2.next();
                    if (item1 == null && item2 == null) {
                        return 0;
                    }
                    if (item1 == null) {
                        return -1;
                    }
                    if (item2 != null) continue;
                    return 1;
                } while ((c = item1.getSchemaComparable().compareTo(item2.getSchemaComparable())) == 0);
                return c;
            }
            catch (XPathException e) {
                throw new AssertionError((Object)("Failure comparing schema values: " + e.getMessage()));
            }
        }

        public boolean equals(Object obj) {
            return ValueSchemaComparable.class.isAssignableFrom(obj.getClass()) && this.compareTo((ValueSchemaComparable)obj) == 0;
        }

        public int hashCode() {
            try {
                int hash = 107189858;
                SequenceIterator<AtomicValue> iter = this.getValue().iterate();
                while (true) {
                    AtomicValue item;
                    if ((item = iter.next()) == null) {
                        return hash;
                    }
                    if (!(item instanceof AtomicValue)) continue;
                    hash ^= item.getSchemaComparable().hashCode();
                }
            }
            catch (XPathException e) {
                return 0;
            }
        }
    }
}

