////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2018-2023 Saxonica Limited
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at http://mozilla.org/MPL/2.0/.
// This Source Code Form is "Incompatible With Secondary Licenses", as defined by the Mozilla Public License, v. 2.0.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * <p>This package provides utility routines for sorting and grouping.
 * Specifically, it contains a QuickSort implementation,
 * and some <code>AtomicComparer</code> objects that handle character and numeric comparisons, together
 * with the important <code>DocumentOrderIterator</code> which iterates over a set of nodes in document
 * order.</p>
 * <p>The package also
 * contains the classes to support the implementation of the XSLT 2.0 instruction
 * <code>xsl:for-each-group</code>, and some utilities for maintaining sets and maps whose keys
 * are unboxed integer values.</p>
 */
package net.sf.saxon.expr.sort;
