/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.Instrumentation;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.value.Closure;

public class MemoClosure
extends Closure
implements ContextOriginator {
    private Sequence sequence;

    public MemoClosure(Expression expr, PullEvaluator inputEvaluator, XPathContext context) throws XPathException {
        Instrumentation.count("MemoClosure(X)");
        this.setInputEvaluator(inputEvaluator);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        this.setSavedXPathContext(c2);
        this.saveContext(expr, context);
    }

    public MemoClosure(Expression expr, XPathContext context) throws XPathException {
        Instrumentation.count("MemoClosure(X)");
        this.setInputEvaluator(expr.makeElaborator().elaborateForPull());
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        this.setSavedXPathContext(c2);
        this.saveContext(expr, context);
    }

    @Override
    public synchronized SequenceIterator iterate() {
        try {
            this.makeSequence();
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
        return this.sequence.iterate();
    }

    private void makeSequence() throws XPathException {
        if (this.sequence == null) {
            this.inputIterator = this.inputEvaluator.iterate(this.savedXPathContext);
            if (this.inputIterator instanceof GroundedIterator && ((GroundedIterator)this.inputIterator).isActuallyGrounded()) {
                this.sequence = ((GroundedIterator)this.inputIterator).materialize();
                if (this.learningEvaluator != null) {
                    this.learningEvaluator.reportCompletion(this.serialNumber);
                }
            } else {
                this.sequence = SequenceTool.toMemoSequence(this.inputIterator);
                if (this.sequence instanceof MemoSequence && this.learningEvaluator != null) {
                    ((MemoSequence)this.sequence).setLearningEvaluator(this.learningEvaluator, this.serialNumber);
                }
            }
        }
    }

    public synchronized Item itemAt(int n) throws XPathException {
        this.makeSequence();
        if (this.sequence instanceof GroundedValue) {
            return ((GroundedValue)this.sequence).itemAt(n);
        }
        if (this.sequence instanceof MemoSequence) {
            return ((MemoSequence)this.sequence).itemAt(n);
        }
        throw new IllegalStateException();
    }

    @Override
    public GroundedValue reduce() throws XPathException {
        try {
            if (this.sequence instanceof GroundedValue) {
                return (GroundedValue)this.sequence;
            }
            return SequenceTool.toGroundedValue(this.iterate());
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }

    @Override
    public Sequence makeRepeatable() {
        return this;
    }
}

