/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Stack;
import java.util.function.IntPredicate;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.CharacterReferenceGenerator;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.HexCharacterReferenceGenerator;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeChar;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.WhitespaceString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntIterator;

public class XMLEmitter
extends Emitter {
    protected boolean canonical = false;
    protected boolean started = false;
    protected boolean startedElement = false;
    protected boolean openStartTag = false;
    protected boolean declarationIsWritten = false;
    protected NodeName elementCode;
    protected int indentForNextAttribute = -1;
    protected boolean undeclareNamespaces = false;
    protected boolean unfailing = false;
    protected String internalSubset = null;
    protected char delimiter = (char)34;
    protected boolean[] attSpecials = specialInAtt;
    protected Stack<String> elementStack = new Stack();
    private boolean indenting = false;
    private boolean requireWellFormed = false;
    protected CharacterReferenceGenerator characterReferenceGenerator = HexCharacterReferenceGenerator.THE_INSTANCE;
    protected static boolean[] specialInText;
    protected static boolean[] specialInAtt;
    protected static boolean[] specialInAttSingle;
    IntPredicate isSpecialInText;
    IntPredicate isSpecialInAttribute;
    private static final byte[] XML_DECL_VERSION;
    private static final byte[] XML_DECL_ENCODING;
    private static final byte[] XML_DECL_STANDALONE;
    private static final byte[] QUOTE_SPACE;
    protected static final byte[] DOCTYPE;
    private static final byte[] SYSTEM;
    private static final byte[] PUBLIC;
    protected static final byte[] RIGHT_ANGLE_NEWLINE;

    public void setCharacterReferenceGenerator(CharacterReferenceGenerator generator) {
        this.characterReferenceGenerator = generator;
    }

    public void setEscapeNonAscii(Boolean escape) {
    }

    @Override
    public void open() throws XPathException {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
    }

    @Override
    public void endDocument() throws XPathException {
    }

    protected void openDocument() throws XPathException {
        assert (this.writer != null);
        if (this.characterSet == null) {
            this.characterSet = UTF8CharacterSet.getInstance();
        }
        if (this.outputProperties == null) {
            this.outputProperties = new Properties();
        }
        this.undeclareNamespaces = "yes".equals(this.outputProperties.getProperty("undeclare-prefixes"));
        this.canonical = "yes".equals(this.outputProperties.getProperty("{http://saxon.sf.net/}canonical"));
        this.unfailing = "yes".equals(this.outputProperties.getProperty("{http://saxon.sf.net/}unfailing"));
        this.internalSubset = this.outputProperties.getProperty("{http://saxon.sf.net/}internal-dtd-subset");
        if ("yes".equals(this.outputProperties.getProperty("{http://saxon.sf.net/}single-quotes"))) {
            this.delimiter = (char)39;
            this.attSpecials = specialInAttSingle;
        }
        if (this.allCharactersEncodable) {
            this.isSpecialInText = c -> c < 127 ? specialInText[c] : c < 160 || c == 8232;
            this.isSpecialInAttribute = c -> c < 127 ? this.attSpecials[c] : c < 160 || c == 8232;
        } else {
            this.isSpecialInText = c -> c < 127 ? specialInText[c] : c < 160 || c == 8232 || c > 65535 || !this.characterSet.inCharset(c);
            this.isSpecialInAttribute = c -> c < 127 ? this.attSpecials[c] : c < 160 || c == 8232 || c > 65535 || !this.characterSet.inCharset(c);
        }
        this.writeDeclaration();
    }

    public void writeDeclaration() throws XPathException {
        if (this.declarationIsWritten) {
            return;
        }
        this.declarationIsWritten = true;
        try {
            String systemId;
            String standalone;
            String version;
            String omitXMLDeclaration;
            this.indenting = "yes".equals(this.outputProperties.getProperty("indent"));
            String byteOrderMark = this.outputProperties.getProperty("byte-order-mark");
            String encoding = this.outputProperties.getProperty("encoding");
            if (encoding == null || encoding.equalsIgnoreCase("utf8") || this.canonical) {
                encoding = "UTF-8";
            }
            if ("yes".equals(byteOrderMark) && !this.canonical && ("UTF-8".equalsIgnoreCase(encoding) || "UTF-16LE".equalsIgnoreCase(encoding) || "UTF-16BE".equalsIgnoreCase(encoding))) {
                this.writer.writeCodePoint(65279);
            }
            if ((omitXMLDeclaration = this.outputProperties.getProperty("omit-xml-declaration")) == null) {
                omitXMLDeclaration = "no";
            }
            if (this.canonical) {
                omitXMLDeclaration = "yes";
            }
            if ((version = this.outputProperties.getProperty("version")) == null) {
                version = this.getConfiguration().getXMLVersion() == 10 ? "1.0" : "1.1";
            } else {
                if (!version.equals("1.0") && !version.equals("1.1")) {
                    if (this.unfailing) {
                        version = "1.0";
                    } else {
                        XPathException err = new XPathException("XML version must be 1.0 or 1.1");
                        err.setErrorCode("SESU0013");
                        throw err;
                    }
                }
                if (!version.equals("1.0") && omitXMLDeclaration.equals("yes") && this.outputProperties.getProperty("doctype-system") != null && !this.unfailing) {
                    XPathException err = new XPathException("Values of 'version', 'omit-xml-declaration', and 'doctype-system' conflict");
                    err.setErrorCode("SEPM0009");
                    throw err;
                }
            }
            String undeclare = this.outputProperties.getProperty("undeclare-prefixes");
            if ("yes".equals(undeclare)) {
                this.undeclareNamespaces = true;
            }
            if (version.equals("1.0") && this.undeclareNamespaces) {
                if (this.unfailing) {
                    this.undeclareNamespaces = false;
                } else {
                    XPathException err = new XPathException("Cannot undeclare namespaces with XML version 1.0");
                    err.setErrorCode("SEPM0010");
                    throw err;
                }
            }
            if ("omit".equals(standalone = this.outputProperties.getProperty("standalone"))) {
                standalone = null;
            }
            if (standalone != null) {
                this.requireWellFormed = true;
                if (omitXMLDeclaration.equals("yes") && !this.unfailing) {
                    XPathException err = new XPathException("Values of 'standalone' and 'omit-xml-declaration' conflict");
                    err.setErrorCode("SEPM0009");
                    throw err;
                }
            }
            if ((systemId = this.outputProperties.getProperty("doctype-system")) != null && !"".equals(systemId)) {
                this.requireWellFormed = true;
            }
            if (omitXMLDeclaration.equals("no")) {
                this.writer.writeAscii(XML_DECL_VERSION);
                this.writer.write(version);
                this.writer.writeAscii(QUOTE_SPACE);
                this.writer.writeAscii(XML_DECL_ENCODING);
                this.writer.write(encoding);
                this.writer.writeCodePoint(34);
                if (standalone != null) {
                    this.writer.writeAscii(XML_DECL_STANDALONE);
                    this.writer.write(standalone);
                    this.writer.writeCodePoint(34);
                }
                this.writer.writeAscii(StringConstants.PI_END);
            }
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
    }

    protected void writeDocType(NodeName name, String displayName, String systemId, String publicId) throws XPathException {
        try {
            if (!this.canonical) {
                if (this.declarationIsWritten && !this.indenting) {
                    this.writer.writeCodePoint(10);
                }
                this.writer.writeAscii(DOCTYPE);
                this.writer.write(displayName);
                this.writer.writeCodePoint(10);
                String quotedSystemId = null;
                if (systemId != null) {
                    quotedSystemId = systemId.contains("\"") ? "'" + systemId + "'" : "\"" + systemId + "\"";
                }
                if (systemId != null && publicId == null) {
                    this.writer.writeAscii(SYSTEM);
                    this.writer.write(quotedSystemId);
                } else if (systemId == null && publicId != null) {
                    this.writer.writeAscii(PUBLIC);
                    this.writer.write(publicId);
                    this.writer.writeCodePoint(34);
                } else if (publicId != null) {
                    this.writer.writeAscii(PUBLIC);
                    this.writer.write(publicId);
                    this.writer.writeAscii(QUOTE_SPACE);
                    this.writer.write(quotedSystemId);
                }
                if (this.internalSubset != null) {
                    this.writer.writeCodePoint(91);
                    this.writer.writeCodePoint(10);
                    this.writer.write(this.internalSubset);
                    this.writer.writeCodePoint(10);
                    this.writer.writeCodePoint(93);
                }
                this.writer.writeAscii(RIGHT_ANGLE_NEWLINE);
            }
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.started) {
            this.openDocument();
        }
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
        super.close();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        int badchar;
        this.previousAtomic = false;
        if (!this.started) {
            this.openDocument();
        } else if (this.requireWellFormed && this.elementStack.isEmpty() && this.startedElement && !this.unfailing) {
            XPathException err = new XPathException("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains more than one top-level element");
            err.setErrorCode("SEPM0004");
            throw err;
        }
        this.startedElement = true;
        String displayName = elemName.getDisplayName();
        if (!this.allCharactersEncodable && (badchar = this.testCharacters(StringView.of(displayName))) != 0) {
            XPathException err = new XPathException("Element name contains a character (decimal + " + badchar + ") not available in the selected encoding");
            err.setErrorCode("SERE0008");
            throw err;
        }
        this.elementStack.push(displayName);
        this.elementCode = elemName;
        try {
            if (!this.started) {
                String systemId = this.outputProperties.getProperty("doctype-system");
                String publicId = this.outputProperties.getProperty("doctype-public");
                if ("".equals(systemId)) {
                    systemId = null;
                }
                if ("".equals(publicId)) {
                    publicId = null;
                }
                if (systemId != null) {
                    this.requireWellFormed = true;
                    this.writeDocType(elemName, displayName, systemId, publicId);
                } else if (this.writeDocTypeWithNullSystemId()) {
                    this.writeDocType(elemName, displayName, null, publicId);
                }
                this.started = true;
            }
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.writeCodePoint(60);
            this.writer.write(displayName);
            if (this.indentForNextAttribute >= 0) {
                this.indentForNextAttribute += displayName.length();
            }
            boolean isFirst = true;
            for (NamespaceBinding ns : namespaces) {
                this.namespace(ns.getPrefix(), ns.getNamespaceUri(), isFirst);
                isFirst = false;
            }
            for (AttributeInfo att : attributes) {
                this.attribute(att.getNodeName(), att.getValue(), att.getProperties(), isFirst);
                isFirst = false;
            }
            this.openStartTag = true;
            this.indentForNextAttribute = -1;
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
    }

    protected boolean writeDocTypeWithNullSystemId() {
        return this.internalSubset != null;
    }

    public void namespace(String nsprefix, NamespaceUri nsuri, boolean isFirst) throws XPathException {
        try {
            if (nsprefix.isEmpty()) {
                if (isFirst) {
                    this.writer.writeCodePoint(32);
                } else {
                    this.writeAttributeIndentString();
                }
                this.writeAttribute(this.elementCode, "xmlns", nsuri.toString(), 0);
            } else if (!nsprefix.equals("xml")) {
                int badchar = this.testCharacters(StringView.of(nsprefix));
                if (badchar != 0) {
                    XPathException err = new XPathException("Namespace prefix contains a character (decimal + " + badchar + ") not available in the selected encoding");
                    err.setErrorCode("SERE0008");
                    throw err;
                }
                if (this.undeclareNamespaces || !nsuri.isEmpty()) {
                    if (isFirst) {
                        this.writer.writeCodePoint(32);
                    } else {
                        this.writeAttributeIndentString();
                    }
                    this.writeAttribute(this.elementCode, "xmlns:" + nsprefix, nsuri.toString(), 0);
                }
            }
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
    }

    public void setIndentForNextAttribute(int indent) {
        this.indentForNextAttribute = indent;
    }

    private void attribute(NodeName nameCode, String value, int properties, boolean isFirst) throws XPathException {
        int badchar;
        String displayName = nameCode.getDisplayName();
        if (!this.allCharactersEncodable && (badchar = this.testCharacters(StringView.of(displayName))) != 0) {
            if (this.unfailing) {
                displayName = this.convertToAscii(StringView.of(displayName)).toString();
            } else {
                XPathException err = new XPathException("Attribute name contains a character (decimal + " + badchar + ") not available in the selected encoding");
                err.setErrorCode("SERE0008");
                throw err;
            }
        }
        try {
            if (isFirst) {
                this.writer.writeCodePoint(32);
            } else {
                this.writeAttributeIndentString();
            }
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
        this.writeAttribute(this.elementCode, displayName, value, properties);
    }

    protected void writeAttributeIndentString() throws IOException {
        if (this.indentForNextAttribute < 0) {
            this.writer.writeCodePoint(32);
        } else {
            this.writer.writeCodePoint(10);
            this.writer.writeRepeatedAscii((byte)32, this.indentForNextAttribute);
        }
    }

    public void closeStartTag() throws XPathException {
        try {
            if (this.openStartTag) {
                this.writer.writeCodePoint(62);
                this.openStartTag = false;
            }
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
    }

    protected void writeEmptyElementTagCloser(String displayName, NodeName nameCode) throws IOException {
        if (this.canonical) {
            this.writer.writeCodePoint(62);
            this.writer.writeAscii(StringConstants.END_TAG_START);
            this.writer.write(displayName);
            this.writer.writeCodePoint(62);
        } else {
            this.writer.writeAscii(StringConstants.EMPTY_TAG_END);
        }
    }

    protected void writeAttribute(NodeName elCode, String attname, String value, int properties) throws XPathException {
        try {
            this.writer.write(attname);
            if (ReceiverOption.contains(properties, 4)) {
                this.writer.writeCodePoint(61);
                this.writer.writeCodePoint(this.delimiter);
                this.writer.write(value);
                this.writer.writeCodePoint(this.delimiter);
            } else if (ReceiverOption.contains(properties, 256)) {
                this.writer.writeCodePoint(61);
                int delim = value.indexOf(34) >= 0 && value.indexOf(39) < 0 ? 39 : this.delimiter;
                this.writer.writeCodePoint(delim);
                this.writeEscape(StringView.tidy(value), true);
                this.writer.writeCodePoint(delim);
            } else {
                this.writer.writeCodePoint(61);
                this.writer.writeCodePoint(this.delimiter);
                if (ReceiverOption.contains(properties, 1)) {
                    this.writer.write(value);
                } else {
                    this.writeEscape(StringView.tidy(value), true);
                }
                this.writer.writeCodePoint(this.delimiter);
            }
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
    }

    protected int testCharacters(UnicodeString chars) {
        long foundInvalid = chars.indexWhere(ch -> ch > 127 && !this.characterSet.inCharset(ch), 0L);
        if (foundInvalid >= 0L) {
            return chars.codePointAt(foundInvalid);
        }
        return 0;
    }

    protected UnicodeString convertToAscii(UnicodeString chars) {
        UnicodeBuilder buff = new UnicodeBuilder();
        IntIterator iter = chars.codePoints();
        while (iter.hasNext()) {
            int c = iter.next();
            if (c >= 20 && c < 127) {
                buff.append(c);
                continue;
            }
            buff.append("_" + c + "_");
        }
        return buff.toUnicodeString();
    }

    @Override
    public void endElement() throws XPathException {
        String displayName = this.elementStack.pop();
        try {
            if (this.openStartTag) {
                this.writeEmptyElementTagCloser(displayName, this.elementCode);
                this.openStartTag = false;
            } else {
                this.writer.writeAscii(StringConstants.END_TAG_START);
                this.writer.write(displayName);
                this.writer.writeCodePoint(62);
            }
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (!this.started) {
            this.openDocument();
        }
        if (this.requireWellFormed && this.elementStack.isEmpty() && !Whitespace.isAllWhite(chars) && !this.unfailing) {
            XPathException err = new XPathException("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains a top-level text node");
            err.setErrorCode("SEPM0004");
            throw err;
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            if (chars instanceof WhitespaceString) {
                ((WhitespaceString)chars).write(this.writer);
            } else if (ReceiverOption.contains(properties, 4)) {
                this.writer.write(chars);
            } else if (!ReceiverOption.contains(properties, 1)) {
                this.writeEscape(chars, false);
            } else if (this.testCharacters(chars) == 0) {
                if (!ReceiverOption.contains(properties, 256)) {
                    this.writer.write(chars);
                } else {
                    IntIterator iter = chars.codePoints();
                    while (iter.hasNext()) {
                        int c = iter.next();
                        if (c == 0) continue;
                        this.writer.writeCodePoint(c);
                    }
                }
            } else {
                IntIterator iter = chars.codePoints();
                while (iter.hasNext()) {
                    int c = iter.next();
                    if (c == 0) continue;
                    if (this.characterSet.inCharset(c)) {
                        this.writer.writeCodePoint(c);
                        continue;
                    }
                    this.writeEscape(new UnicodeChar(c), false);
                }
            }
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        int x;
        if (!this.started) {
            this.openDocument();
        }
        if ((x = this.testCharacters(StringView.of(target))) != 0) {
            if (this.unfailing) {
                target = this.convertToAscii(StringView.of(target)).toString();
            } else {
                XPathException err = new XPathException("Character in processing instruction name cannot be represented in the selected encoding (code " + x + ")");
                err.setErrorCode("SERE0008");
                throw err;
            }
        }
        if ((x = this.testCharacters(data)) != 0) {
            if (this.unfailing) {
                data = this.convertToAscii(data);
            } else {
                XPathException err = new XPathException("Character in processing instruction data cannot be represented in the selected encoding (code " + x + ")");
                err.setErrorCode("SERE0008");
                throw err;
            }
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.writeAscii(StringConstants.PI_START);
            this.writer.write(target);
            if (!data.isEmpty()) {
                this.writer.writeCodePoint(32);
                this.writer.write(data);
            }
            this.writer.writeAscii(StringConstants.PI_END);
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
    }

    protected void writeEscape(UnicodeString chars, boolean inAttribute) throws IOException, XPathException {
        boolean[] specialChars;
        long segstart = 0L;
        boolean disabled = false;
        boolean[] blArray = specialChars = inAttribute ? this.attSpecials : specialInText;
        if (chars instanceof WhitespaceString) {
            ((WhitespaceString)chars).writeEscape(specialChars, this.writer);
            return;
        }
        IntPredicate special = inAttribute ? this.isSpecialInAttribute : this.isSpecialInText;
        long clength = chars.length();
        while (segstart < clength) {
            int c;
            long i;
            long found = chars.indexWhere(special, segstart);
            long l = i = found == -1L ? clength : found;
            if (found < 0L) {
                if (segstart == 0L) {
                    this.writer.write(chars);
                } else {
                    this.writer.write(chars.substring(segstart, clength));
                }
                return;
            }
            if (i > segstart) {
                this.writer.write(chars.substring(segstart, i));
            }
            if ((c = chars.codePointAt(i)) == 0) {
                disabled = !disabled;
            } else if (disabled) {
                if (c > 127 && !this.characterSet.inCharset(c)) {
                    XPathException de = new XPathException("Character " + c + " (x" + Integer.toHexString(c) + ") is not available in the chosen encoding");
                    de.setErrorCode("SERE0008");
                    throw de;
                }
                this.writeCodePoint(c);
            } else if (c < 127) {
                switch (c) {
                    case 60: {
                        this.writer.writeAscii(StringConstants.ESCAPE_LT);
                        break;
                    }
                    case 62: {
                        this.writer.writeAscii(StringConstants.ESCAPE_GT);
                        break;
                    }
                    case 38: {
                        this.writer.writeAscii(StringConstants.ESCAPE_AMP);
                        break;
                    }
                    case 34: {
                        this.writer.writeAscii(StringConstants.ESCAPE_QUOT);
                        break;
                    }
                    case 39: {
                        this.writer.writeAscii(StringConstants.ESCAPE_APOS);
                        break;
                    }
                    case 10: {
                        this.writer.writeAscii(StringConstants.ESCAPE_NL);
                        break;
                    }
                    case 13: {
                        this.writer.writeAscii(StringConstants.ESCAPE_CR);
                        break;
                    }
                    case 9: {
                        this.writer.writeAscii(StringConstants.ESCAPE_TAB);
                        break;
                    }
                    default: {
                        this.characterReferenceGenerator.outputCharacterReference(c, this.writer);
                        break;
                    }
                }
            } else if (c < 160 || c == 8232) {
                this.characterReferenceGenerator.outputCharacterReference(c, this.writer);
            } else if (c > 65535) {
                if (this.characterSet.inCharset(c)) {
                    this.writeCodePoint(c);
                } else {
                    this.characterReferenceGenerator.outputCharacterReference(c, this.writer);
                }
            } else {
                this.characterReferenceGenerator.outputCharacterReference(c, this.writer);
            }
            segstart = ++i;
        }
    }

    protected void writeCodePoint(int c) throws IOException {
        this.writer.writeCodePoint(c);
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        int x;
        if (!this.started) {
            this.openDocument();
        }
        if ((x = this.testCharacters(chars)) != 0) {
            if (this.unfailing) {
                chars = this.convertToAscii(chars);
            } else {
                XPathException err = new XPathException("Character in comment cannot be represented in the selected encoding (code " + x + ")");
                err.setErrorCode("SERE0008");
                throw err;
            }
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.writeAscii(StringConstants.COMMENT_START);
            this.writer.write(chars);
            this.writer.writeAscii(StringConstants.COMMENT_END);
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public boolean isStarted() {
        return this.started;
    }

    static {
        int i;
        specialInText = new boolean[128];
        for (i = 0; i <= 31; ++i) {
            XMLEmitter.specialInText[i] = true;
        }
        for (i = 32; i <= 127; ++i) {
            XMLEmitter.specialInText[i] = false;
        }
        XMLEmitter.specialInText[10] = false;
        XMLEmitter.specialInText[9] = false;
        XMLEmitter.specialInText[13] = true;
        XMLEmitter.specialInText[60] = true;
        XMLEmitter.specialInText[62] = true;
        XMLEmitter.specialInText[38] = true;
        specialInAtt = new boolean[128];
        for (i = 0; i <= 31; ++i) {
            XMLEmitter.specialInAtt[i] = true;
        }
        for (i = 32; i <= 127; ++i) {
            XMLEmitter.specialInAtt[i] = false;
        }
        XMLEmitter.specialInAtt[0] = true;
        XMLEmitter.specialInAtt[13] = true;
        XMLEmitter.specialInAtt[10] = true;
        XMLEmitter.specialInAtt[9] = true;
        XMLEmitter.specialInAtt[60] = true;
        XMLEmitter.specialInAtt[62] = true;
        XMLEmitter.specialInAtt[38] = true;
        XMLEmitter.specialInAtt[34] = true;
        specialInAttSingle = Arrays.copyOf(specialInAtt, 128);
        XMLEmitter.specialInAttSingle[34] = false;
        XMLEmitter.specialInAttSingle[39] = true;
        XML_DECL_VERSION = StringConstants.bytes("<?xml version=\"");
        XML_DECL_ENCODING = StringConstants.bytes("encoding=\"");
        XML_DECL_STANDALONE = StringConstants.bytes(" standalone=\"");
        QUOTE_SPACE = StringConstants.bytes("\" ");
        DOCTYPE = StringConstants.bytes("<!DOCTYPE ");
        SYSTEM = StringConstants.bytes("  SYSTEM ");
        PUBLIC = StringConstants.bytes("  PUBLIC \"");
        RIGHT_ANGLE_NEWLINE = StringConstants.bytes(">\n");
    }
}

