/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.query.InputStreamMarker;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.BinaryResource;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.transpile.CSharp;

public class UnknownResource
implements Resource {
    private final XPathContext context;
    private final AbstractResourceCollection.InputDetails details;
    public static final ResourceFactory FACTORY = CSharp.constructorRef(UnknownResource::new, 2);

    public UnknownResource(XPathContext context, AbstractResourceCollection.InputDetails details) {
        this.context = context;
        this.details = details;
    }

    @Override
    public String getResourceURI() {
        return this.details.resourceUri;
    }

    @Override
    public Item getItem() throws XPathException {
        String mediaType;
        InputStream stream;
        if (this.details.binaryContent != null) {
            stream = new ByteArrayInputStream(this.details.binaryContent);
        } else {
            try {
                stream = this.details.getInputStream();
            }
            catch (IOException e) {
                if (this.details.onError == 1) {
                    throw new XPathException(e);
                }
                return null;
            }
        }
        if (stream == null) {
            throw new XPathException("Unable to dereference resource URI " + this.details.resourceUri);
        }
        try {
            stream = InputStreamMarker.ensureMarkSupported(stream);
            mediaType = URLConnection.guessContentTypeFromStream(stream);
        }
        catch (IOException e) {
            mediaType = null;
        }
        if (mediaType == null) {
            mediaType = this.context.getConfiguration().getMediaTypeForFileExtension("");
        }
        if (mediaType == null || mediaType.equals("application/unknown")) {
            mediaType = "application/binary";
        }
        this.details.contentType = mediaType;
        this.details.binaryContent = BinaryResource.readBinaryFromStream(stream, this.details.resourceUri);
        ResourceFactory delegee = this.context.getConfiguration().getResourceFactoryForMediaType(mediaType);
        Resource actual = delegee.makeResource(this.context, this.details);
        return actual.getItem();
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }
}

