/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.IntPredicate;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UniStringConsumer;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.StringToDouble11;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class JsonReceiver
implements Receiver {
    private XPathContext context;
    private PipelineConfiguration pipe;
    private UniStringConsumer output;
    private final StringBuilder textBuffer = new StringBuilder(128);
    private final Stack<NodeName> stack = new Stack();
    private boolean atStart = true;
    private boolean indenting = false;
    private boolean escaped = false;
    private final Stack<Set<String>> keyChecker = new Stack();
    private FunctionItem numberFormatter = null;
    private static final String ERR_INPUT = "FOJS0006";
    private IntPredicate isControlChar = c -> c < 31 || c >= 127 && c <= 159;

    public JsonReceiver(PipelineConfiguration pipe, XPathContext context, UniStringConsumer output) {
        Objects.requireNonNull(pipe);
        Objects.requireNonNull(output);
        this.setPipelineConfiguration(pipe);
        this.output = output;
        this.context = context;
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    @Override
    public void setSystemId(String systemId) {
    }

    public void setIndenting(boolean indenting) {
        this.indenting = indenting;
    }

    public boolean isIndenting() {
        return this.indenting;
    }

    public void setNumberFormatter(FunctionItem formatter) {
        assert (formatter.getArity() == 1);
        this.numberFormatter = formatter;
    }

    public FunctionItem getNumberFormatter() {
        return this.numberFormatter;
    }

    @Override
    public void open() throws XPathException {
        this.output.open();
    }

    @Override
    public void startDocument(int properties) throws XPathException {
    }

    @Override
    public void endDocument() throws XPathException {
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        String parent = this.stack.empty() ? null : this.stack.peek().getLocalPart();
        boolean inMap = "map".equals(parent) || this.stack.isEmpty();
        this.stack.push(elemName);
        if (!elemName.hasURI(NamespaceUri.FN)) {
            throw new XPathException("xml-to-json: element found in wrong namespace: " + elemName.getStructuredQName().getEQName(), ERR_INPUT);
        }
        String key = null;
        String escapedAtt = null;
        String escapedKey = null;
        for (AttributeInfo att : attributes) {
            NodeName attName = att.getNodeName();
            if (attName.hasURI(NamespaceUri.NULL)) {
                switch (attName.getLocalPart()) {
                    case "key": {
                        if (!inMap) {
                            throw new XPathException("xml-to-json: The key attribute is allowed only on elements within a map", ERR_INPUT);
                        }
                        key = att.getValue();
                        break;
                    }
                    case "escaped-key": {
                        if (!inMap) {
                            throw new XPathException("xml-to-json: The escaped-key attribute is allowed only on elements within a map", ERR_INPUT);
                        }
                        escapedKey = att.getValue();
                        break;
                    }
                    case "escaped": {
                        boolean allowed;
                        boolean bl = allowed = this.stack.size() == 1 || elemName.getLocalPart().equals("string");
                        if (!allowed) {
                            throw new XPathException("xml-to-json: The escaped attribute is allowed only on the <string> element", ERR_INPUT);
                        }
                        escapedAtt = att.getValue();
                        break;
                    }
                    default: {
                        throw new XPathException("xml-to-json: Disallowed attribute in input: " + attName.getDisplayName(), ERR_INPUT);
                    }
                }
                continue;
            }
            if (!attName.hasURI(NamespaceUri.FN)) continue;
            throw new XPathException("xml-to-json: Disallowed attribute in input: " + attName.getDisplayName(), ERR_INPUT);
        }
        if (!this.atStart) {
            this.output.accept(BMPString.of(","));
            if (this.indenting) {
                this.indent(this.stack.size());
            }
        }
        if (inMap && !this.keyChecker.isEmpty()) {
            if (key == null) {
                throw new XPathException("xml-to-json: Child elements of <map> must have a key attribute", ERR_INPUT);
            }
            boolean alreadyEscaped = false;
            if (escapedKey != null) {
                try {
                    alreadyEscaped = StringConverter.StringToBoolean.INSTANCE.convertString(StringView.tidy(escapedKey)).asAtomic().effectiveBooleanValue();
                }
                catch (XPathException e) {
                    throw new XPathException("xml-to-json: Value of escaped-key attribute '" + Err.wrap(escapedKey) + "' is not a valid xs:boolean", ERR_INPUT);
                }
            }
            key = alreadyEscaped ? JsonReceiver.handleEscapedString(key) : JsonReceiver.escape(key, false, this.isControlChar);
            String normalizedKey = alreadyEscaped ? JsonReceiver.unescape(key) : key;
            boolean added = this.keyChecker.peek().add(normalizedKey);
            if (!added) {
                throw new XPathException("xml-to-json: duplicate key value " + Err.wrap(key), ERR_INPUT);
            }
            String base = this.indenting ? " : " : ":";
            this.output.accept(BMPString.of("\"")).accept(StringView.of(key)).accept(BMPString.of("\"")).accept(BMPString.of(base));
        }
        String local = elemName.getLocalPart();
        this.checkParent(local, parent);
        switch (local) {
            case "array": {
                if (this.indenting) {
                    this.indent(this.stack.size());
                    this.output.accept(BMPString.of("[ "));
                } else {
                    this.output.accept(BMPString.of("["));
                }
                this.atStart = true;
                break;
            }
            case "map": {
                if (this.indenting) {
                    this.indent(this.stack.size());
                    this.output.accept(BMPString.of("{ "));
                } else {
                    this.output.accept(BMPString.of("{"));
                }
                this.atStart = true;
                this.keyChecker.push(new HashSet());
                break;
            }
            case "null": {
                this.output.accept(BMPString.of("null"));
                this.atStart = false;
                break;
            }
            case "string": {
                if (escapedAtt != null) {
                    try {
                        this.escaped = StringConverter.StringToBoolean.INSTANCE.convertString(StringView.tidy(escapedAtt)).asAtomic().effectiveBooleanValue();
                    }
                    catch (XPathException e) {
                        throw new XPathException("xml-to-json: value of escaped attribute (" + this.escaped + ") is not a valid xs:boolean", ERR_INPUT);
                    }
                }
                this.atStart = false;
                break;
            }
            case "boolean": 
            case "number": {
                this.atStart = false;
                break;
            }
            default: {
                throw new XPathException("xml-to-json: unknown element <" + local + ">", ERR_INPUT);
            }
        }
        this.textBuffer.setLength(0);
    }

    private void checkParent(String child, String parent) throws XPathException {
        if ("null".equals(parent) || "string".equals(parent) || "number".equals(parent) || "boolean".equals(parent)) {
            throw new XPathException("xml-to-json: " + Err.indefiniteArticleFor(child, true) + " " + Err.wrap(child, 1) + " element cannot appear as a child of " + Err.wrap(parent, 1), ERR_INPUT);
        }
    }

    @Override
    public void endElement() throws XPathException {
        NodeName name = this.stack.pop();
        String local = name.getLocalPart();
        String content = this.textBuffer.toString();
        UnicodeString uContent = StringView.tidy(content);
        if (local.equals("boolean")) {
            try {
                boolean b = StringConverter.StringToBoolean.INSTANCE.convertString(uContent).asAtomic().effectiveBooleanValue();
                String base = b ? "true" : "false";
                this.output.accept(BMPString.of(base));
            }
            catch (XPathException e) {
                throw new XPathException("xml-to-json: Value of <boolean> element is not a valid xs:boolean", ERR_INPUT);
            }
        } else if (local.equals("number")) {
            if (this.numberFormatter == null) {
                try {
                    double d = StringToDouble11.getInstance().stringToNumber(uContent);
                    if (Double.isNaN(d) || Double.isInfinite(d)) {
                        throw new XPathException("xml-to-json: Infinity and NaN are not allowed", ERR_INPUT);
                    }
                    this.output.accept(new DoubleValue(d).getUnicodeStringValue());
                }
                catch (NumberFormatException e) {
                    throw new XPathException("xml-to-json: Invalid number: " + this.textBuffer, ERR_INPUT);
                }
            } else {
                Sequence result = SystemFunction.dynamicCall(this.numberFormatter, this.context, new StringValue(uContent));
                this.output.accept(((StringValue)result).getUnicodeStringValue());
            }
        } else if (local.equals("string")) {
            this.output.accept(BMPString.of("\""));
            if (this.escaped) {
                this.output.accept(StringView.of(JsonReceiver.handleEscapedString(content)));
            } else {
                this.output.accept(StringView.of(JsonReceiver.escape(content, false, this.isControlChar)));
            }
            this.output.accept(BMPString.of("\""));
        } else if (!Whitespace.isAllWhite(uContent)) {
            throw new XPathException("xml-to-json: Element " + name.getDisplayName() + " must have no text content", ERR_INPUT);
        }
        this.textBuffer.setLength(0);
        this.escaped = false;
        if (local.equals("array")) {
            String base = this.indenting ? " ]" : "]";
            this.output.accept(BMPString.of(base));
        } else if (local.equals("map")) {
            this.keyChecker.pop();
            String base = this.indenting ? " }" : "}";
            this.output.accept(BMPString.of(base));
        }
        this.atStart = false;
    }

    private static String handleEscapedString(String str) throws XPathException {
        JsonReceiver.unescape(str);
        StringBuilder out = new StringBuilder(str.length() * 2);
        boolean afterEscapeChar = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"' && !afterEscapeChar) {
                out.append("\\\"");
            } else if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
                if (c == '\b') {
                    out.append("\\b");
                } else if (c == '\f') {
                    out.append("\\f");
                } else if (c == '\n') {
                    out.append("\\n");
                } else if (c == '\r') {
                    out.append("\\r");
                } else if (c == '\t') {
                    out.append("\\t");
                } else {
                    out.append("\\u");
                    out.append((CharSequence)JsonReceiver.hex4(c));
                }
            } else if (c == '/' && !afterEscapeChar) {
                out.append("\\/");
            } else {
                out.appendCodePoint(c);
            }
            afterEscapeChar = c == '\\' && !afterEscapeChar;
        }
        return out.toString();
    }

    public static String escape(String in, boolean forXml, IntPredicate hexEscapes) throws XPathException {
        StringBuilder out = new StringBuilder(in.length());
        block10: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '\"': {
                    out.append(forXml ? "\"" : "\\\"");
                    continue block10;
                }
                case '\b': {
                    out.append("\\b");
                    continue block10;
                }
                case '\f': {
                    out.append("\\f");
                    continue block10;
                }
                case '\n': {
                    out.append("\\n");
                    continue block10;
                }
                case '\r': {
                    out.append("\\r");
                    continue block10;
                }
                case '\t': {
                    out.append("\\t");
                    continue block10;
                }
                case '/': {
                    out.append(forXml ? "/" : "\\/");
                    continue block10;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block10;
                }
                default: {
                    if (hexEscapes.test(c)) {
                        out.append("\\u");
                        out.append((CharSequence)JsonReceiver.hex4(c));
                        continue block10;
                    }
                    out.appendCodePoint(c);
                }
            }
        }
        return out.toString();
    }

    private static StringBuilder hex4(int c) {
        StringBuilder hex = new StringBuilder(Integer.toHexString(c).toUpperCase());
        while (hex.length() < 4) {
            hex.insert(0, "0");
        }
        return hex;
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        NodeName element;
        String local;
        if (!this.stack.empty() && !Whitespace.isAllWhite(chars) && ((local = (element = this.stack.peek()).getLocalPart()).equals("map") || local.equals("array"))) {
            throw new XPathException("xml-to-json: Element " + local + " must have no text content", ERR_INPUT);
        }
        this.textBuffer.append(chars);
    }

    @Override
    public void processingInstruction(String name, UnicodeString data, Location locationId, int properties) throws XPathException {
    }

    @Override
    public void comment(UnicodeString content, Location locationId, int properties) throws XPathException {
    }

    @Override
    public void close() throws XPathException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    private void indent(int depth) throws XPathException {
        this.output.accept(BMPString.of("\n"));
        for (int i = 0; i < depth; ++i) {
            this.output.accept(StringConstants.SINGLE_SPACE);
        }
    }

    private static String unescape(String literal) throws XPathException {
        if (literal.indexOf(92) < 0) {
            return literal;
        }
        StringBuilder buffer = new StringBuilder(literal.length());
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (c == '\\') {
                if (i++ == literal.length() - 1) {
                    throw new XPathException("String '" + Err.wrap(literal) + "' ends in backslash ", "FOJS0007");
                }
                switch (literal.charAt(i)) {
                    case '\"': {
                        buffer.append('\"');
                        break;
                    }
                    case '\\': {
                        buffer.append('\\');
                        break;
                    }
                    case '/': {
                        buffer.append('/');
                        break;
                    }
                    case 'b': {
                        buffer.append('\b');
                        break;
                    }
                    case 'f': {
                        buffer.append('\f');
                        break;
                    }
                    case 'n': {
                        buffer.append('\n');
                        break;
                    }
                    case 'r': {
                        buffer.append('\r');
                        break;
                    }
                    case 't': {
                        buffer.append('\t');
                        break;
                    }
                    case 'u': {
                        try {
                            String hex = literal.substring(i + 1, i + 5);
                            int code = Integer.parseInt(hex, 16);
                            buffer.append((char)code);
                            i += 4;
                            break;
                        }
                        catch (Exception e) {
                            throw new XPathException("Invalid hex escape sequence in string '" + Err.wrap(literal) + "'", "FOJS0007");
                        }
                    }
                    default: {
                        char next = literal.charAt(i);
                        String xx = next < '\u0100' ? "" + next : "x" + Integer.toHexString(next);
                        throw new XPathException("Unknown escape sequence \\" + xx, "FOJS0007");
                    }
                }
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

