/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.function.Predicate;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.Version;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.IDFilter;
import net.sf.saxon.functions.EncodeForUri;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.DirectResourceResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.resource.BinaryResource;
import net.sf.saxon.resource.DataURIScheme;
import net.sf.saxon.resource.ResourceLoader;
import net.sf.saxon.resource.UnparsedTextResource;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Maker;
import net.sf.saxon.trans.NonDelegatingURIResolver;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class StandardURIResolver
implements NonDelegatingURIResolver {
    private Configuration config = null;
    private boolean recognizeQueryParameters = false;
    private Predicate<URI> allowedUriTest = null;

    public StandardURIResolver() {
        this(null);
    }

    public StandardURIResolver(Configuration config) {
        this.config = config;
    }

    public void setRecognizeQueryParameters(boolean recognize) {
        this.recognizeQueryParameters = recognize;
    }

    public boolean queryParametersAreRecognized() {
        return this.recognizeQueryParameters;
    }

    public void setAllowedUriTest(Predicate<URI> test) {
        this.allowedUriTest = test;
    }

    protected Platform getPlatform() {
        return Version.platform;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public Source resolve(String href, String base) throws XPathException {
        Optional<Boolean> xinclude;
        Optional<Integer> validation;
        Optional<Maker<XMLReader>> parser;
        URI uri;
        URI relative;
        if (this.config != null && this.config.isTiming()) {
            assert (this.config != null);
            this.config.getLogger().info("URIResolver.resolve href=\"" + href + "\" base=\"" + base + "\"");
        }
        String relativeURI = href;
        String id = null;
        int hash = href.indexOf(35);
        if (hash >= 0) {
            relativeURI = href.substring(0, hash);
            id = href.substring(hash + 1);
        }
        URIQueryParameters params = null;
        try {
            relativeURI = ResolveURI.escapeSpaces(relativeURI);
            relative = new URI(relativeURI);
        }
        catch (URISyntaxException err) {
            throw new XPathException("Invalid relative URI " + Err.wrap(relativeURI), err);
        }
        String query = relative.getQuery();
        if (query != null && this.recognizeQueryParameters) {
            params = new URIQueryParameters(query, this.config);
            int q = relativeURI.indexOf(63);
            relativeURI = relativeURI.substring(0, q);
        }
        Source source = null;
        if (this.recognizeQueryParameters && relativeURI.endsWith(".ptree")) {
            throw new UnsupportedOperationException("PTree files are no longer supported (from Saxon 10.0)");
        }
        try {
            uri = ResolveURI.makeAbsolute(relativeURI, base);
        }
        catch (URISyntaxException err) {
            String expandedBase = ResolveURI.tryToExpand(base);
            if (!expandedBase.equals(base)) {
                return this.resolve(href, expandedBase);
            }
            throw new XPathException("Invalid URI " + Err.wrap(relativeURI) + " - base " + Err.wrap(base), err);
        }
        String uriString = uri.toString();
        EncodeForUri.checkPercentEncoding(uriString);
        if ("data".equals(uri.getScheme())) {
            Resource resource;
            try {
                resource = DataURIScheme.decode(uri);
            }
            catch (IllegalArgumentException e) {
                throw new XPathException("Invalid URI using 'data' scheme: " + e.getMessage());
            }
            if (resource instanceof BinaryResource) {
                byte[] contents = ((BinaryResource)resource).getData();
                InputSource is = new InputSource(new ByteArrayInputStream(contents));
                source = new SAXSource(is);
                source.setSystemId(uriString);
            } else {
                assert (resource instanceof UnparsedTextResource);
                StringReader reader = new StringReader(((UnparsedTextResource)resource).getContent());
                source = new SAXSource(new InputSource(reader));
                source.setSystemId(uriString);
            }
        } else {
            if (this.config != null) {
                ResourceRequest rr = new ResourceRequest();
                rr.uri = uriString;
                rr.relativeUri = relativeURI;
                rr.baseUri = base;
                rr.nature = "https://www.iana.org/assignments/media-types/application/xml";
                return rr.resolve(new DirectResourceResolver(this.config));
            }
            if (source == null) {
                source = new SAXSource();
                this.setSAXInputSource((SAXSource)source, uriString);
            }
        }
        if (params != null && (parser = params.getXMLReaderMaker()).isPresent()) {
            source.setXMLReader(parser.get().make());
        }
        if (source.getXMLReader() == null && this.config == null) {
            try {
                source.setXMLReader(Version.platform.loadParser());
            }
            catch (Exception err) {
                throw new XPathException(err);
            }
        }
        if (params != null) {
            Optional<SpaceStrippingRule> stripSpace = params.getSpaceStrippingRule();
            source = AugmentedSource.makeAugmentedSource(source);
            if (stripSpace.isPresent()) {
                ParseOptions options = ((AugmentedSource)source).getParseOptions().withSpaceStrippingRule(stripSpace.get());
                ((AugmentedSource)source).setParseOptions(options);
            }
        }
        if (id != null) {
            String idFinal = id;
            FilterFactory factory = next -> new IDFilter(next, idFinal);
            source = AugmentedSource.makeAugmentedSource(source);
            ((AugmentedSource)source).addFilter(factory);
        }
        if (params != null && (validation = params.getValidationMode()).isPresent()) {
            source = AugmentedSource.makeAugmentedSource(source);
            ((AugmentedSource)source).setSchemaValidationMode(validation.get());
        }
        if (params != null && (xinclude = params.getXInclude()).isPresent()) {
            source = AugmentedSource.makeAugmentedSource(source);
            ((AugmentedSource)source).setXIncludeAware(xinclude.get());
        }
        return source;
    }

    protected void setSAXInputSource(SAXSource source, String uriString) {
        InputStream is;
        if (uriString.startsWith("classpath:") && uriString.length() > 10 && (is = this.getConfiguration().getDynamicLoader().getResourceAsStream(uriString.substring(10))) != null) {
            source.setInputSource(new InputSource(is));
            source.setSystemId(uriString);
            return;
        }
        try {
            is = ResourceLoader.urlStream(new URL(uriString));
            source.setInputSource(new InputSource(is));
            source.setSystemId(uriString);
        }
        catch (IOException e) {
            source.setInputSource(new InputSource(uriString));
            source.setSystemId(uriString);
        }
    }
}

