/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.registry;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.OptionsParameter;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.FunctionDefinition;
import net.sf.saxon.functions.registry.ParamKeywords;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntHashMap;

public abstract class BuiltInFunctionSet
implements FunctionLibrary {
    public static Sequence EMPTY = EmptySequence.getInstance();
    public static final int ONE = 16384;
    public static final int OPT = 24576;
    public static final int STAR = 57344;
    public static final int PLUS = 49152;
    public static final int AS_ARG0 = 1;
    public static final int AS_PRIM_ARG0 = 2;
    public static final int CITEM = 4;
    public static final int BASE = 8;
    public static final int NS = 16;
    public static final int DCOLL = 32;
    public static final int DLANG = 64;
    public static final int FILTER = 256;
    public static final int LATE = 512;
    public static final int UO = 1024;
    public static final int POSN = 2048;
    public static final int LAST = 4096;
    public static final int SIDE = 8192;
    public static final int CDOC = 16384;
    public static final int CARD0 = 32768;
    public static final int NEW = 65536;
    public static final int CTRL = 131072;
    public static final int SEQV = 262144;
    public static final int DEPENDS_ON_STATIC_CONTEXT = 56;
    public static final int FOCUS = 22532;
    protected static final int INS = 0x1000000;
    protected static final int ABS = 0x2000000;
    protected static final int TRA = 0x4000000;
    protected static final int NAV = 0x8000000;
    private final HashMap<String, Entry> functionTable = new HashMap(200);
    private final HashMap<String, Integer> sequenceVariadicFunctions = new HashMap(10);

    public final void importFunctionSet(BuiltInFunctionSet importee) {
        if (!importee.getNamespace().equals(this.getNamespace())) {
            throw new IllegalArgumentException(importee.getNamespace().toString());
        }
        this.functionTable.putAll(importee.functionTable);
        this.sequenceVariadicFunctions.putAll(importee.sequenceVariadicFunctions);
    }

    public Entry getFunctionDetails(String name, int arity) {
        if (arity == -1) {
            for (int i = 0; i < 20; ++i) {
                Entry found = this.getFunctionDetails(name, i);
                if (found == null) continue;
                return found;
            }
            return null;
        }
        String key = name + "#" + arity;
        Entry entry = this.functionTable.get(key);
        if (entry != null) {
            return entry;
        }
        int minArity = this.sequenceVariadicFunctions.getOrDefault(name, -1);
        if (minArity != -1 && arity >= minArity) {
            key = name + "#" + (minArity + 1);
            return this.functionTable.get(key);
        }
        return null;
    }

    @Override
    public Expression bind(SymbolicName.F symbolicName, Expression[] staticArgs, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) throws XPathException {
        StructuredQName functionName = symbolicName.getComponentName();
        int arity = symbolicName.getArity();
        String localName = functionName.getLocalPart();
        Entry entry = this.getFunctionDetails(localName, arity);
        if (functionName.hasURI(this.getNamespace()) && entry != null) {
            entry.ensurePopulated();
            if ((entry.properties & 0x40000) != 0) {
                if (env.getXPathVersion() < 40 && localName.equals("concat")) {
                    if (staticArgs.length < 2) {
                        reasons.add("concat() prior to XPath 4.0 requires at least two arguments");
                        return null;
                    }
                    Expression[] a2 = new Expression[staticArgs.length];
                    for (int i = 0; i < staticArgs.length; ++i) {
                        if (staticArgs[i] instanceof StringLiteral) {
                            a2[i] = staticArgs[i];
                            continue;
                        }
                        int pos = i;
                        Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(0, "concat", pos);
                        a2[i] = CardinalityChecker.makeCardinalityChecker(staticArgs[i], 24576, role);
                        a2[i].setRetainedStaticContext(env.makeRetainedStaticContext());
                    }
                    staticArgs = a2;
                }
                int declaredArity = entry.maxArity;
                Expression[] newArgs = Arrays.copyOf(staticArgs, declaredArity);
                if (declaredArity > staticArgs.length) {
                    newArgs[declaredArity - 1] = Literal.makeEmptySequence();
                } else if (declaredArity < staticArgs.length) {
                    Block block = new Block(Arrays.copyOfRange(staticArgs, declaredArity - 1, staticArgs.length));
                    ExpressionTool.copyLocationInfo(staticArgs[0], block);
                    newArgs[declaredArity - 1] = block;
                }
                staticArgs = newArgs;
            } else if (keywords != null && !keywords.isEmpty() || staticArgs.length < entry.maxArity) {
                staticArgs = UserFunction.makeExpandedArgumentArray(staticArgs, keywords, entry);
            }
            RetainedStaticContext rsc = new RetainedStaticContext(env);
            try {
                SystemFunction fn = this.makeFunction(localName, staticArgs.length);
                fn.setRetainedStaticContext(rsc);
                Expression f = fn.makeFunctionCall(staticArgs);
                f.setRetainedStaticContext(rsc);
                return f;
            }
            catch (XPathException e) {
                reasons.add(e.getMessage());
                return null;
            }
        }
        return null;
    }

    public SystemFunction makeFunction(String name, int arity) throws XPathException {
        Entry entry = this.getFunctionDetails(name, arity);
        if (entry == null) {
            String diagName;
            String string = diagName = this.getNamespace().equals(NamespaceUri.FN) ? "System function " + name : "Function Q{" + this.getNamespace() + "}" + name;
            if (this.getFunctionDetails(name, -1) == null) {
                XPathException err = new XPathException(diagName + "() does not exist or is not available in this environment");
                err.setErrorCode("XPST0017");
                err.setIsStaticError(true);
                throw err;
            }
            XPathException err = new XPathException(diagName + "() cannot be called with " + BuiltInFunctionSet.pluralArguments(arity));
            err.setErrorCode("XPST0017");
            err.setIsStaticError(true);
            throw err;
        }
        entry.ensurePopulated();
        SystemFunction f = entry.implementationFactory.get();
        f.setDetails(entry);
        f.setArity(arity);
        return f;
    }

    private static String pluralArguments(int num) {
        if (num == 0) {
            return "zero arguments";
        }
        if (num == 1) {
            return "one argument";
        }
        return num + " arguments";
    }

    @Override
    public boolean isAvailable(SymbolicName.F symbolicName, int languageLevel) {
        StructuredQName qn = symbolicName.getComponentName();
        if (!qn.hasURI(this.getNamespace())) {
            return false;
        }
        Entry entry = this.getFunctionDetails(qn.getLocalPart(), symbolicName.getArity());
        if (entry == null) {
            return false;
        }
        return languageLevel >= 40 || !symbolicName.getComponentName().getLocalPart().equals("concat") || symbolicName.getArity() >= 2;
    }

    @Override
    public FunctionLibrary copy() {
        return this;
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F symbolicName, StaticContext staticContext) throws XPathException {
        StructuredQName functionName = symbolicName.getComponentName();
        int arity = symbolicName.getArity();
        if (functionName.hasURI(this.getNamespace()) && this.getFunctionDetails(functionName.getLocalPart(), arity) != null) {
            RetainedStaticContext rsc = staticContext.makeRetainedStaticContext();
            SystemFunction fn = this.makeFunction(functionName.getLocalPart(), arity);
            if (staticContext.getXPathVersion() < 40 && fn instanceof Concat && arity < 2) {
                return null;
            }
            fn.setRetainedStaticContext(rsc);
            return fn;
        }
        return null;
    }

    protected Entry register(String name, int arity, Function<Entry, Entry> populator) {
        Entry e = new Entry();
        e.name = new StructuredQName(this.getConventionalPrefix(), this.getNamespace(), name);
        e.minArity = arity;
        e.maxArity = arity;
        e.populator = populator;
        e.functionSet = this;
        this.functionTable.put(name + "#" + arity, e);
        return e;
    }

    protected Entry register(String name, int minArity, int maxArity, Function<Entry, Entry> populator) {
        Entry e = new Entry();
        e.name = new StructuredQName(this.getConventionalPrefix(), this.getNamespace(), name);
        e.minArity = minArity;
        e.maxArity = maxArity;
        e.populator = populator;
        e.functionSet = this;
        for (int a = minArity; a <= maxArity; ++a) {
            this.functionTable.put(name + "#" + a, e);
        }
        return e;
    }

    protected Entry registerVariadic(String name, int arity, Function<Entry, Entry> populator) {
        Entry e = this.register(name, arity, populator);
        this.sequenceVariadicFunctions.put(name, arity - 1);
        return e;
    }

    public NamespaceUri getNamespace() {
        return NamespaceUri.FN;
    }

    public String getConventionalPrefix() {
        return "fn";
    }

    public static class Entry
    implements FunctionDefinition {
        public StructuredQName name;
        public Supplier<SystemFunction> implementationFactory;
        public Function<Entry, Entry> populator;
        public BuiltInFunctionSet functionSet;
        public int maxArity;
        public int minArity;
        public ItemType itemType;
        public int cardinality;
        public OperandUsage[] usage;
        public String[] paramNames;
        public SequenceType[] paramTypes;
        public Sequence[] resultIfEmpty;
        public IntHashMap<Expression> defaultValueExpressions;
        public int properties;
        public OptionsParameter optionDetails;

        public synchronized void ensurePopulated() {
            if (this.implementationFactory == null) {
                this.populator.apply(this);
            }
        }

        public Entry populate(Supplier<SystemFunction> functionFactory, ItemType itemType, int cardinality, int properties) {
            NamespaceUri ns;
            Map<String, String> paramNameMap;
            String keywords;
            this.implementationFactory = functionFactory;
            this.itemType = itemType;
            this.cardinality = cardinality;
            this.properties = properties;
            if (this.maxArity == -1) {
                this.paramTypes = new SequenceType[1];
                this.resultIfEmpty = new AtomicValue[1];
                this.usage = new OperandUsage[1];
            } else {
                this.paramTypes = new SequenceType[this.maxArity];
                this.resultIfEmpty = new Sequence[this.maxArity];
                this.usage = new OperandUsage[this.maxArity];
            }
            if ((properties & 0x40000) != 0) {
                this.functionSet.sequenceVariadicFunctions.put(this.name.getLocalPart(), this.maxArity - 1);
            }
            if ((keywords = (paramNameMap = (ns = this.name.getNamespaceUri()) == NamespaceUri.FN ? ParamKeywords.fnParamNames : (ns == NamespaceUri.MAP_FUNCTIONS ? ParamKeywords.mapParamNames : (ns == NamespaceUri.ARRAY_FUNCTIONS ? ParamKeywords.arrayParamNames : (ns == NamespaceUri.MATH ? ParamKeywords.mathParamNames : Collections.emptyMap())))).get(this.name.getLocalPart())) == null) {
                keywords = paramNameMap.get(this.name.getLocalPart() + "#" + this.maxArity);
            }
            if (keywords == null) {
                keywords = "a|b|c|d|e|f";
            }
            this.paramNames = keywords.split("\\|");
            return this;
        }

        public Entry arg(int a, ItemType type, int options, Sequence resultIfEmpty) {
            return this.arg(a, type, options, resultIfEmpty, null);
        }

        public Entry arg(int a, ItemType type, int options, Sequence resultIfEmpty, Expression defaultValue) {
            int cardinality = options & 0xE000;
            OperandUsage usage = OperandUsage.NAVIGATION;
            if ((options & 0x2000000) != 0) {
                usage = OperandUsage.ABSORPTION;
            } else if ((options & 0x4000000) != 0) {
                usage = OperandUsage.TRANSMISSION;
            } else if ((options & 0x1000000) != 0) {
                usage = OperandUsage.INSPECTION;
            } else if (type instanceof PlainType) {
                usage = OperandUsage.ABSORPTION;
            }
            try {
                this.paramTypes[a] = SequenceType.makeSequenceType(type, cardinality);
                this.resultIfEmpty[a] = resultIfEmpty;
                this.usage[a] = usage;
                if (defaultValue != null) {
                    this.withDefault(a, defaultValue);
                }
            }
            catch (ArrayIndexOutOfBoundsException err) {
                System.err.println("Internal Saxon error: Can't set argument " + a + " of " + this.name);
            }
            return this;
        }

        public Entry withDefault(int arg, Expression defaultValue) {
            if (this.defaultValueExpressions == null) {
                this.defaultValueExpressions = new IntHashMap(this.getNumberOfParameters());
            }
            this.defaultValueExpressions.put(arg, defaultValue);
            return this;
        }

        public Entry setOptionDetails(OptionsParameter details) {
            this.optionDetails = details;
            return this;
        }

        @Override
        public StructuredQName getFunctionName() {
            return this.name;
        }

        @Override
        public int getNumberOfParameters() {
            return this.maxArity;
        }

        @Override
        public int getMinimumArity() {
            return this.minArity;
        }

        @Override
        public StructuredQName getParameterName(int i) {
            return new StructuredQName("", "", this.paramNames[i]);
        }

        @Override
        public Expression getDefaultValueExpression(int i) {
            if (this.defaultValueExpressions != null) {
                return this.defaultValueExpressions.get(i);
            }
            return null;
        }

        @Override
        public int getPositionOfParameter(StructuredQName name) {
            for (int i = 0; i < this.maxArity; ++i) {
                if (!this.paramNames[i].equals(name.getLocalPart())) continue;
                return i;
            }
            return -1;
        }
    }
}

