/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.StringElaborator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SubstringAfter
extends CollatingFunctionFixed {
    @Override
    public boolean isSubstringMatchingFunction() {
        return true;
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        UnicodeString s0 = this.getUniStringArg(arguments[0]);
        UnicodeString s1 = this.getUniStringArg(arguments[1]);
        return new StringValue(SubstringAfter.substringAfter(s0, s1, (SubstringMatcher)this.getStringCollator()));
    }

    private static UnicodeString substringAfter(UnicodeString arg1, UnicodeString arg2, SubstringMatcher collator) {
        if (arg1 == null) {
            arg1 = EmptyUnicodeString.getInstance();
        }
        if (arg2 == null) {
            arg2 = EmptyUnicodeString.getInstance();
        }
        if (arg2.isEmpty()) {
            return arg1;
        }
        if (arg1.isEmpty()) {
            return EmptyUnicodeString.getInstance();
        }
        return collator.substringAfter(arg1, arg2);
    }

    @Override
    public String getCompilerName() {
        return "SubstringAfterCompiler";
    }

    @Override
    public Elaborator getElaborator() {
        return new SubstringAfterFnElaborator();
    }

    public static class SubstringAfterFnElaborator
    extends StringElaborator {
        @Override
        public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthWhenAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            SubstringAfter fn = (SubstringAfter)fnc.getTargetFunction();
            SubstringMatcher stringCollator = (SubstringMatcher)fn.getStringCollator();
            assert (stringCollator != null);
            UnicodeStringEvaluator arg0Eval = fnc.getArg(0).makeElaborator().elaborateForUnicodeString(true);
            UnicodeStringEvaluator arg1Eval = fnc.getArg(1).makeElaborator().elaborateForUnicodeString(true);
            if (stringCollator instanceof CodepointCollator) {
                return context -> {
                    UnicodeString s0 = arg0Eval.eval(context);
                    UnicodeString s1 = arg1Eval.eval(context);
                    if (s1.isEmpty()) {
                        return s0;
                    }
                    if (s0.isEmpty()) {
                        return EmptyUnicodeString.getInstance();
                    }
                    long i = s0.indexOf(s1, 0L);
                    if (i < 0L) {
                        return EmptyUnicodeString.getInstance();
                    }
                    return s0.substring(i + s1.length());
                };
            }
            return context -> {
                UnicodeString s0 = arg0Eval.eval(context);
                UnicodeString s1 = arg1Eval.eval(context);
                if (s1.isEmpty()) {
                    return s0;
                }
                if (s0.isEmpty()) {
                    return EmptyUnicodeString.getInstance();
                }
                return stringCollator.substringAfter(s0, s1);
            };
        }

        @Override
        public StringEvaluator elaborateForString(boolean zeroLengthWhenAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            SubstringAfter fn = (SubstringAfter)fnc.getTargetFunction();
            SubstringMatcher stringCollator = (SubstringMatcher)fn.getStringCollator();
            assert (stringCollator != null);
            if (stringCollator instanceof CodepointCollator) {
                StringEvaluator arg0Eval = fnc.getArg(0).makeElaborator().elaborateForString(true);
                StringEvaluator arg1Eval = fnc.getArg(1).makeElaborator().elaborateForString(true);
                return context -> {
                    String s0 = arg0Eval.eval(context);
                    String s1 = arg1Eval.eval(context);
                    if (s1.isEmpty()) {
                        return s0;
                    }
                    if (s0.isEmpty()) {
                        return "";
                    }
                    int i = s0.indexOf(s1, 0);
                    if (i < 0) {
                        return "";
                    }
                    return s0.substring(i + s1.length());
                };
            }
            return super.elaborateForString(zeroLengthWhenAbsent);
        }
    }
}

