/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.StringElaborator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class String_1
extends ScalarSystemFunction {
    @Override
    public AtomicValue evaluate(Item arg, XPathContext context) throws XPathException {
        try {
            return new StringValue(arg.getUnicodeStringValue());
        }
        catch (UncheckedXPathException err) {
            throw err.getXPathException();
        }
    }

    @Override
    public Sequence resultWhenEmpty() {
        return StringValue.EMPTY_STRING;
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        Expression arg;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (th.isSubType((arg = arguments[0]).getItemType(), BuiltInAtomicType.STRING) && arg.getCardinality() == 16384) {
            return arg;
        }
        if (arg instanceof SimpleNodeConstructor && arg.getCardinality() == 16384) {
            return ((SimpleNodeConstructor)arg).getSelect();
        }
        return null;
    }

    @Override
    public String getCompilerName() {
        return "StringFnCompiler";
    }

    @Override
    public String getStreamerName() {
        return "StringFn";
    }

    @Override
    public Elaborator getElaborator() {
        return new StringFnElaborator();
    }

    public static class StringFnElaborator
    extends StringElaborator {
        @Override
        public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthWhenAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            UnicodeStringEvaluator argEval = arg.makeElaborator().elaborateForUnicodeString(true);
            return context -> {
                try {
                    return argEval.eval(context);
                }
                catch (UncheckedXPathException err) {
                    throw err.getXPathException();
                }
            };
        }

        @Override
        public StringEvaluator elaborateForString(boolean zeroLengthWhenAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            StringEvaluator argEval = arg.makeElaborator().elaborateForString(true);
            return context -> {
                try {
                    return argEval.eval(context);
                }
                catch (UncheckedXPathException err) {
                    throw err.getXPathException();
                }
            };
        }
    }
}

