/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.StringElaborator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class LocalName_1
extends ScalarSystemFunction {
    @Override
    public AtomicValue evaluate(Item item, XPathContext context) throws XPathException {
        return StringValue.makeStringValue(((NodeInfo)item).getLocalPart());
    }

    @Override
    public Sequence resultWhenEmpty() {
        return StringValue.EMPTY_STRING;
    }

    @Override
    public String getCompilerName() {
        return "LocalNameCompiler";
    }

    @Override
    public Elaborator getElaborator() {
        return new LocalNameElaborator();
    }

    public static class LocalNameElaborator
    extends StringElaborator {
        @Override
        public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthIfAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            boolean nullable = Cardinality.allowsZero(arg.getCardinality());
            ItemEvaluator argEval = arg.makeElaborator().elaborateForItem();
            return context -> {
                NodeInfo node = (NodeInfo)argEval.eval(context);
                if (nullable && node == null) {
                    return EmptyUnicodeString.getInstance();
                }
                return StringView.of(node.getLocalPart());
            };
        }

        @Override
        public StringEvaluator elaborateForString(boolean zeroLengthIfAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            boolean nullable = Cardinality.allowsZero(arg.getCardinality());
            ItemEvaluator argEval = arg.makeElaborator().elaborateForItem();
            return context -> {
                NodeInfo node = (NodeInfo)argEval.eval(context);
                if (nullable && node == null) {
                    return "";
                }
                return node.getLocalPart();
            };
        }
    }
}

