/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.HashSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.SameNameTest;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ComplexVariety;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class DeepEqual
extends CollatingFunctionFixed {
    public static final int INCLUDE_NAMESPACES = 1;
    public static final int INCLUDE_PREFIXES = 2;
    public static final int INCLUDE_COMMENTS = 4;
    public static final int INCLUDE_PROCESSING_INSTRUCTIONS = 8;
    public static final int EXCLUDE_WHITESPACE_TEXT_NODES = 16;
    public static final int COMPARE_STRING_VALUES = 32;
    public static final int COMPARE_ANNOTATIONS = 64;
    public static final int WARNING_IF_FALSE = 128;
    public static final int JOIN_ADJACENT_TEXT_NODES = 256;
    public static final int COMPARE_ID_FLAGS = 512;
    public static final int EXCLUDE_VARIETY = 1024;

    public static boolean deepEqual(SequenceIterator op1, SequenceIterator op2, AtomicComparer comparer, XPathContext context, int flags) throws XPathException {
        ErrorReporter reporter;
        Object reason;
        boolean result;
        block15: {
            result = true;
            reason = null;
            reporter = context.getErrorReporter();
            try {
                if ((flags & 0x100) != 0) {
                    op1 = DeepEqual.mergeAdjacentTextNodes(op1);
                    op2 = DeepEqual.mergeAdjacentTextNodes(op2);
                }
                int pos1 = 0;
                int pos2 = 0;
                while (true) {
                    Item item1 = op1.next();
                    Item item2 = op2.next();
                    if (item1 == null && item2 == null) break block15;
                    ++pos1;
                    ++pos2;
                    if (item1 == null || item2 == null) {
                        result = false;
                        reason = item1 == null ? "Second sequence is longer (first sequence length = " + pos2 + ")" : "First sequence is longer (second sequence length = " + pos1 + ")";
                        if (item1 instanceof WhitespaceTextImpl || item2 instanceof WhitespaceTextImpl) {
                            reason = (String)reason + " (the first extra node is whitespace text)";
                        }
                        break block15;
                    }
                    if (item1 instanceof FunctionItem || item2 instanceof FunctionItem) {
                        if (!(item1 instanceof FunctionItem) || !(item2 instanceof FunctionItem)) {
                            reason = "if one item is a function then both must be functions (position " + pos1 + ")";
                            return false;
                        }
                        boolean fe = ((FunctionItem)item1).deepEquals((FunctionItem)item2, context, comparer, flags);
                        if (fe) continue;
                        result = false;
                        reason = "functions at position " + pos1 + " differ";
                        break block15;
                    }
                    if (item1 instanceof ObjectValue || item2 instanceof ObjectValue) {
                        if (item1.equals(item2)) continue;
                        return false;
                    }
                    if (item1 instanceof NodeInfo) {
                        if (item2 instanceof NodeInfo) {
                            String message = DeepEqual.deepEquals((NodeInfo)item1, (NodeInfo)item2, comparer, context, flags);
                            if (message == null) continue;
                            result = false;
                            reason = "nodes at position " + pos1 + " differ: " + message;
                        } else {
                            result = false;
                            reason = "comparing a node to an atomic value at position " + pos1;
                        }
                        break block15;
                    }
                    if (item2 instanceof NodeInfo) {
                        result = false;
                        reason = "comparing an atomic value to a node at position " + pos1;
                        break block15;
                    }
                    AtomicValue av1 = (AtomicValue)item1;
                    AtomicValue av2 = (AtomicValue)item2;
                    if (!(av1.isNaN() && av2.isNaN() || comparer.comparesEqual(av1, av2))) break;
                }
                result = false;
                reason = "atomic values at position " + pos1 + " differ";
            }
            catch (UncheckedXPathException uxe) {
                throw uxe.getXPathException();
            }
            catch (ClassCastException err) {
                result = false;
                reason = "sequences contain non-comparable values";
            }
        }
        if (!result) {
            DeepEqual.explain(reporter, (String)reason, flags, null, null);
        }
        return result;
    }

    public static String deepEquals(NodeInfo n1, NodeInfo n2, AtomicComparer comparer, XPathContext context, int flags) throws XPathException {
        if (n1.equals(n2)) {
            return null;
        }
        ErrorReporter reporter = context.getErrorReporter();
        if (n1.getNodeKind() != n2.getNodeKind()) {
            String reason = "node kinds differ: comparing " + DeepEqual.showKind(n1) + " to " + DeepEqual.showKind(n2);
            DeepEqual.explain(reporter, reason, flags, n1, n2);
            return reason;
        }
        switch (n1.getNodeKind()) {
            case 1: {
                String reason;
                NamespaceMap nm2;
                NamespaceMap nm1;
                Object reason2;
                NodeInfo att1;
                AxisIterator a2;
                if (!Navigator.haveSameName(n1, n2)) {
                    String reason3 = "element names differ: " + NameOfNode.makeName(n1).getStructuredQName().getEQName() + " != " + NameOfNode.makeName(n2).getStructuredQName().getEQName();
                    DeepEqual.explain(reporter, reason3, flags, n1, n2);
                    return reason3;
                }
                if ((flags & 2) != 0 && !n1.getPrefix().equals(n2.getPrefix())) {
                    String reason4 = "element prefixes differ: " + n1.getPrefix() + " != " + n2.getPrefix();
                    DeepEqual.explain(reporter, reason4, flags, n1, n2);
                    return reason4;
                }
                AxisIterator a1 = n1.iterateAxis(2);
                if (!SequenceTool.sameLength(a1, a2 = n2.iterateAxis(2))) {
                    String reason5 = "elements have different number of attributes";
                    DeepEqual.explain(reporter, "elements have different number of attributes", flags, n1, n2);
                    return "elements have different number of attributes";
                }
                a1 = n1.iterateAxis(2);
                while ((att1 = a1.next()) != null) {
                    AxisIterator a2iter = n2.iterateAxis(2, new SameNameTest(att1));
                    NodeInfo att2 = a2iter.next();
                    if (att2 == null) {
                        reason2 = "one element has an attribute " + NameOfNode.makeName(att1).getStructuredQName().getEQName() + ", the other does not";
                        DeepEqual.explain(reporter, (String)reason2, flags, n1, n2);
                        return reason2;
                    }
                    String attReason = DeepEqual.deepEquals(att1, att2, comparer, context, flags);
                    if (attReason == null) continue;
                    String reason6 = "elements have different values for the attribute " + NameOfNode.makeName(att1).getStructuredQName().getEQName() + " - " + attReason;
                    DeepEqual.explain(reporter, reason6, flags, n1, n2);
                    return reason6;
                }
                if ((flags & 1) != 0 && !(nm1 = n1.getAllNamespaces()).equals(nm2 = n2.getAllNamespaces())) {
                    reason2 = "elements have different in-scope namespaces: " + nm1 + " versus " + nm2;
                    DeepEqual.explain(reporter, (String)reason2, flags, n1, n2);
                    return reason2;
                }
                if ((flags & 0x40) != 0 && !n1.getSchemaType().equals(n2.getSchemaType())) {
                    reason = "elements have different type annotation";
                    DeepEqual.explain(reporter, "elements have different type annotation", flags, n1, n2);
                    return "elements have different type annotation";
                }
                if ((flags & 0x400) == 0) {
                    ComplexVariety variety2;
                    ComplexVariety variety1;
                    if (n1.getSchemaType().isComplexType() != n2.getSchemaType().isComplexType()) {
                        reason = "one element has complex type, the other simple";
                        DeepEqual.explain(reporter, "one element has complex type, the other simple", flags, n1, n2);
                        return "one element has complex type, the other simple";
                    }
                    if (n1.getSchemaType().isComplexType() && (variety1 = ((ComplexType)n1.getSchemaType()).getVariety()) != (variety2 = ((ComplexType)n2.getSchemaType()).getVariety())) {
                        reason2 = "both elements have complex type, but a different variety";
                        DeepEqual.explain(reporter, "both elements have complex type, but a different variety", flags, n1, n2);
                        return "both elements have complex type, but a different variety";
                    }
                }
                if ((flags & 0x20) == 0) {
                    boolean isSimple2;
                    SchemaType type1 = n1.getSchemaType();
                    SchemaType type2 = n2.getSchemaType();
                    boolean isSimple1 = type1.isSimpleType() || ((ComplexType)type1).isSimpleContent();
                    boolean bl = isSimple2 = type2.isSimpleType() || ((ComplexType)type2).isSimpleContent();
                    if (isSimple1 != isSimple2) {
                        String reason7 = "one element has a simple type, the other does not";
                        DeepEqual.explain(reporter, "one element has a simple type, the other does not", flags, n1, n2);
                        return "one element has a simple type, the other does not";
                    }
                    if (isSimple1) {
                        AtomicIterator v2;
                        assert (isSimple2);
                        AtomicIterator v1 = n1.atomize().iterate();
                        boolean typedValueComparison = DeepEqual.deepEqual(v1, v2 = n2.atomize().iterate(), comparer, context, flags);
                        return typedValueComparison ? null : "typed values of elements differ";
                    }
                }
                if ((flags & 0x200) != 0) {
                    if (n1.isId() != n2.isId()) {
                        reason = "one element is an ID, the other is not";
                        DeepEqual.explain(reporter, "one element is an ID, the other is not", flags, n1, n2);
                        return "one element is an ID, the other is not";
                    }
                    if (n1.isIdref() != n2.isIdref()) {
                        reason = "one element is an IDREF, the other is not";
                        DeepEqual.explain(reporter, "one element is an IDREF, the other is not", flags, n1, n2);
                        return "one element is an IDREF, the other is not";
                    }
                }
                CSharp.emitCode("goto case Saxon.Hej.type.Type.DOCUMENT;");
            }
            case 9: {
                NodeInfo d2;
                NodeInfo d1;
                String recursiveResult;
                AxisIterator c1 = n1.iterateAxis(3);
                AxisIterator c2 = n2.iterateAxis(3);
                do {
                    boolean r;
                    d1 = c1.next();
                    while (d1 != null && DeepEqual.isIgnorable(d1, flags)) {
                        d1 = c1.next();
                    }
                    d2 = c2.next();
                    while (d2 != null && DeepEqual.isIgnorable(d2, flags)) {
                        d2 = c2.next();
                    }
                    if (d1 != null && d2 != null) continue;
                    boolean bl = r = d1 == d2;
                    if (!r) {
                        String message = "the first operand contains a node with " + (d1 == null ? "fewer" : "more") + " children than the second";
                        if (d1 instanceof WhitespaceTextImpl || d2 instanceof WhitespaceTextImpl) {
                            message = message + " (the first extra child is whitespace text)";
                        }
                        DeepEqual.explain(reporter, message, flags, n1, n2);
                        return message;
                    }
                    return null;
                } while ((recursiveResult = DeepEqual.deepEquals(d1, d2, comparer, context, flags)) == null);
                return recursiveResult;
            }
            case 2: {
                if (!Navigator.haveSameName(n1, n2)) {
                    String reason = "attribute names differ: " + NameOfNode.makeName(n1).getStructuredQName().getEQName() + " != " + NameOfNode.makeName(n1).getStructuredQName().getEQName();
                    DeepEqual.explain(reporter, reason, flags, n1, n2);
                    return reason;
                }
                if ((flags & 2) != 0 && !n1.getPrefix().equals(n2.getPrefix())) {
                    String reason = "attribute prefixes differ: " + n1.getPrefix() + " != " + n2.getPrefix();
                    DeepEqual.explain(reporter, reason, flags, n1, n2);
                    return reason;
                }
                if ((flags & 0x40) != 0 && !n1.getSchemaType().equals(n2.getSchemaType())) {
                    String reason = "attributes have different type annotations";
                    DeepEqual.explain(reporter, "attributes have different type annotations", flags, n1, n2);
                    return "attributes have different type annotations";
                }
                boolean ar = (flags & 0x20) == 0 ? DeepEqual.deepEqual(n1.atomize().iterate(), n2.atomize().iterate(), comparer, context, 0) : comparer.comparesEqual(new StringValue(n1.getUnicodeStringValue()), new StringValue(n2.getUnicodeStringValue()));
                if (!ar) {
                    String reason = "attribute values differ";
                    DeepEqual.explain(reporter, "attribute values differ", flags, n1, n2);
                    return "attribute values differ";
                }
                if ((flags & 0x200) != 0) {
                    if (n1.isId() != n2.isId()) {
                        String reason = "one attribute is an ID, the other is not";
                        DeepEqual.explain(reporter, "one attribute is an ID, the other is not", flags, n1, n2);
                        return "one attribute is an ID, the other is not";
                    }
                    if (n1.isIdref() != n2.isIdref()) {
                        String reason = "one attribute is an IDREF, the other is not";
                        DeepEqual.explain(reporter, "one attribute is an IDREF, the other is not", flags, n1, n2);
                        return "one attribute is an IDREF, the other is not";
                    }
                }
                return null;
            }
            case 7: 
            case 13: {
                if (!n1.getLocalPart().equals(n2.getLocalPart())) {
                    String reason = Type.displayTypeName(n1) + " names differ";
                    DeepEqual.explain(reporter, reason, flags, n1, n2);
                    return reason;
                }
                CSharp.emitCode("goto case Saxon.Hej.type.Type.TEXT;");
            }
            case 3: 
            case 8: {
                boolean vr = comparer.comparesEqual((AtomicValue)n1.atomize(), (AtomicValue)n2.atomize());
                if (!vr) {
                    if ((flags & 0x80) != 0) {
                        String v1 = n1.getStringValue();
                        String v2 = n2.getStringValue();
                        Object message = "";
                        if (v1.length() != v2.length()) {
                            message = "lengths (" + v1.length() + "," + v2.length() + ")";
                        }
                        if (v1.length() < 10 && v2.length() < 10) {
                            message = " (\"" + v1 + "\" vs \"" + v2 + "\")";
                        } else {
                            int min = Math.min(v1.length(), v2.length());
                            if (v1.substring(0, min).equals(v2.substring(0, min))) {
                                message = (String)message + " different at char " + min + "(\"" + StringTool.diagnosticDisplay((v1.length() > v2.length() ? v1 : v2).substring(min)) + "\")";
                            } else if (v1.charAt(0) != v2.charAt(0)) {
                                message = (String)message + " different at start (\"" + v1.substring(0, Math.min(v1.length(), 10)) + "\", \"" + v2.substring(0, Math.min(v2.length(), 10)) + "\")";
                            } else {
                                for (int i = 1; i < min; ++i) {
                                    if (v1.substring(0, i).equals(v2.substring(0, i))) continue;
                                    message = (String)message + " different at char " + (i - 1) + "(\"" + v1.substring(i - 1, Math.min(v1.length(), i + 10)) + "\", \"" + v2.substring(i - 1, Math.min(v2.length(), i + 10)) + "\")";
                                    break;
                                }
                            }
                        }
                        DeepEqual.explain(reporter, Type.displayTypeName(n1) + " values differ (" + Navigator.getPath(n1) + ", " + Navigator.getPath(n2) + "): " + (String)message, flags, n1, n2);
                        return message;
                    }
                    return "atomized values differ";
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown node type");
    }

    private static boolean isIgnorable(NodeInfo node, int flags) {
        int kind = node.getNodeKind();
        if (kind == 8) {
            return (flags & 4) == 0;
        }
        if (kind == 7) {
            return (flags & 8) == 0;
        }
        if (kind == 3) {
            return (flags & 0x10) != 0 && Whitespace.isAllWhite(node.getUnicodeStringValue());
        }
        return false;
    }

    private static void explain(ErrorReporter reporter, String message, int flags, NodeInfo n1, NodeInfo n2) {
        if ((flags & 0x80) != 0) {
            reporter.report(new XmlProcessingIncident("deep-equal() " + (String)(n1 != null && n2 != null ? "comparing " + Navigator.getPath(n1) + " to " + Navigator.getPath(n2) + ": " : ": ") + message).asWarning());
        }
    }

    private static String showKind(Item item) {
        if (item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 3 && Whitespace.isAllWhite(item.getUnicodeStringValue())) {
            return "whitespace text() node";
        }
        return Type.displayTypeName(item);
    }

    private static String showNamespaces(HashSet<NamespaceBinding> bindings) {
        StringBuilder sb = new StringBuilder(256);
        for (NamespaceBinding binding : bindings) {
            sb.append(binding.getPrefix());
            sb.append("=");
            sb.append(binding.getNamespaceUri());
            sb.append(" ");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static SequenceIterator mergeAdjacentTextNodes(SequenceIterator in) throws XPathException {
        Item next;
        ArrayList<Item> items = new ArrayList<Item>(20);
        boolean prevIsText = false;
        UnicodeBuilder textBuffer = new UnicodeBuilder();
        while ((next = in.next()) != null) {
            if (next instanceof NodeInfo && ((NodeInfo)next).getNodeKind() == 3) {
                textBuffer.accept(next.getUnicodeStringValue());
                prevIsText = true;
                continue;
            }
            if (prevIsText) {
                Orphan textNode = new Orphan(null);
                textNode.setNodeKind((short)3);
                textNode.setStringValue(textBuffer.toUnicodeString());
                items.add(textNode);
                textBuffer.clear();
            }
            prevIsText = false;
            items.add(next);
        }
        if (prevIsText) {
            Orphan textNode = new Orphan(null);
            textNode.setNodeKind((short)3);
            textNode.setStringValue(textBuffer.toUnicodeString());
            items.add(textNode);
        }
        return new ListIterator.Of(items);
    }

    @Override
    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        GenericAtomicComparer comparer = new GenericAtomicComparer(this.getStringCollator(), context);
        boolean b = DeepEqual.deepEqual(arguments[0].iterate(), arguments[1].iterate(), comparer, context, 0);
        return BooleanValue.get(b);
    }

    @Override
    public String getStreamerName() {
        return "DeepEqual";
    }
}

