/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntPredicateProxy;

public class CodepointsToString
extends SystemFunction
implements Callable {
    public static StringValue unicodeToString(SequenceIterator chars, IntPredicateProxy checker) throws XPathException {
        UnicodeBuilder sb = new UnicodeBuilder();
        NumericValue nextInt;
        while ((nextInt = (NumericValue)chars.next()) != null) {
            long next = nextInt.longValue();
            if (next < 0L || next > Integer.MAX_VALUE || !checker.test((int)next)) {
                throw new XPathException("codepoints-to-string(): invalid XML character [x" + Integer.toHexString((int)next) + "]", "FOCH0001");
            }
            sb.append((int)next);
        }
        return new StringValue(sb.toUnicodeString());
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        SequenceIterator chars = arguments[0].iterate();
        return CodepointsToString.unicodeToString(chars, context.getConfiguration().getValidCharacterChecker());
    }

    @Override
    public String getStreamerName() {
        return "CodepointsToString";
    }
}

