/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.ForMemberClause;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;

public class ForMemberClausePush
extends TuplePush {
    protected TuplePush destination;
    protected ForMemberClause forMemberClause;

    public ForMemberClausePush(Outputter outputter, TuplePush destination, ForMemberClause forClause) {
        super(outputter);
        this.destination = destination;
        this.forMemberClause = forClause;
    }

    @Override
    public void processTuple(XPathContext context) throws XPathException {
        ArrayItem arrayItem = this.forMemberClause.evaluateArrayExpression(context);
        int pos = 0;
        for (GroundedValue member : arrayItem.members()) {
            context.setLocalVariable(this.forMemberClause.getRangeVariable().getLocalSlotNumber(), member);
            if (this.forMemberClause.getPositionVariable() != null) {
                context.setLocalVariable(this.forMemberClause.getPositionVariable().getLocalSlotNumber(), new Int64Value(++pos));
            }
            this.destination.processTuple(context);
        }
    }

    @Override
    public void close() throws XPathException {
        this.destination.close();
    }
}

