/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.SequenceMapper;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;

public class MappingIterator
implements SequenceIterator {
    private final SequenceIterator base;
    private final MappingFunction action;
    private SequenceIterator results = null;

    public MappingIterator(SequenceIterator base, MappingFunction action) {
        this.base = base;
        this.action = action;
    }

    public static MappingIterator map(SequenceIterator base, SequenceMapper.Lambda mappingExpression) {
        return new MappingIterator(base, SequenceMapper.of(mappingExpression));
    }

    @Override
    public Item next() {
        try {
            Item nextItem;
            block5: {
                while (true) {
                    Item nextSource;
                    if (this.results != null) {
                        nextItem = this.results.next();
                        if (nextItem != null) break block5;
                        this.results = null;
                    }
                    if ((nextSource = this.base.next()) == null) break;
                    SequenceIterator obj = this.action.map(nextSource);
                    if (obj == null) continue;
                    this.results = obj;
                    nextItem = this.results.next();
                    if (nextItem == null) {
                        this.results = null;
                        continue;
                    }
                    break block5;
                    break;
                }
                this.results = null;
                return null;
            }
            return nextItem;
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    @Override
    public void close() {
        if (this.results != null) {
            this.results.close();
        }
        this.base.close();
    }
}

