/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.LocalVariableEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;

public class LocalVariableReference
extends VariableReference {
    int slotNumber = -999;

    public LocalVariableReference(StructuredQName name) {
        super(name);
    }

    public LocalVariableReference(LocalBinding binding) {
        super(binding);
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        if (this.binding == null) {
            throw new UnsupportedOperationException("Cannot copy a variable reference whose binding is unknown");
        }
        LocalVariableReference ref = new LocalVariableReference(this.getVariableName());
        ref.copyFrom(this);
        ref.slotNumber = this.slotNumber;
        Binding newBinding = rebindings.get(this.binding);
        if (newBinding != null) {
            ref.binding = newBinding;
        }
        ref.binding.addReference(ref, this.isInLoop());
        return ref;
    }

    public void setBinding(LocalBinding binding) {
        this.binding = binding;
    }

    @Override
    public LocalBinding getBinding() {
        return (LocalBinding)super.getBinding();
    }

    public void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    @Override
    public Sequence evaluateVariable(XPathContext c) throws XPathException {
        try {
            return c.getStackFrame().slots[this.slotNumber];
        }
        catch (ArrayIndexOutOfBoundsException err) {
            if (this.slotNumber == -999) {
                if (this.binding != null) {
                    try {
                        this.slotNumber = this.getBinding().getLocalSlotNumber();
                        return c.getStackFrame().slots[this.slotNumber];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                throw new ArrayIndexOutOfBoundsException("Local variable $" + this.getDisplayName() + " has not been allocated a stack frame slot");
            }
            int actual = c.getStackFrame().slots.length;
            throw new ArrayIndexOutOfBoundsException("Local variable $" + this.getDisplayName() + " uses slot " + this.slotNumber + " but " + (String)(actual == 0 ? "no" : "only " + c.getStackFrame().slots.length) + " slots are allocated on the stack frame");
        }
    }

    @Override
    public String getExpressionName() {
        return "locVarRef";
    }

    @Override
    public Elaborator getElaborator() {
        return new LocalVariableReferenceElaborator();
    }

    public static class LocalVariableReferenceElaborator
    extends PullElaborator {
        @Override
        public void setExpression(Expression expr) {
            super.setExpression(expr);
            if (((LocalVariableReference)expr).getSlotNumber() < 0) {
                throw new IllegalStateException("Can't elaborate a local variable reference before slot numbers have been allocated");
            }
        }

        @Override
        public SequenceEvaluator eagerly() {
            LocalVariableReference varRef = (LocalVariableReference)this.getExpression();
            int slot = varRef.getSlotNumber();
            return new LocalVariableEvaluator(slot);
        }

        @Override
        public SequenceEvaluator lazily(boolean repeatable) {
            return this.eagerly();
        }

        @Override
        public PullEvaluator elaborateForPull() {
            LocalVariableReference varRef = (LocalVariableReference)this.getExpression();
            int slot = varRef.getSlotNumber();
            return context -> context.evaluateLocalVariable(slot).iterate();
        }

        @Override
        public PushEvaluator elaborateForPush() {
            LocalVariableReference varRef = (LocalVariableReference)this.getExpression();
            int slot = varRef.getSlotNumber();
            return (out, context) -> {
                try {
                    Item it;
                    SequenceIterator value = context.evaluateLocalVariable(slot).iterate();
                    while ((it = value.next()) != null) {
                        out.append(it);
                    }
                    return null;
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this.getExpression().getLocation());
                    e.maybeSetContext(context);
                    throw e;
                }
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            LocalVariableReference varRef = (LocalVariableReference)this.getExpression();
            int slot = varRef.getSlotNumber();
            return context -> {
                try {
                    return context.evaluateLocalVariable(slot).head();
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this.getExpression().getLocation());
                    e.maybeSetContext(context);
                    throw e;
                }
            };
        }
    }
}

