/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.IndexedVariableEvaluator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.LearningEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class LetExpression
extends Assignation {
    private SequenceEvaluator evaluator = null;
    private boolean needsEagerEvaluation = false;
    private boolean needsLazyEvaluation = false;
    private boolean _isInstruction;

    public void setInstruction(boolean inst) {
        this._isInstruction = inst;
    }

    @Override
    public boolean isInstruction() {
        return this._isInstruction;
    }

    @Override
    public String getExpressionName() {
        return "let";
    }

    public void setNeedsEagerEvaluation(boolean req) {
        if (!req || this.needsLazyEvaluation) {
            // empty if block
        }
        this.needsEagerEvaluation = req;
    }

    public void setNeedsLazyEvaluation(boolean req) {
        if (req && this.needsEagerEvaluation) {
            this.needsEagerEvaluation = false;
        }
        this.needsLazyEvaluation = req;
    }

    public boolean isNeedsLazyEvaluation() {
        return this.needsLazyEvaluation;
    }

    public boolean isNeedsEagerEvaluation() {
        return this.needsEagerEvaluation;
    }

    @Override
    public boolean supportsLazyEvaluation() {
        return !this.needsEagerEvaluation;
    }

    @Override
    public boolean isLiftable(boolean forStreaming) {
        return super.isLiftable(forStreaming) && !this.needsEagerEvaluation;
    }

    @Override
    public void resetLocalStaticProperties() {
        super.resetLocalStaticProperties();
        this.references = new ArrayList();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getSequenceOp().typeCheck(visitor, contextInfo);
        Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(3, this.getVariableQName().getDisplayName(), 0);
        this.setSequence(TypeChecker.strictTypeCheck(this.getSequence(), this.requiredType, role, visitor.getStaticContext()));
        ItemType actualItemType = this.getSequence().getItemType();
        this.refineTypeInformation(actualItemType, this.getSequence().getCardinality(), this.getSequence() instanceof Literal ? ((Literal)this.getSequence()).getGroundedValue() : null, this.getSequence().getSpecialProperties(), this);
        this.getActionOp().typeCheck(visitor, contextInfo);
        return this;
    }

    @Override
    public boolean implementsStaticTypeCheck() {
        return true;
    }

    @Override
    public Expression staticTypeCheck(SequenceType req, boolean backwardsCompatible, Supplier<RoleDiagnostic> roleSupplier, ExpressionVisitor visitor) throws XPathException {
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(backwardsCompatible);
        this.setAction(tc.staticTypeCheck(this.getAction(), req, roleSupplier, visitor));
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Optimizer opt = visitor.obtainOptimizer();
        if (this.getAction() instanceof VariableReference && ((VariableReference)this.getAction()).getBinding() == this && !ExpressionTool.changesXsltContext(this.getSequence())) {
            this.getSequenceOp().optimize(visitor, contextItemType);
            opt.trace("Eliminated trivial variable " + this.getVariableName(), this.getSequence());
            return this.getSequence();
        }
        if (this.getSequence() instanceof Literal && opt.isOptionSet(4)) {
            opt.trace("Inlined constant variable " + this.getVariableName(), this.getSequence());
            this.replaceVariable(this.getSequence());
            return this.getAction().optimize(visitor, contextItemType);
        }
        if (this.getSequence() instanceof DocumentInstr && ((DocumentInstr)this.getSequence()).isTextOnly()) {
            this.verifyReferences();
            if (this.allReferencesAreFlattened()) {
                Expression stringValueExpression = ((DocumentInstr)this.getSequence()).getStringValueExpression();
                stringValueExpression = stringValueExpression.typeCheck(visitor, contextItemType);
                this.setSequence(stringValueExpression);
                this.requiredType = SequenceType.SINGLE_UNTYPED_ATOMIC;
                this.adoptChildExpression(this.getSequence());
                this.refineTypeInformation(this.requiredType.getPrimaryType(), this.requiredType.getCardinality(), null, 0, this);
            }
        }
        if (this.getSequence().hasSpecialProperty(0x2000000)) {
            this.needsEagerEvaluation = true;
        }
        this.hasLoopingReference |= this.removeDeadReferences();
        if (!this.needsEagerEvaluation) {
            boolean considerRemoval;
            boolean bl = considerRemoval = (this.references != null && this.references.size() < 2 || this.getSequence() instanceof VariableReference) && !this.indexedVariable && !this.hasLoopingReference && !this.needsEagerEvaluation;
            if (considerRemoval) {
                this.verifyReferences();
                boolean bl2 = considerRemoval = this.references != null;
            }
            if (considerRemoval && this.references.isEmpty()) {
                this.getActionOp().optimize(visitor, contextItemType);
                opt.trace("Eliminated unused variable " + this.getVariableName(), this.getAction());
                return this.getAction();
            }
            if (considerRemoval && this.references.size() == 1 && ExpressionTool.dependsOnFocus(this.getSequence())) {
                if (visitor.isOptimizeForStreaming()) {
                    considerRemoval = false;
                }
                Expression child = (Expression)this.references.get(0);
                Expression parent = child.getParentExpression();
                while (parent != null && parent != this) {
                    Operand operand = ExpressionTool.findOperand(parent, child);
                    assert (operand != null);
                    if (!operand.hasSameFocus()) {
                        considerRemoval = false;
                        break;
                    }
                    child = parent;
                    parent = child.getParentExpression();
                }
            }
            if (considerRemoval && this.references.size() == 1) {
                if (ExpressionTool.changesXsltContext(this.getSequence())) {
                    considerRemoval = false;
                } else if ((this.getSequence().getDependencies() & 0x20) != 0) {
                    considerRemoval = false;
                } else if (((VariableReference)this.references.get(0)).isInLoop()) {
                    considerRemoval = false;
                }
            }
            if (considerRemoval && (this.references.size() == 1 || this.getSequence() instanceof Literal || this.getSequence() instanceof VariableReference) && opt.isOptionSet(4)) {
                this.inlineReferences();
                opt.trace("Inlined references to $" + this.getVariableName(), this.getAction());
                this.references = null;
                return this.getAction().optimize(visitor, contextItemType);
            }
        }
        int tries = 0;
        while (tries++ < 5) {
            Expression seq0 = this.getSequence();
            this.getSequenceOp().optimize(visitor, contextItemType);
            if (this.getSequence() instanceof Literal && !this.indexedVariable && opt.isOptionSet(4)) {
                return this.optimize(visitor, contextItemType);
            }
            if (seq0 != this.getSequence()) continue;
            break;
        }
        tries = 0;
        while (tries++ < 5) {
            Expression act0 = this.getAction();
            this.getActionOp().optimize(visitor, contextItemType);
            if (act0 == this.getAction()) break;
            if (this.indexedVariable || this.needsEagerEvaluation) continue;
            this.verifyReferences();
            if (this.references == null || this.references.size() >= 2) continue;
            if (this.references.isEmpty()) {
                this.hasLoopingReference = false;
                return this.optimize(visitor, contextItemType);
            }
            if (((VariableReference)this.references.get(0)).isInLoop()) continue;
            return this.optimize(visitor, contextItemType);
        }
        return this;
    }

    public void setEvaluator() {
        if (this.isIndexedVariable()) {
            PullEvaluator pullEval = this.getSequence().makeElaborator().elaborateForPull();
            this.setEvaluator(new IndexedVariableEvaluator(pullEval));
        } else if (this.needsEagerEvaluation || !this.getSequence().supportsLazyEvaluation()) {
            this.setEvaluator(this.getSequence().makeElaborator().eagerly());
        } else if (this.needsLazyEvaluation) {
            this.setEvaluator(this.getSequence().makeElaborator().lazily(this.getNominalReferenceCount() > 1));
        } else if (this.evaluator == null) {
            this.setEvaluator(new LearningEvaluator(this.getSequence(), this.getSequence().makeElaborator().lazily(this.getNominalReferenceCount() > 1)));
        }
    }

    private void inlineReferences() {
        for (VariableReference ref : this.references) {
            Expression parent = ref.getParentExpression();
            if (parent == null) continue;
            Operand o = ExpressionTool.findOperand(parent, ref);
            if (o != null) {
                o.setChildExpression(this.getSequence().copy(new RebindingMap()));
            }
            ExpressionTool.resetStaticProperties(parent);
        }
    }

    @Override
    public double getCost() {
        return this.getSequence().getCost() + this.getAction().getCost();
    }

    private boolean allReferencesAreFlattened() {
        if (this.references != null) {
            for (VariableReference ref : this.references) {
                if (ref.isFlattened()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuousExpression() {
        return this.getAction().isVacuousExpression();
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        this.getAction().checkPermittedContents(parentType, whole);
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return this.getAction().getIntegerBounds();
    }

    @Override
    public int getImplementationMethod() {
        return this.getAction().getImplementationMethod();
    }

    @Override
    public void gatherProperties(BiConsumer<String, Object> consumer) {
        consumer.accept("name", this.getVariableQName());
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.getAction() instanceof LetExpression)) break;
            let = (LetExpression)let.getAction();
        }
        return let.getAction().iterate(context);
    }

    public Sequence eval(XPathContext context) throws XPathException {
        if (this.evaluator == null) {
            if (this.needsEagerEvaluation) {
                this.setEvaluator(this.getSequence().makeElaborator().eagerly());
            } else {
                this.setEvaluator(new LearningEvaluator(this.getSequence(), this.getSequence().makeElaborator().lazily(this.getNominalReferenceCount() > 1)));
            }
        }
        try {
            int savedOutputState = context.getTemporaryOutputState();
            context.setTemporaryOutputState(218);
            Sequence result = this.evaluator.evaluate(context);
            context.setTemporaryOutputState(savedOutputState);
            return result;
        }
        catch (ClassCastException e) {
            assert (false);
            int savedOutputState = context.getTemporaryOutputState();
            context.setTemporaryOutputState(218);
            GroundedValue result = ExpressionTool.eagerEvaluate(this.getSequence(), context);
            context.setTemporaryOutputState(savedOutputState);
            return result;
        }
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForItem().eval(context);
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.getAction() instanceof LetExpression)) break;
            let = (LetExpression)let.getAction();
        }
        return let.getAction().effectiveBooleanValue(context);
    }

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        LetExpression.dispatchTailCall(this.makeElaborator().elaborateForPush().processLeavingTail(output, context));
    }

    @Override
    public ItemType getItemType() {
        return this.getAction().getItemType();
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        if (this.isInstruction()) {
            return UType.ANY;
        }
        return this.getAction().getStaticUType(contextItemType);
    }

    @Override
    protected int computeCardinality() {
        return this.getAction().getCardinality();
    }

    @Override
    protected int computeSpecialProperties() {
        int props = this.getAction().getSpecialProperties();
        int seqProps = this.getSequence().getSpecialProperties();
        if ((seqProps & 0x800000) == 0) {
            props &= 0xFF7FFFFF;
        }
        return props;
    }

    @Override
    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        return ExpressionTool.markTailFunctionCalls(this.getAction(), qName, arity);
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        LetExpression let = new LetExpression();
        rebindings.put(this, let);
        let.indexedVariable = this.indexedVariable;
        let.hasLoopingReference = this.hasLoopingReference;
        let.setNeedsEagerEvaluation(this.needsEagerEvaluation);
        let.setNeedsLazyEvaluation(this.needsLazyEvaluation);
        let.setVariableQName(this.variableName);
        let.setRequiredType(this.requiredType);
        let.setSequence(this.getSequence().copy(rebindings));
        let.setInstruction(this.isInstruction());
        ExpressionTool.copyLocationInfo(this, let);
        Expression newAction = this.getAction().copy(rebindings);
        let.setAction(newAction);
        return let;
    }

    @Override
    public String toString() {
        return "let $" + this.getVariableEQName() + " := " + this.getSequence() + " return " + ExpressionTool.parenthesize(this.getAction());
    }

    @Override
    public String toShortString() {
        return "let $" + this.getVariableName() + " := ...";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("let", this);
        out.emitAttribute("var", this.variableName);
        if (this.getRequiredType() != SequenceType.ANY_SEQUENCE) {
            out.emitAttribute("as", this.getRequiredType().toAlphaCode());
        }
        if (this.isIndexedVariable()) {
            out.emitAttribute("indexable", "true");
        }
        out.emitAttribute("slot", "" + this.getLocalSlotNumber());
        if (this.needsEagerEvaluation || this.needsLazyEvaluation) {
            String flags = (this.needsEagerEvaluation ? "e" : "") + (this.needsLazyEvaluation ? "l" : "");
            out.emitAttribute("flags", flags);
        }
        this.getSequence().export(out);
        this.getAction().export(out);
        out.endElement();
    }

    public void setEvaluator(SequenceEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public SequenceEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public Elaborator getElaborator() {
        return new LetExprElaborator();
    }

    private static class EagerLocalVariableEvaluator
    implements SequenceEvaluator {
        private final int slot;
        private final SequenceEvaluator selectEval;
        private final SequenceEvaluator actionEval;

        public EagerLocalVariableEvaluator(int slot, SequenceEvaluator selectEval, SequenceEvaluator actionEval) {
            this.slot = slot;
            this.selectEval = selectEval;
            this.actionEval = actionEval;
        }

        @Override
        public Sequence evaluate(XPathContext context) throws XPathException {
            int savedOutputState = context.getTemporaryOutputState();
            context.setTemporaryOutputState(218);
            Sequence value = this.selectEval.evaluate(context);
            context.setLocalVariable(this.slot, value);
            context.setTemporaryOutputState(savedOutputState);
            return this.actionEval.evaluate(context);
        }
    }

    public static class LetExprElaborator
    extends PullElaborator {
        private Expression finalAction;

        private boolean repeatable(LetExpression let) {
            return let.getNominalReferenceCount() > 1;
        }

        private SequenceEvaluator makeSequenceEvaluator(LetExpression let) {
            if (let.evaluator != null) {
                return let.evaluator;
            }
            let.setEvaluator();
            return let.evaluator;
        }

        private ItemEvaluator setAllVariables(LetExpression start) {
            ArrayList<LetExpression> setters = new ArrayList<LetExpression>();
            setters.add(start);
            Expression next = start.getAction();
            while (next instanceof LetExpression) {
                setters.add((LetExpression)next);
                next = ((LetExpression)next).getAction();
            }
            this.finalAction = next;
            switch (setters.size()) {
                case 1: {
                    LetExpression let = (LetExpression)setters.get(0);
                    SequenceEvaluator evaluator = this.makeSequenceEvaluator(let);
                    int slot = ((LetExpression)setters.get((int)0)).slotNumber;
                    return context -> {
                        context.setLocalVariable(slot, evaluator.evaluate(context));
                        return null;
                    };
                }
                case 2: {
                    SequenceEvaluator evaluator0 = this.makeSequenceEvaluator((LetExpression)setters.get(0));
                    int slot0 = ((LetExpression)setters.get((int)0)).slotNumber;
                    SequenceEvaluator evaluator1 = this.makeSequenceEvaluator((LetExpression)setters.get(1));
                    int slot1 = ((LetExpression)setters.get((int)1)).slotNumber;
                    return context -> {
                        context.setLocalVariable(slot0, evaluator0.evaluate(context));
                        context.setLocalVariable(slot1, evaluator1.evaluate(context));
                        return null;
                    };
                }
                case 3: {
                    SequenceEvaluator evaluator0 = this.makeSequenceEvaluator((LetExpression)setters.get(0));
                    int slot0 = ((LetExpression)setters.get((int)0)).slotNumber;
                    SequenceEvaluator evaluator1 = this.makeSequenceEvaluator((LetExpression)setters.get(1));
                    int slot1 = ((LetExpression)setters.get((int)1)).slotNumber;
                    SequenceEvaluator evaluator2 = this.makeSequenceEvaluator((LetExpression)setters.get(2));
                    int slot2 = ((LetExpression)setters.get((int)2)).slotNumber;
                    return context -> {
                        context.setLocalVariable(slot0, evaluator0.evaluate(context));
                        context.setLocalVariable(slot1, evaluator1.evaluate(context));
                        context.setLocalVariable(slot2, evaluator2.evaluate(context));
                        return null;
                    };
                }
                case 4: {
                    SequenceEvaluator evaluator0 = this.makeSequenceEvaluator((LetExpression)setters.get(0));
                    int slot0 = ((LetExpression)setters.get((int)0)).slotNumber;
                    SequenceEvaluator evaluator1 = this.makeSequenceEvaluator((LetExpression)setters.get(1));
                    int slot1 = ((LetExpression)setters.get((int)1)).slotNumber;
                    SequenceEvaluator evaluator2 = this.makeSequenceEvaluator((LetExpression)setters.get(2));
                    int slot2 = ((LetExpression)setters.get((int)2)).slotNumber;
                    SequenceEvaluator evaluator3 = this.makeSequenceEvaluator((LetExpression)setters.get(3));
                    int slot3 = ((LetExpression)setters.get((int)3)).slotNumber;
                    return context -> {
                        context.setLocalVariable(slot0, evaluator0.evaluate(context));
                        context.setLocalVariable(slot1, evaluator1.evaluate(context));
                        context.setLocalVariable(slot2, evaluator2.evaluate(context));
                        context.setLocalVariable(slot3, evaluator3.evaluate(context));
                        return null;
                    };
                }
            }
            SequenceEvaluator[] evaluators = new SequenceEvaluator[setters.size()];
            int[] slots = new int[setters.size()];
            for (int i = 0; i < setters.size(); ++i) {
                evaluators[i] = this.makeSequenceEvaluator((LetExpression)setters.get(i));
                slots[i] = ((LetExpression)setters.get((int)i)).slotNumber;
            }
            return context -> {
                for (int i = 0; i < slots.length; ++i) {
                    context.setLocalVariable(slots[i], evaluators[i].evaluate(context));
                }
                return null;
            };
        }

        @Override
        public SequenceEvaluator eagerly() {
            LetExpression expr = (LetExpression)this.getExpression();
            SequenceEvaluator selectEval = expr.getSequence().makeElaborator().eagerly();
            SequenceEvaluator actionEval = expr.getAction().makeElaborator().eagerly();
            int slot = expr.getLocalSlotNumber();
            return new EagerLocalVariableEvaluator(slot, selectEval, actionEval);
        }

        @Override
        public PullEvaluator elaborateForPull() {
            LetExpression expr = (LetExpression)this.getExpression();
            ItemEvaluator setter = this.setAllVariables(expr);
            PullEvaluator actionPull = this.finalAction.makeElaborator().elaborateForPull();
            return context -> {
                int savedOutputState = context.getTemporaryOutputState();
                context.setTemporaryOutputState(218);
                setter.eval(context);
                context.setTemporaryOutputState(savedOutputState);
                return actionPull.iterate(context);
            };
        }

        @Override
        public PushEvaluator elaborateForPush() {
            LetExpression expr = (LetExpression)this.getExpression();
            ItemEvaluator setter = this.setAllVariables(expr);
            PushEvaluator actionPush = this.finalAction.makeElaborator().elaborateForPush();
            return (out, context) -> {
                int savedOutputState = context.getTemporaryOutputState();
                context.setTemporaryOutputState(218);
                setter.eval(context);
                context.setTemporaryOutputState(savedOutputState);
                return actionPush.processLeavingTail(out, context);
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            LetExpression expr = (LetExpression)this.getExpression();
            ItemEvaluator setter = this.setAllVariables(expr);
            ItemEvaluator actionEval = this.finalAction.makeElaborator().elaborateForItem();
            return context -> {
                int savedOutputState = context.getTemporaryOutputState();
                context.setTemporaryOutputState(218);
                setter.eval(context);
                context.setTemporaryOutputState(savedOutputState);
                return actionEval.eval(context);
            };
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            LetExpression expr = (LetExpression)this.getExpression();
            ItemEvaluator setter = this.setAllVariables(expr);
            UpdateEvaluator actionEval = this.finalAction.makeElaborator().elaborateForUpdate();
            return (context, pul) -> {
                int savedOutputState = context.getTemporaryOutputState();
                context.setTemporaryOutputState(218);
                setter.eval(context);
                context.setTemporaryOutputState(savedOutputState);
                actionEval.registerUpdates(context, pul);
            };
        }
    }
}

