/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.function.Supplier;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.AscendingRangeIterator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.IntegerValue;

public class ForMemberExpression
extends Assignation {
    @Override
    public String getExpressionName() {
        return "forMember";
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getSequenceOp().typeCheck(visitor, contextInfo);
        Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(20, "'in' clause of for-member", 0);
        Expression operand = visitor.getConfiguration().getTypeChecker(false).staticTypeCheck(this.getSequence(), ArrayItemType.SINGLE_ARRAY, role, visitor);
        this.setSequence(operand);
        if (Literal.isEmptySequence(this.getAction())) {
            return this.getAction();
        }
        this.getActionOp().typeCheck(visitor, contextInfo);
        return this;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return this.getAction().getIntegerBounds();
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ForMemberExpression forExp = new ForMemberExpression();
        ExpressionTool.copyLocationInfo(this, forExp);
        forExp.setRequiredType(this.requiredType);
        forExp.setVariableQName(this.variableName);
        forExp.setSequence(this.getSequence().copy(rebindings));
        Expression newAction = this.getAction().copy(rebindings);
        forExp.setAction(newAction);
        forExp.variableName = this.variableName;
        forExp.slotNumber = this.slotNumber;
        ExpressionTool.rebindVariableReferences(newAction, this, forExp);
        return forExp;
    }

    @Override
    public boolean isVacuousExpression() {
        return this.getAction().isVacuousExpression();
    }

    @Override
    public int getImplementationMethod() {
        return 6;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        this.getAction().checkPermittedContents(parentType, false);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        ForMemberExpression.dispatchTailCall(this.makeElaborator().elaborateForPush().processLeavingTail(output, context));
    }

    @Override
    public ItemType getItemType() {
        return this.getAction().getItemType();
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return this.getAction().getStaticUType(contextItemType);
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    public String toString() {
        return "for member $" + this.getVariableEQName() + " in " + (this.getSequence() == null ? "(...)" : this.getSequence().toString()) + " return " + (this.getAction() == null ? "(...)" : ExpressionTool.parenthesize(this.getAction()));
    }

    @Override
    public String toShortString() {
        return "for member $" + this.getVariableQName().getDisplayName() + " in " + (this.getSequence() == null ? "(...)" : this.getSequence().toShortString()) + " return " + (this.getAction() == null ? "(...)" : this.getAction().toShortString());
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("forMember", this);
        out.emitAttribute("var", this.getVariableQName());
        out.emitAttribute("slot", "" + this.getLocalSlotNumber());
        out.setChildRole("in");
        this.getSequence().export(out);
        out.setChildRole("return");
        this.getAction().export(out);
        out.endElement();
    }

    @Override
    public String getStreamerName() {
        return "ForMemberExpression";
    }

    @Override
    public Elaborator getElaborator() {
        return new ForMemberExprElaborator();
    }

    public static class ForMemberExprElaborator
    extends PullElaborator {
        @Override
        public PullEvaluator elaborateForPull() {
            ForMemberExpression expr = (ForMemberExpression)this.getExpression();
            ItemEvaluator arrayEval = expr.getSequence().makeElaborator().elaborateForItem();
            PullEvaluator actionEval = expr.getAction().makeElaborator().elaborateForPull();
            int slot = expr.getLocalSlotNumber();
            return context -> {
                ArrayItem theArray = (ArrayItem)arrayEval.eval(context);
                int length = theArray.arrayLength();
                AscendingRangeIterator base = new AscendingRangeIterator(0L, 1L, length - 1);
                return MappingIterator.map(base, index -> {
                    GroundedValue member = theArray.get((int)((IntegerValue)index).longValue());
                    context.setLocalVariable(slot, member);
                    return actionEval.iterate(context);
                });
            };
        }

        @Override
        public PushEvaluator elaborateForPush() {
            ForExpression expr = (ForExpression)this.getExpression();
            ItemEvaluator selectEval = expr.getSequence().makeElaborator().elaborateForItem();
            PushEvaluator actionEval = expr.getAction().makeElaborator().elaborateForPush();
            int slot = expr.getLocalSlotNumber();
            return (output, context) -> {
                ArrayItem theArray = (ArrayItem)selectEval.eval(context);
                for (GroundedValue member : theArray.members()) {
                    context.setLocalVariable(slot, member);
                    TailCall tail = actionEval.processLeavingTail(output, context);
                    Expression.dispatchTailCall(tail);
                }
                return null;
            };
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            ForExpression expr = (ForExpression)this.getExpression();
            ItemEvaluator selectEval = expr.getSequence().makeElaborator().elaborateForItem();
            UpdateEvaluator actionEval = expr.getAction().makeElaborator().elaborateForUpdate();
            int slot = expr.getLocalSlotNumber();
            return (context, pul) -> {
                ArrayItem theArray = (ArrayItem)selectEval.eval(context);
                for (GroundedValue member : theArray.members()) {
                    context.setLocalVariable(slot, member);
                    actionEval.registerUpdates(context, pul);
                }
            };
        }
    }
}

