/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.z.IntArraySet;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntToIntHashMap;
import net.sf.saxon.z.IntToIntMap;

public class CaseVariants {
    private final IntToIntMap monoVariants = new IntToIntHashMap(2500);
    private final IntHashMap<int[]> polyVariants = new IntHashMap(100);
    public static int[] ROMAN_VARIANTS = new int[]{304, 305, 8490, 383};

    private CaseVariants() {
        this.build();
    }

    private static CaseVariants getInstance() {
        return Holder.INSTANCE;
    }

    private void build() {
        NodeInfo item;
        NodeInfo doc;
        InputStream in = Version.platform.locateResource("casevariants.xml", new ArrayList<String>());
        if (in == null) {
            throw new RuntimeException("Unable to read casevariants.xml file");
        }
        Configuration config = new Configuration();
        ParseOptions options = new ParseOptions();
        options.setSchemaValidationMode(4);
        options.setDTDValidationMode(4);
        try {
            doc = config.buildDocumentTree(new StreamSource(in, "casevariants.xml"), options).getRootNode();
        }
        catch (XPathException e) {
            throw new RuntimeException("Failed to build casevariants.xml", e);
        }
        AxisIterator iter = doc.iterateAxis(4, new NameTest(1, "", "c", config.getNamePool()));
        while ((item = iter.next()) != null) {
            String code = item.getAttributeValue("", "n");
            int icode = Integer.parseInt(code, 16);
            String variants = item.getAttributeValue("", "v");
            String[] vhex = variants.split(",");
            int[] vint = new int[vhex.length];
            for (int i = 0; i < vhex.length; ++i) {
                vint[i] = Integer.parseInt(vhex[i], 16);
            }
            if (vhex.length == 1) {
                this.monoVariants.put(icode, vint[0]);
                continue;
            }
            this.polyVariants.put(icode, vint);
        }
    }

    public static int[] getCaseVariants(int code) {
        CaseVariants variants = CaseVariants.getInstance();
        IntToIntMap monoVariants = variants.monoVariants;
        int mono = monoVariants.get(code);
        if (mono != monoVariants.getDefaultValue()) {
            return new int[]{mono};
        }
        int[] result = variants.polyVariants.get(code);
        if (result == null) {
            return IntArraySet.EMPTY_INT_ARRAY;
        }
        return result;
    }

    private static class Holder {
        public static final CaseVariants INSTANCE = new CaseVariants();

        private Holder() {
        }
    }
}

