/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.impl;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.MissingResourceException;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.java.lang._Class;
import net.sf.retrotranslator.runtime.java.lang.reflect.ParameterizedType_;

public class RuntimeTools {
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String STATIC_NAME = "<clinit>";
    public static final String CLASS_EXTENSION = ".class";
    public static final String CONCURRENT_PREFIX;
    static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$concurrent$ConcurrentMap;

    public static Class getBaseClass(char type) {
        return RuntimeTools.getBaseClass(Type.getType(new String(new char[]{type})));
    }

    public static Class getBaseClass(Type type) {
        switch (type.getSort()) {
            case 0: {
                return Void.TYPE;
            }
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
        }
        return null;
    }

    public static String getConstructorDescriptor(Constructor c) {
        Class<?>[] parameters = c.getParameterTypes();
        StringBuffer buf = new StringBuffer("(");
        Class<?>[] arr$ = parameters;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Class<?> parameter = arr$[i$];
            buf.append(Type.getDescriptor(parameter));
        }
        return buf.append(")V").toString();
    }

    public static Object cloneNonEmptyArray(Object value) {
        if (!value.getClass().isArray() || Array.getLength(value) == 0) {
            return value;
        }
        if (value instanceof Object[]) {
            return ((Object[])value).clone();
        }
        if (value instanceof boolean[]) {
            return ((boolean[])value).clone();
        }
        if (value instanceof byte[]) {
            return ((byte[])value).clone();
        }
        if (value instanceof char[]) {
            return ((char[])value).clone();
        }
        if (value instanceof double[]) {
            return ((double[])value).clone();
        }
        if (value instanceof float[]) {
            return ((float[])value).clone();
        }
        if (value instanceof int[]) {
            return ((int[])value).clone();
        }
        if (value instanceof long[]) {
            return ((long[])value).clone();
        }
        if (value instanceof short[]) {
            return ((short[])value).clone();
        }
        throw new IllegalStateException();
    }

    public static String getString(Object type) {
        if (!(type instanceof Class)) {
            return type.toString();
        }
        Class<?> aClass = (Class<?>)type;
        int dimensionCount = 0;
        while (aClass.isArray()) {
            aClass = aClass.getComponentType();
            ++dimensionCount;
        }
        if (dimensionCount == 0) {
            return aClass.getName();
        }
        StringBuffer builder = new StringBuffer();
        builder.append(aClass.getName());
        while (dimensionCount > 0) {
            builder.append("[]");
            --dimensionCount;
        }
        return builder.toString();
    }

    public static StringBuffer append(StringBuffer builder, Object[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(RuntimeTools.getString(types[i]));
        }
        return builder;
    }

    public static byte[] readResourceToByteArray(Class loader, String resourceName) throws MissingResourceException {
        return RuntimeTools.readAndClose(loader.getResourceAsStream(resourceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAndClose(InputStream inputStream) {
        byte[] byArray;
        if (inputStream == null) {
            return null;
        }
        try {
            int count;
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((count = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, count);
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inputStream.close();
        return byArray;
    }

    public static byte[] getBytecode(Class target) {
        if (target.isPrimitive() || target.isArray()) {
            return null;
        }
        String targetName = target.getName();
        int index = targetName.lastIndexOf(46);
        String simpleName = index < 0 ? targetName : targetName.substring(index + 1);
        return RuntimeTools.readResourceToByteArray(target, simpleName + CLASS_EXTENSION);
    }

    public static UndeclaredThrowableException unwrap(InvocationTargetException exception) {
        try {
            throw exception.getTargetException();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            return new UndeclaredThrowableException(e);
        }
    }

    public static Object invokeMethod(final Object target, final String name, final Class[] parameterTypes, final Object[] args) throws NoSuchMethodException, InvocationTargetException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return RuntimeTools.invoke(target, name, parameterTypes, args);
                }
            });
        }
        catch (PrivilegedActionException exception) {
            try {
                throw exception.getException();
            }
            catch (NoSuchMethodException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    private static Object invoke(Object target, String name, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, InvocationTargetException {
        Method method;
        try {
            method = _Class.getMethod(target.getClass(), name, parameterTypes);
        }
        catch (SecurityException e) {
            throw new NoSuchMethodException(e.getMessage());
        }
        try {
            method.setAccessible(true);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchMethodException(e.getMessage());
        }
    }

    public static String getDisplayClassName(String internalName) {
        return internalName.replace('/', '.');
    }

    public static String getFieldInfo(String className, String fieldName) {
        return className + '.' + fieldName;
    }

    public static String getMethodInfo(String className, String methodName, String methodDesc) {
        StringBuffer builder = new StringBuffer(className).append('.').append(methodName);
        builder.append('(');
        Type[] arr$ = Type.getArgumentTypes(methodDesc);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Type type = arr$[i$];
            builder.append(type.getClassName()).append(',');
        }
        builder.setCharAt(builder.length() - 1, ')');
        return builder.toString();
    }

    public static Object[] getTypes(Class[] rawTypes, Object[] genericTypes) {
        if (genericTypes == null || genericTypes.length != rawTypes.length) {
            return rawTypes;
        }
        for (int i = 0; i < rawTypes.length; ++i) {
            if (RuntimeTools.isCorrect(rawTypes[i], genericTypes[i])) continue;
            return rawTypes;
        }
        return genericTypes;
    }

    public static Object getType(Class rawType, Object genericType) {
        return RuntimeTools.isCorrect(rawType, genericType) ? genericType : rawType;
    }

    private static boolean isCorrect(Class rawType, Object genericType) {
        if (genericType instanceof Class) {
            return rawType == genericType;
        }
        if (genericType instanceof ParameterizedType_) {
            return ((ParameterizedType_)genericType).getRawType() == rawType;
        }
        return genericType != null;
    }

    public static String getPrefix(String name, Class type) {
        return type.getName().endsWith(name) ? type.getName().substring(0, type.getName().length() - name.length()) : null;
    }

    static {
        Class<?> clazz = class$edu$emory$mathcs$backport$java$util$concurrent$ConcurrentMap;
        if (clazz == null) {
            clazz = class$edu$emory$mathcs$backport$java$util$concurrent$ConcurrentMap = new ConcurrentMap[0].getClass().getComponentType();
        }
        CONCURRENT_PREFIX = RuntimeTools.getPrefix("java.util.concurrent.ConcurrentMap", clazz);
    }
}

