/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ParameterUsageMarker;

public class BootstrapMethodArgumentShrinker
extends SimplifiedVisitor
implements BootstrapMethodInfoVisitor,
ConstantVisitor,
MemberVisitor {
    private long usedParameters;

    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        this.usedParameters = -1L;
        clazz.constantPoolEntryAccept(bootstrapMethodInfo.u2methodHandleIndex, this);
        int methodArgumentCount = bootstrapMethodInfo.u2methodArgumentCount;
        int[] methodArguments = bootstrapMethodInfo.u2methodArguments;
        int newArgumentIndex = 0;
        for (int argumentIndex = 0; argumentIndex < methodArgumentCount; ++argumentIndex) {
            if (argumentIndex < 64 && (this.usedParameters & 1L << argumentIndex) == 0L) continue;
            methodArguments[newArgumentIndex++] = methodArguments[argumentIndex];
        }
        bootstrapMethodInfo.u2methodArgumentCount = newArgumentIndex;
    }

    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        clazz.constantPoolEntryAccept(methodHandleConstant.u2referenceIndex, this);
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        refConstant.referencedMemberAccept(this);
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.usedParameters = ParameterUsageMarker.getUsedParameters(programMethod);
    }
}

