/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.obfuscate.MappingProcessor;

public class MultiMappingProcessor
implements MappingProcessor {
    private final MappingProcessor[] mappingProcessors;

    public MultiMappingProcessor(MappingProcessor[] mappingProcessors) {
        this.mappingProcessors = mappingProcessors;
    }

    public boolean processClassMapping(String className, String newClassName) {
        boolean result = false;
        for (int index = 0; index < this.mappingProcessors.length; ++index) {
            result |= this.mappingProcessors[index].processClassMapping(className, newClassName);
        }
        return result;
    }

    public void processFieldMapping(String className, String fieldType, String fieldName, String newClassName, String newFieldName) {
        for (int index = 0; index < this.mappingProcessors.length; ++index) {
            this.mappingProcessors[index].processFieldMapping(className, fieldType, fieldName, newClassName, newFieldName);
        }
    }

    public void processMethodMapping(String className, int firstLineNumber, int lastLineNumber, String methodReturnType, String methodName, String methodArguments, String newClassName, int newFirstLineNumber, int newLastLineNumber, String newMethodName) {
        for (int index = 0; index < this.mappingProcessors.length; ++index) {
            this.mappingProcessors[index].processMethodMapping(className, firstLineNumber, lastLineNumber, methodReturnType, methodName, methodArguments, newClassName, newFirstLineNumber, newLastLineNumber, newMethodName);
        }
    }
}

