/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import proguard.io.DataEntry;

public class FileDataEntry
implements DataEntry {
    private final File directory;
    private final File file;
    private InputStream inputStream;

    public FileDataEntry(File directory, File file) {
        this.directory = directory;
        this.file = file;
    }

    public File getFile() {
        return this.file.equals(this.directory) ? this.file : new File(this.directory, this.getRelativeFilePath());
    }

    public String getName() {
        return this.file.equals(this.directory) ? this.file.getName() : this.getRelativeFilePath();
    }

    private String getRelativeFilePath() {
        return this.file.equals(this.directory) ? "" : this.file.getPath().substring(this.directory.getPath().length() + File.separator.length()).replace(File.separatorChar, '/');
    }

    public String getOriginalName() {
        return this.getName();
    }

    public long getSize() {
        return this.file.length();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new BufferedInputStream(new FileInputStream(this.file));
        }
        return this.inputStream;
    }

    public void closeInputStream() throws IOException {
        this.inputStream.close();
        this.inputStream = null;
    }

    public DataEntry getParent() {
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

