/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.ArrayUtil;

public class MultiMemberVisitor
implements MemberVisitor {
    private MemberVisitor[] memberVisitors;
    private int memberVisitorCount;

    public MultiMemberVisitor() {
        this.memberVisitors = new MemberVisitor[16];
    }

    public MultiMemberVisitor(MemberVisitor ... memberVisitors) {
        this.memberVisitors = memberVisitors;
        this.memberVisitorCount = memberVisitors.length;
    }

    public void addMemberVisitor(MemberVisitor memberVisitor) {
        this.memberVisitors = ArrayUtil.add(this.memberVisitors, this.memberVisitorCount++, memberVisitor);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        for (int index = 0; index < this.memberVisitorCount; ++index) {
            this.memberVisitors[index].visitProgramField(programClass, programField);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        for (int index = 0; index < this.memberVisitorCount; ++index) {
            this.memberVisitors[index].visitProgramMethod(programClass, programMethod);
        }
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        for (int index = 0; index < this.memberVisitorCount; ++index) {
            this.memberVisitors[index].visitLibraryField(libraryClass, libraryField);
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        for (int index = 0; index < this.memberVisitorCount; ++index) {
            this.memberVisitors[index].visitLibraryMethod(libraryClass, libraryMethod);
        }
    }
}

