/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;

public class LineNumberRangeFinder
implements LineNumberInfoVisitor {
    private int lowestLineNumber = Integer.MAX_VALUE;
    private int highestLineNumber = 0;
    private boolean hasSource;

    public int getLowestLineNumber() {
        return this.lowestLineNumber;
    }

    public int getHighestLineNumber() {
        return this.highestLineNumber;
    }

    public boolean hasSource() {
        return this.hasSource;
    }

    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        int lineNumber = lineNumberInfo.u2lineNumber;
        if (this.lowestLineNumber > lineNumber) {
            this.lowestLineNumber = lineNumber;
        }
        if (this.highestLineNumber < lineNumber) {
            this.highestLineNumber = lineNumber;
        }
        if (lineNumberInfo.getSource() != null) {
            this.hasSource = true;
        }
    }
}

