/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import proguard.ClassMemberChecker;
import proguard.Configuration;
import proguard.DescriptorKeepChecker;
import proguard.FullyQualifiedClassNameChecker;
import proguard.GetAnnotationChecker;
import proguard.GetEnclosingClassChecker;
import proguard.GetEnclosingMethodChecker;
import proguard.GetSignatureChecker;
import proguard.KeepClassSpecification;
import proguard.LibraryKeepChecker;
import proguard.MemberSpecification;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.annotation.visitor.AllElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.DynamicClassReferenceInitializer;
import proguard.classfile.util.DynamicMemberReferenceInitializer;
import proguard.classfile.util.EnumFieldReferenceInitializer;
import proguard.classfile.util.StringReferenceInitializer;
import proguard.classfile.util.StringSharer;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.LibraryClassFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.EmptyStringMatcher;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.StringMatcher;

public class Initializer {
    private final Configuration configuration;

    public Initializer(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool, ClassPool libraryClassPool) throws IOException {
        int libraryMemberReferenceWarningCount;
        int programMemberReferenceWarningCount;
        int dependencyWarningCount;
        int classReferenceWarningCount;
        int getmemberNoteCount;
        int classForNameNoteCount;
        int dynamicClassReferenceNoteCount;
        int libraryNoteCount;
        int descriptorNoteCount;
        int getEnclosingMethodNoteCount;
        int getEnclosingClassNoteCount;
        int getSignatureNoteCount;
        int getAnnotationNoteCount;
        int classMemberNoteCount;
        int originalLibraryClassPoolSize = libraryClassPool.size();
        WarningPrinter fullyQualifiedClassNameNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        FullyQualifiedClassNameChecker fullyQualifiedClassNameChecker = new FullyQualifiedClassNameChecker(programClassPool, libraryClassPool, fullyQualifiedClassNameNotePrinter);
        fullyQualifiedClassNameChecker.checkClassSpecifications(this.configuration.keep);
        fullyQualifiedClassNameChecker.checkClassSpecifications(this.configuration.assumeNoSideEffects);
        EmptyStringMatcher keepAttributesMatcher = this.configuration.keepAttributes != null ? new ListParser(new NameParser()).parse(this.configuration.keepAttributes) : new EmptyStringMatcher();
        WarningPrinter getAnnotationNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        if (!keepAttributesMatcher.matches("RuntimeVisibleAnnotations")) {
            programClassPool.classesAccept(new AllConstantVisitor(new GetAnnotationChecker(getAnnotationNotePrinter)));
        }
        WarningPrinter getSignatureNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        if (!keepAttributesMatcher.matches("Signature")) {
            programClassPool.classesAccept(new AllConstantVisitor(new GetSignatureChecker(getSignatureNotePrinter)));
        }
        WarningPrinter getEnclosingClassNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        if (!keepAttributesMatcher.matches("InnerClasses")) {
            programClassPool.classesAccept(new AllConstantVisitor(new GetEnclosingClassChecker(getEnclosingClassNotePrinter)));
        }
        WarningPrinter getEnclosingMethodNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        if (!keepAttributesMatcher.matches("EnclosingMethod")) {
            programClassPool.classesAccept(new AllConstantVisitor(new GetEnclosingMethodChecker(getEnclosingMethodNotePrinter)));
        }
        ClassPool reducedLibraryClassPool = this.configuration.useUniqueClassMemberNames ? null : new ClassPool();
        WarningPrinter classReferenceWarningPrinter = new WarningPrinter(System.err, this.configuration.warn);
        WarningPrinter dependencyWarningPrinter = new WarningPrinter(System.err, this.configuration.warn);
        programClassPool.classesAccept(new ClassSuperHierarchyInitializer(programClassPool, libraryClassPool, classReferenceWarningPrinter, null));
        libraryClassPool.classesAccept(new ClassSuperHierarchyInitializer(programClassPool, libraryClassPool, null, dependencyWarningPrinter));
        WarningPrinter programMemberReferenceWarningPrinter = new WarningPrinter(System.err, this.configuration.warn);
        WarningPrinter libraryMemberReferenceWarningPrinter = new WarningPrinter(System.err, this.configuration.warn);
        programClassPool.classesAccept(new ClassReferenceInitializer(programClassPool, libraryClassPool, classReferenceWarningPrinter, programMemberReferenceWarningPrinter, libraryMemberReferenceWarningPrinter, null));
        if (reducedLibraryClassPool != null) {
            programClassPool.classesAccept(new ReferencedClassVisitor(new LibraryClassFilter(new ClassPoolFiller(reducedLibraryClassPool))));
            reducedLibraryClassPool.classesAccept(new ClassSuperHierarchyInitializer(programClassPool, libraryClassPool, classReferenceWarningPrinter, null));
        }
        programClassPool.classesAccept(new AllAttributeVisitor(true, new AllElementValueVisitor(true, new EnumFieldReferenceInitializer())));
        WarningPrinter dynamicClassReferenceNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        WarningPrinter classForNameNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DynamicClassReferenceInitializer(programClassPool, libraryClassPool, dynamicClassReferenceNotePrinter, null, classForNameNotePrinter, this.createClassNoteExceptionMatcher(this.configuration.keep))))));
        WarningPrinter getMemberNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DynamicMemberReferenceInitializer(programClassPool, libraryClassPool, getMemberNotePrinter, this.createClassMemberNoteExceptionMatcher(this.configuration.keep, true), this.createClassMemberNoteExceptionMatcher(this.configuration.keep, false))))));
        if (this.configuration.adaptClassStrings != null) {
            programClassPool.classesAccept(new ClassNameFilter(this.configuration.adaptClassStrings, (ClassVisitor)new AllConstantVisitor(new StringReferenceInitializer(programClassPool, libraryClassPool))));
        }
        if (reducedLibraryClassPool != null) {
            programClassPool.classesAccept(new ReferencedClassVisitor(new LibraryClassFilter(new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(reducedLibraryClassPool))))));
            reducedLibraryClassPool.classesAccept(new ClassReferenceInitializer(programClassPool, libraryClassPool, null, null, null, dependencyWarningPrinter));
            libraryClassPool.clear();
            reducedLibraryClassPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(libraryClassPool))), new ReferencedClassVisitor(new LibraryClassFilter(new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(libraryClassPool)))))}));
        } else {
            libraryClassPool.classesAccept(new ClassReferenceInitializer(programClassPool, libraryClassPool, null, null, null, dependencyWarningPrinter));
        }
        programClassPool.classesAccept(new ClassSubHierarchyInitializer());
        libraryClassPool.classesAccept(new ClassSubHierarchyInitializer());
        programClassPool.classesAccept(new StringSharer());
        libraryClassPool.classesAccept(new StringSharer());
        WarningPrinter classMemberNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        ClassMemberChecker classMemberChecker = new ClassMemberChecker(programClassPool, classMemberNotePrinter);
        classMemberChecker.checkClassSpecifications(this.configuration.keep);
        classMemberChecker.checkClassSpecifications(this.configuration.assumeNoSideEffects);
        WarningPrinter descriptorKeepNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        new DescriptorKeepChecker(programClassPool, libraryClassPool, descriptorKeepNotePrinter).checkClassSpecifications(this.configuration.keep);
        WarningPrinter libraryKeepNotePrinter = new WarningPrinter(System.out, this.configuration.note);
        new LibraryKeepChecker(programClassPool, libraryClassPool, libraryKeepNotePrinter).checkClassSpecifications(this.configuration.keep);
        int fullyQualifiedNoteCount = fullyQualifiedClassNameNotePrinter.getWarningCount();
        if (fullyQualifiedNoteCount > 0) {
            System.out.println("Note: there were " + fullyQualifiedNoteCount + " references to unknown classes.");
            System.out.println("      You should check your configuration for typos.");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#unknownclass)");
        }
        if ((classMemberNoteCount = classMemberNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + classMemberNoteCount + " references to unknown class members.");
            System.out.println("      You should check your configuration for typos.");
        }
        if ((getAnnotationNoteCount = getAnnotationNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + getAnnotationNoteCount + " classes trying to access annotations using reflection.");
            System.out.println("      You should consider keeping the annotation attributes");
            System.out.println("      (using '-keepattributes *Annotation*').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#attributes)");
        }
        if ((getSignatureNoteCount = getSignatureNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + getSignatureNoteCount + " classes trying to access generic signatures using reflection.");
            System.out.println("      You should consider keeping the signature attributes");
            System.out.println("      (using '-keepattributes Signature').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#attributes)");
        }
        if ((getEnclosingClassNoteCount = getEnclosingClassNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + getEnclosingClassNoteCount + " classes trying to access enclosing classes using reflection.");
            System.out.println("      You should consider keeping the inner classes attributes");
            System.out.println("      (using '-keepattributes InnerClasses').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#attributes)");
        }
        if ((getEnclosingMethodNoteCount = getEnclosingMethodNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + getEnclosingMethodNoteCount + " classes trying to access enclosing methods using reflection.");
            System.out.println("      You should consider keeping the enclosing method attributes");
            System.out.println("      (using '-keepattributes InnerClasses,EnclosingMethod').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#attributes)");
        }
        if ((descriptorNoteCount = descriptorKeepNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + descriptorNoteCount + " unkept descriptor classes in kept class members.");
            System.out.println("      You should consider explicitly keeping the mentioned classes");
            System.out.println("      (using '-keep').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#descriptorclass)");
        }
        if ((libraryNoteCount = libraryKeepNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + libraryNoteCount + " library classes explicitly being kept.");
            System.out.println("      You don't need to keep library classes; they are already left unchanged.");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#libraryclass)");
        }
        if ((dynamicClassReferenceNoteCount = dynamicClassReferenceNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + dynamicClassReferenceNoteCount + " unresolved dynamic references to classes or interfaces.");
            System.out.println("      You should check if you need to specify additional program jars.");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#dynamicalclass)");
        }
        if ((classForNameNoteCount = classForNameNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + classForNameNoteCount + " class casts of dynamically created class instances.");
            System.out.println("      You might consider explicitly keeping the mentioned classes and/or");
            System.out.println("      their implementations (using '-keep').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#dynamicalclasscast)");
        }
        if ((getmemberNoteCount = getMemberNotePrinter.getWarningCount()) > 0) {
            System.out.println("Note: there were " + getmemberNoteCount + " accesses to class members by means of introspection.");
            System.out.println("      You should consider explicitly keeping the mentioned class members");
            System.out.println("      (using '-keep' or '-keepclassmembers').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#dynamicalclassmember)");
        }
        if ((classReferenceWarningCount = classReferenceWarningPrinter.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + classReferenceWarningCount + " unresolved references to classes or interfaces.");
            System.err.println("         You may need to add missing library jars or update their versions.");
            System.err.println("         If your code works fine without the missing classes, you can suppress");
            System.err.println("         the warnings with '-dontwarn' options.");
            if (this.configuration.skipNonPublicLibraryClasses) {
                System.err.println("         You may also have to remove the option '-skipnonpubliclibraryclasses'.");
            }
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#unresolvedclass)");
        }
        if ((dependencyWarningCount = dependencyWarningPrinter.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + dependencyWarningCount + " instances of library classes depending on program classes.");
            System.err.println("         You must avoid such dependencies, since the program classes will");
            System.err.println("         be processed, while the library classes will remain unchanged.");
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#dependency)");
        }
        if ((programMemberReferenceWarningCount = programMemberReferenceWarningPrinter.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + programMemberReferenceWarningCount + " unresolved references to program class members.");
            System.err.println("         Your input classes appear to be inconsistent.");
            System.err.println("         You may need to recompile the code.");
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#unresolvedprogramclassmember)");
        }
        if ((libraryMemberReferenceWarningCount = libraryMemberReferenceWarningPrinter.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + libraryMemberReferenceWarningCount + " unresolved references to library class members.");
            System.err.println("         You probably need to update the library versions.");
            if (!this.configuration.skipNonPublicLibraryClassMembers) {
                System.err.println("         Alternatively, you may have to specify the option ");
                System.err.println("         '-dontskipnonpubliclibraryclassmembers'.");
            }
            if (this.configuration.skipNonPublicLibraryClasses) {
                System.err.println("         You may also have to remove the option '-skipnonpubliclibraryclasses'.");
            }
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#unresolvedlibraryclassmember)");
        }
        if (!(classReferenceWarningCount <= 0 && dependencyWarningCount <= 0 && programMemberReferenceWarningCount <= 0 && libraryMemberReferenceWarningCount <= 0 || this.configuration.ignoreWarnings)) {
            throw new IOException("Please correct the above warnings first.");
        }
        if ((this.configuration.note == null || !this.configuration.note.isEmpty()) && (this.configuration.warn != null && this.configuration.warn.isEmpty() || this.configuration.ignoreWarnings)) {
            System.out.println("Note: you're ignoring all warnings!");
        }
        if (this.configuration.verbose) {
            System.out.println("Ignoring unused library classes...");
            System.out.println("  Original number of library classes: " + originalLibraryClassPoolSize);
            System.out.println("  Final number of library classes:    " + libraryClassPool.size());
        }
    }

    private StringMatcher createClassNoteExceptionMatcher(List noteExceptions) {
        if (noteExceptions != null) {
            ArrayList<String> noteExceptionNames = new ArrayList<String>(noteExceptions.size());
            for (int index = 0; index < noteExceptions.size(); ++index) {
                String extendsClassName;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)noteExceptions.get(index);
                if (!keepClassSpecification.markClasses) continue;
                String className = keepClassSpecification.className;
                if (className != null) {
                    noteExceptionNames.add(className);
                }
                if ((extendsClassName = keepClassSpecification.extendsClassName) == null) continue;
                noteExceptionNames.add(extendsClassName);
            }
            if (noteExceptionNames.size() > 0) {
                return new ListParser(new ClassNameParser()).parse(noteExceptionNames);
            }
        }
        return null;
    }

    private StringMatcher createClassMemberNoteExceptionMatcher(List noteExceptions, boolean isField) {
        if (noteExceptions != null) {
            ArrayList<String> noteExceptionNames = new ArrayList<String>();
            for (int index = 0; index < noteExceptions.size(); ++index) {
                List memberSpecifications;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)noteExceptions.get(index);
                List list = memberSpecifications = isField ? keepClassSpecification.fieldSpecifications : keepClassSpecification.methodSpecifications;
                if (memberSpecifications == null) continue;
                for (int index2 = 0; index2 < memberSpecifications.size(); ++index2) {
                    MemberSpecification memberSpecification = (MemberSpecification)memberSpecifications.get(index2);
                    String memberName = memberSpecification.name;
                    if (memberName == null) continue;
                    noteExceptionNames.add(memberName);
                }
            }
            if (noteExceptionNames.size() > 0) {
                return new ListParser(new ClassNameParser()).parse(noteExceptionNames);
            }
        }
        return null;
    }
}

