/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import proguard.io.DataEntry;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryParentFilter;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryPump;
import proguard.io.DirectoryWriter;
import proguard.io.FilteredDataEntryReader;
import proguard.io.FilteredDataEntryWriter;
import proguard.io.JarReader;
import proguard.io.JarWriter;
import proguard.util.ExtensionMatcher;

public class DataEntryCopier
implements DataEntryReader {
    private static final int BUFFER_SIZE = 1024;
    private final DataEntryWriter dataEntryWriter;
    private final byte[] buffer = new byte[1024];

    public DataEntryCopier(DataEntryWriter dataEntryWriter) {
        this.dataEntryWriter = dataEntryWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DataEntry dataEntry) throws IOException {
        block7: {
            try {
                if (dataEntry.isDirectory()) {
                    this.dataEntryWriter.createDirectory(dataEntry);
                    break block7;
                }
                OutputStream outputStream = this.dataEntryWriter.getOutputStream(dataEntry);
                if (outputStream == null) break block7;
                InputStream inputStream = dataEntry.getInputStream();
                try {
                    this.copyData(inputStream, outputStream);
                }
                finally {
                    dataEntry.closeInputStream();
                }
            }
            catch (IOException ex) {
                System.err.println("Warning: can't write resource [" + dataEntry.getName() + "] (" + ex.getMessage() + ")");
            }
            catch (Exception ex) {
                throw (IOException)new IOException("Can't write resource [" + dataEntry.getName() + "] (" + ex.getMessage() + ")").initCause(ex);
            }
        }
    }

    protected void copyData(InputStream inputStream, OutputStream outputStream) throws IOException {
        int count;
        while ((count = inputStream.read(this.buffer)) >= 0) {
            outputStream.write(this.buffer, 0, count);
        }
        outputStream.flush();
    }

    public static void main(String[] args) {
        try {
            String input = args[0];
            String output = args[1];
            boolean outputIsJar = output.endsWith(".jar");
            boolean outputIsWar = output.endsWith(".war");
            boolean outputIsEar = output.endsWith(".ear");
            boolean outputIsZip = output.endsWith(".zip");
            DataEntryWriter writer = new DirectoryWriter(new File(output), outputIsJar || outputIsWar || outputIsEar || outputIsZip);
            if (!outputIsJar) {
                JarWriter zipWriter = new JarWriter(writer);
                writer = outputIsZip ? zipWriter : new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(".zip"))), zipWriter, writer);
                JarWriter warWriter = new JarWriter(writer);
                writer = outputIsWar ? warWriter : new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(".war"))), warWriter, writer);
            }
            JarWriter jarWriter = new JarWriter(writer);
            writer = outputIsJar ? jarWriter : new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(".jar"))), jarWriter, writer);
            DataEntryReader reader = new DataEntryCopier(writer);
            boolean inputIsJar = input.endsWith(".jar");
            boolean inputIsWar = input.endsWith(".war");
            boolean inputIsZip = input.endsWith(".zip");
            JarReader jarReader = new JarReader(reader);
            if (inputIsJar) {
                reader = jarReader;
            } else {
                reader = new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(".jar")), jarReader, reader);
                JarReader warReader = new JarReader(reader);
                reader = inputIsWar ? warReader : new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(".war")), warReader, reader);
                JarReader zipReader = new JarReader(reader);
                reader = inputIsZip ? zipReader : new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(".zip")), zipReader, reader);
            }
            DirectoryPump directoryReader = new DirectoryPump(new File(input));
            directoryReader.pumpDataEntries(reader);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

