/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import proguard.classfile.ClassPool;
import proguard.classfile.ProgramClass;
import proguard.classfile.io.ProgramClassWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryWriter;
import proguard.io.RenamedDataEntry;

public class ClassRewriter
implements DataEntryReader {
    private final ClassPool classPool;
    private final DataEntryWriter dataEntryWriter;

    public ClassRewriter(ClassPool classPool, DataEntryWriter dataEntryWriter) {
        this.classPool = classPool;
        this.dataEntryWriter = dataEntryWriter;
    }

    public void read(DataEntry dataEntry) throws IOException {
        String inputName = dataEntry.getName();
        String className = inputName.substring(0, inputName.length() - ".class".length());
        ProgramClass programClass = (ProgramClass)this.classPool.getClass(className);
        if (programClass != null) {
            OutputStream outputStream;
            String newClassName = programClass.getName();
            if (!className.equals(newClassName)) {
                dataEntry = new RenamedDataEntry(dataEntry, newClassName + ".class");
            }
            if ((outputStream = this.dataEntryWriter.getOutputStream(dataEntry)) != null) {
                DataOutputStream classOutputStream = new DataOutputStream(outputStream);
                new ProgramClassWriter(classOutputStream).visitProgramClass(programClass);
                classOutputStream.flush();
            }
        }
    }
}

