/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.Category1Value;
import proguard.evaluation.value.Value;

public class InstructionOffsetValue
extends Category1Value {
    public static final InstructionOffsetValue EMPTY_VALUE = new InstructionOffsetValue();
    private int[] values;

    private InstructionOffsetValue() {
    }

    public InstructionOffsetValue(int value) {
        this.values = new int[]{value};
    }

    public InstructionOffsetValue(int[] values) {
        this.values = values;
    }

    public int instructionOffsetCount() {
        return this.values == null ? 0 : this.values.length;
    }

    public int instructionOffset(int index) {
        return this.values[index];
    }

    public boolean contains(int value) {
        if (this.values != null) {
            for (int index = 0; index < this.values.length; ++index) {
                if (this.values[index] != value) continue;
                return true;
            }
        }
        return false;
    }

    public int minimumValue() {
        int minimumValue = Integer.MAX_VALUE;
        if (this.values != null) {
            for (int index = 0; index < this.values.length; ++index) {
                int value = this.values[index];
                if (minimumValue <= value) continue;
                minimumValue = value;
            }
        }
        return minimumValue;
    }

    public int maximumValue() {
        int maximumValue = Integer.MIN_VALUE;
        if (this.values != null) {
            for (int index = 0; index < this.values.length; ++index) {
                int value = this.values[index];
                if (maximumValue >= value) continue;
                maximumValue = value;
            }
        }
        return maximumValue;
    }

    public final Value generalize(InstructionOffsetValue other) {
        int index;
        if (this.values == null) {
            return other;
        }
        if (other.values == null) {
            return this;
        }
        int newLength = this.values.length;
        for (int index2 = 0; index2 < other.values.length; ++index2) {
            if (this.contains(other.values[index2])) continue;
            ++newLength;
        }
        if (newLength == other.values.length) {
            return other;
        }
        int[] newValues = new int[newLength];
        int newIndex = 0;
        for (index = 0; index < this.values.length; ++index) {
            if (other.contains(this.values[index])) continue;
            newValues[newIndex++] = this.values[index];
        }
        for (index = 0; index < other.values.length; ++index) {
            newValues[newIndex++] = other.values[index];
        }
        return new InstructionOffsetValue(newValues);
    }

    public final InstructionOffsetValue instructionOffsetValue() {
        return this;
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean isParticular() {
        return true;
    }

    public final Value generalize(Value other) {
        return this.generalize(other.instructionOffsetValue());
    }

    public final int computationalType() {
        return 6;
    }

    public final String internalType() {
        return String.valueOf('I');
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        InstructionOffsetValue other = (InstructionOffsetValue)object;
        if (this.values == other.values) {
            return true;
        }
        if (this.values == null || other.values == null || this.values.length != other.values.length) {
            return false;
        }
        for (int index = 0; index < other.values.length; ++index) {
            if (this.contains(other.values[index])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.getClass().hashCode();
        if (this.values != null) {
            for (int index = 0; index < this.values.length; ++index) {
                hashCode ^= this.values[index];
            }
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.values != null) {
            for (int index = 0; index < this.values.length; ++index) {
                if (index > 0) {
                    buffer.append(',');
                }
                buffer.append(this.values[index]);
            }
        }
        return buffer.append(':').toString();
    }
}

