/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ProgramClass;

public class InterfacesEditor {
    private final ProgramClass targetClass;

    public InterfacesEditor(ProgramClass targetClass) {
        this.targetClass = targetClass;
    }

    public void addInterface(int interfaceConstantIndex) {
        if (this.findInterfaceIndex(interfaceConstantIndex) < 0) {
            int interfacesCount;
            int[] interfaces = this.targetClass.u2interfaces;
            if (interfaces.length <= (interfacesCount = this.targetClass.u2interfacesCount++)) {
                int[] newinterfaces = new int[interfacesCount + 1];
                System.arraycopy(interfaces, 0, newinterfaces, 0, interfacesCount);
                this.targetClass.u2interfaces = interfaces = newinterfaces;
            }
            interfaces[interfacesCount] = interfaceConstantIndex;
        }
    }

    public void deleteInterface(int interfaceConstantIndex) {
        int interfaceIndex = this.findInterfaceIndex(interfaceConstantIndex);
        if (interfaceIndex >= 0) {
            int interfacesCount = --this.targetClass.u2interfacesCount;
            int[] interfaces = this.targetClass.u2interfaces;
            for (int index = interfaceIndex; index < interfacesCount; ++index) {
                interfaces[index] = interfaces[index + 1];
            }
            interfaces[interfacesCount] = 0;
        }
    }

    private int findInterfaceIndex(int interfaceConstantIndex) {
        int interfacesCount = this.targetClass.u2interfacesCount;
        int[] interfaces = this.targetClass.u2interfaces;
        for (int index = 0; index < interfacesCount; ++index) {
            if (interfaces[index] != interfaceConstantIndex) continue;
            return index;
        }
        return -1;
    }
}

