/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.editor.InstructionWriter;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.editor.VariableSizeUpdater;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.util.ArrayUtil;

public class CodeAttributeComposer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
LineNumberInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private static final boolean DEBUG = false;
    private static final int MAXIMUM_LEVELS = 32;
    private static final int INVALID = -1;
    private final boolean allowExternalExceptionHandlers;
    private final boolean shrinkInstructions;
    private int maximumCodeLength;
    private int codeLength;
    private int exceptionTableLength;
    private int level = -1;
    private byte[] code = new byte[1024];
    private int[] oldInstructionOffsets = new int[1024];
    private final int[] codeFragmentOffsets = new int[32];
    private final int[] codeFragmentLengths = new int[32];
    private final int[][] instructionOffsetMap = new int[32][1025];
    private ExceptionInfo[] exceptionTable = new ExceptionInfo[16];
    private int expectedStackMapFrameOffset;
    private final StackSizeUpdater stackSizeUpdater = new StackSizeUpdater();
    private final VariableSizeUpdater variableSizeUpdater = new VariableSizeUpdater();
    private final InstructionWriter instructionWriter = new InstructionWriter();

    public CodeAttributeComposer() {
        this(false, true);
    }

    public CodeAttributeComposer(boolean allowExternalExceptionHandlers, boolean shrinkInstructions) {
        this.allowExternalExceptionHandlers = allowExternalExceptionHandlers;
        this.shrinkInstructions = shrinkInstructions;
    }

    public void reset() {
        this.maximumCodeLength = 0;
        this.codeLength = 0;
        this.exceptionTableLength = 0;
        this.level = -1;
        this.instructionWriter.reset(1024);
    }

    public void beginCodeFragment(int maximumCodeFragmentLength) {
        ++this.level;
        if (this.level >= 32) {
            throw new IllegalArgumentException("Maximum number of code fragment levels exceeded [" + this.level + "]");
        }
        this.maximumCodeLength += maximumCodeFragmentLength;
        this.ensureCodeLength(this.maximumCodeLength);
        if (this.instructionOffsetMap[this.level].length <= maximumCodeFragmentLength) {
            this.instructionOffsetMap[this.level] = new int[maximumCodeFragmentLength + 1];
        }
        for (int index = 0; index <= maximumCodeFragmentLength; ++index) {
            this.instructionOffsetMap[this.level][index] = -1;
        }
        this.codeFragmentOffsets[this.level] = this.codeLength;
        this.codeFragmentLengths[this.level] = maximumCodeFragmentLength;
    }

    public void appendInstruction(int oldInstructionOffset, Instruction instruction) {
        if (this.shrinkInstructions) {
            instruction = instruction.shrink();
        }
        int newCodeLength = this.codeLength + instruction.length(this.codeLength);
        this.ensureCodeLength(newCodeLength);
        this.oldInstructionOffsets[this.codeLength] = oldInstructionOffset;
        this.instructionOffsetMap[this.level][oldInstructionOffset] = this.codeLength;
        instruction.accept(null, null, new CodeAttribute(0, 0, 0, 0, this.code, 0, null, 0, null), this.codeLength, this.instructionWriter);
        this.codeLength = newCodeLength;
    }

    public void appendLabel(int oldInstructionOffset) {
        this.ensureCodeLength(this.codeLength + 1);
        this.oldInstructionOffsets[this.codeLength] = oldInstructionOffset;
        this.instructionOffsetMap[this.level][oldInstructionOffset] = this.codeLength;
    }

    public void appendInstructions(Instruction[] instructions) {
        for (int index = 0; index < instructions.length; ++index) {
            this.appendInstruction(instructions[index]);
        }
    }

    public void appendInstruction(Instruction instruction) {
        if (this.shrinkInstructions) {
            instruction = instruction.shrink();
        }
        int newCodeLength = this.codeLength + instruction.length(this.codeLength);
        this.ensureCodeLength(newCodeLength);
        instruction.accept(null, null, new CodeAttribute(0, 0, 0, 0, this.code, 0, null, 0, null), this.codeLength, this.instructionWriter);
        this.codeLength = newCodeLength;
    }

    public void appendException(ExceptionInfo exceptionInfo) {
        this.visitExceptionInfo(null, null, null, exceptionInfo);
        if (exceptionInfo.u2startPC == exceptionInfo.u2endPC) {
            return;
        }
        this.exceptionTable = (ExceptionInfo[])ArrayUtil.add(this.exceptionTable, this.exceptionTableLength++, exceptionInfo);
    }

    public void endCodeFragment() {
        Instruction instruction;
        if (this.level < 0) {
            throw new IllegalArgumentException("Code fragment not begun [" + this.level + "]");
        }
        for (int instructionOffset = this.codeFragmentOffsets[this.level]; instructionOffset < this.codeLength; instructionOffset += instruction.length(instructionOffset)) {
            instruction = InstructionFactory.create(this.code, instructionOffset);
            if (this.oldInstructionOffsets[instructionOffset] < 0) continue;
            instruction.accept(null, null, null, instructionOffset, this);
            instruction.accept(null, null, new CodeAttribute(0, 0, 0, 0, this.code, 0, null, 0, null), instructionOffset, this.instructionWriter);
            this.oldInstructionOffsets[instructionOffset] = -1;
        }
        this.maximumCodeLength += this.codeLength - this.codeFragmentOffsets[this.level] - this.codeFragmentLengths[this.level];
        if (this.allowExternalExceptionHandlers) {
            for (int index = 0; index < this.exceptionTableLength; ++index) {
                ExceptionInfo exceptionInfo = this.exceptionTable[index];
                int handlerPC = -exceptionInfo.u2handlerPC;
                if (handlerPC <= 0) continue;
                if (this.remappableExceptionHandler(handlerPC)) {
                    exceptionInfo.u2handlerPC = this.newInstructionOffset(handlerPC);
                    continue;
                }
                if (this.level != 0) continue;
                throw new IllegalStateException("Couldn't remap exception handler offset [" + handlerPC + "]");
            }
        }
        --this.level;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.level != -1) {
            throw new IllegalArgumentException("Code fragment not ended [" + this.level + "]");
        }
        ++this.level;
        if (codeAttribute.u4codeLength < this.codeLength) {
            codeAttribute.code = new byte[this.codeLength];
        }
        codeAttribute.u4codeLength = this.codeLength;
        System.arraycopy(this.code, 0, codeAttribute.code, 0, this.codeLength);
        if (codeAttribute.exceptionTable.length < this.exceptionTableLength) {
            codeAttribute.exceptionTable = new ExceptionInfo[this.exceptionTableLength];
        }
        codeAttribute.u2exceptionTableLength = this.exceptionTableLength;
        System.arraycopy(this.exceptionTable, 0, codeAttribute.exceptionTable, 0, this.exceptionTableLength);
        this.stackSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        this.variableSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.attributesAccept(clazz, method, this);
        this.instructionWriter.visitCodeAttribute(clazz, method, codeAttribute);
        --this.level;
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.expectedStackMapFrameOffset = -1;
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.expectedStackMapFrameOffset = 0;
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
        lineNumberTableAttribute.u2lineNumberTableLength = this.removeEmptyLineNumbers(lineNumberTableAttribute.lineNumberTable, lineNumberTableAttribute.u2lineNumberTableLength, codeAttribute.u4codeLength);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTableAttribute.u2localVariableTableLength = this.removeEmptyLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength, codeAttribute.u2maxLocals);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.removeEmptyLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength, codeAttribute.u2maxLocals);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        branchInstruction.branchOffset = this.newBranchOffset(offset, branchInstruction.branchOffset);
    }

    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
        switchInstruction.defaultOffset = this.newBranchOffset(offset, switchInstruction.defaultOffset);
        this.updateJumpOffsets(offset, switchInstruction.jumpOffsets);
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        exceptionInfo.u2startPC = this.newInstructionOffset(exceptionInfo.u2startPC);
        exceptionInfo.u2endPC = this.newInstructionOffset(exceptionInfo.u2endPC);
        int handlerPC = exceptionInfo.u2handlerPC;
        exceptionInfo.u2handlerPC = !this.allowExternalExceptionHandlers || this.remappableExceptionHandler(handlerPC) ? this.newInstructionOffset(handlerPC) : -handlerPC;
    }

    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, StackMapFrame stackMapFrame) {
        int stackMapFrameOffset;
        int offsetDelta = stackMapFrameOffset = this.newInstructionOffset(offset);
        if (this.expectedStackMapFrameOffset >= 0) {
            offsetDelta -= this.expectedStackMapFrameOffset;
            this.expectedStackMapFrameOffset = stackMapFrameOffset + 1;
        }
        stackMapFrame.u2offsetDelta = offsetDelta;
    }

    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SameOneFrame sameOneFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, offset, sameOneFrame);
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, offset, this);
    }

    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, MoreZeroFrame moreZeroFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, offset, moreZeroFrame);
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, offset, this);
    }

    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, FullFrame fullFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, offset, fullFrame);
        fullFrame.variablesAccept(clazz, method, codeAttribute, offset, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, offset, this);
    }

    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VerificationType verificationType) {
    }

    public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, UninitializedType uninitializedType) {
        uninitializedType.u2newInstructionOffset = this.newInstructionOffset(uninitializedType.u2newInstructionOffset);
    }

    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        lineNumberInfo.u2startPC = this.newInstructionOffset(lineNumberInfo.u2startPC);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        int startPC = this.newInstructionOffset(localVariableInfo.u2startPC);
        int endPC = this.newInstructionOffset(localVariableInfo.u2startPC + localVariableInfo.u2length);
        localVariableInfo.u2startPC = startPC;
        localVariableInfo.u2length = endPC - startPC;
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        int startPC = this.newInstructionOffset(localVariableTypeInfo.u2startPC);
        int endPC = this.newInstructionOffset(localVariableTypeInfo.u2startPC + localVariableTypeInfo.u2length);
        localVariableTypeInfo.u2startPC = startPC;
        localVariableTypeInfo.u2length = endPC - startPC;
    }

    private void ensureCodeLength(int newCodeLength) {
        if (this.code.length < newCodeLength) {
            newCodeLength = newCodeLength * 6 / 5;
            this.code = ArrayUtil.extendArray(this.code, newCodeLength);
            this.oldInstructionOffsets = ArrayUtil.extendArray(this.oldInstructionOffsets, newCodeLength);
            this.instructionWriter.extend(newCodeLength);
        }
    }

    private void updateJumpOffsets(int offset, int[] jumpOffsets) {
        for (int index = 0; index < jumpOffsets.length; ++index) {
            jumpOffsets[index] = this.newBranchOffset(offset, jumpOffsets[index]);
        }
    }

    private int newBranchOffset(int newInstructionOffset, int oldBranchOffset) {
        if (newInstructionOffset < 0 || newInstructionOffset > this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + newInstructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        int oldInstructionOffset = this.oldInstructionOffsets[newInstructionOffset];
        return this.newInstructionOffset(oldInstructionOffset + oldBranchOffset) - this.newInstructionOffset(oldInstructionOffset);
    }

    private int newInstructionOffset(int oldInstructionOffset) {
        if (oldInstructionOffset < 0 || oldInstructionOffset > this.codeFragmentLengths[this.level]) {
            throw new IllegalArgumentException("Instruction offset [" + oldInstructionOffset + "] out of range in code fragment with length [" + this.codeFragmentLengths[this.level] + "] at level " + this.level);
        }
        int newInstructionOffset = this.instructionOffsetMap[this.level][oldInstructionOffset];
        if (newInstructionOffset == -1) {
            throw new IllegalArgumentException("Invalid instruction offset [" + oldInstructionOffset + "] in code fragment at level " + this.level);
        }
        return newInstructionOffset;
    }

    private boolean remappableExceptionHandler(int oldInstructionOffset) {
        if (oldInstructionOffset > this.codeFragmentLengths[this.level]) {
            return false;
        }
        int newInstructionOffset = this.instructionOffsetMap[this.level][oldInstructionOffset];
        return newInstructionOffset > -1 && newInstructionOffset < this.codeLength;
    }

    private int removeEmptyExceptions(ExceptionInfo[] exceptionInfos, int exceptionInfoCount) {
        int newIndex = 0;
        for (int index = 0; index < exceptionInfoCount; ++index) {
            ExceptionInfo exceptionInfo = exceptionInfos[index];
            if (exceptionInfo.u2startPC >= exceptionInfo.u2endPC) continue;
            exceptionInfos[newIndex++] = exceptionInfo;
        }
        Arrays.fill(exceptionInfos, newIndex, exceptionInfoCount, null);
        return newIndex;
    }

    private int removeEmptyLineNumbers(LineNumberInfo[] lineNumberInfos, int lineNumberInfoCount, int codeLength) {
        int newIndex = 0;
        for (int index = 0; index < lineNumberInfoCount; ++index) {
            LineNumberInfo lineNumberInfo = lineNumberInfos[index];
            int startPC = lineNumberInfo.u2startPC;
            if (startPC >= codeLength || index != 0 && startPC <= lineNumberInfos[index - 1].u2startPC) continue;
            lineNumberInfos[newIndex++] = lineNumberInfo;
        }
        Arrays.fill(lineNumberInfos, newIndex, lineNumberInfoCount, null);
        return newIndex;
    }

    private int removeEmptyLocalVariables(LocalVariableInfo[] localVariableInfos, int localVariableInfoCount, int maxLocals) {
        int newIndex = 0;
        for (int index = 0; index < localVariableInfoCount; ++index) {
            LocalVariableInfo localVariableInfo = localVariableInfos[index];
            if (localVariableInfo.u2length <= 0 || localVariableInfo.u2index >= maxLocals) continue;
            localVariableInfos[newIndex++] = localVariableInfo;
        }
        Arrays.fill(localVariableInfos, newIndex, localVariableInfoCount, null);
        return newIndex;
    }

    private int removeEmptyLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfos, int localVariableTypeInfoCount, int maxLocals) {
        int newIndex = 0;
        for (int index = 0; index < localVariableTypeInfoCount; ++index) {
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfos[index];
            if (localVariableTypeInfo.u2length <= 0 || localVariableTypeInfo.u2index >= maxLocals) continue;
            localVariableTypeInfos[newIndex++] = localVariableTypeInfo;
        }
        Arrays.fill(localVariableTypeInfos, newIndex, localVariableTypeInfoCount, null);
        return newIndex;
    }

    private void println(String string1, String string2) {
        this.print(string1, string2);
        System.out.println();
    }

    private void print(String string1, String string2) {
        System.out.print(string1);
        for (int index = 0; index < this.level; ++index) {
            System.out.print("  ");
        }
        System.out.print(string2);
    }

    public static void main(String[] args) {
        CodeAttributeComposer composer = new CodeAttributeComposer();
        composer.beginCodeFragment(4);
        composer.appendInstruction(0, new SimpleInstruction(3));
        composer.appendInstruction(1, new VariableInstruction(54, 0));
        composer.appendInstruction(2, new BranchInstruction(-89, 1));
        composer.beginCodeFragment(4);
        composer.appendInstruction(0, new VariableInstruction(-124, 0, 1));
        composer.appendInstruction(1, new VariableInstruction(21, 0));
        composer.appendInstruction(2, new SimpleInstruction(8));
        composer.appendInstruction(3, new BranchInstruction(-95, -3));
        composer.endCodeFragment();
        composer.appendInstruction(3, new SimpleInstruction(-79));
        composer.endCodeFragment();
    }
}

