/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class AnnotationTypeFilter
implements AnnotationVisitor {
    private final StringMatcher regularExpressionMatcher;
    private final AnnotationVisitor annotationVisitor;

    public AnnotationTypeFilter(String regularExpression, AnnotationVisitor annotationVisitor) {
        this.regularExpressionMatcher = new ListParser(new ClassNameParser()).parse(regularExpression);
        this.annotationVisitor = annotationVisitor;
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, annotation);
        }
    }

    public void visitAnnotation(Clazz clazz, Field field, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, field, annotation);
        }
    }

    public void visitAnnotation(Clazz clazz, Method method, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, method, annotation);
        }
    }

    public void visitAnnotation(Clazz clazz, Method method, int parameterIndex, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, method, parameterIndex, annotation);
        }
    }

    private boolean accepted(String name) {
        return this.regularExpressionMatcher.matches(name);
    }
}

