/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.common;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.steps.tokenization.Tokenizer;
import net.sf.okapi.steps.tokenization.Tokens;
import net.sf.okapi.steps.tokenization.TokensAnnotation;
import net.sf.okapi.steps.wordcount.WordCounter;
import net.sf.okapi.steps.wordcount.common.BaseCountStep;
import net.sf.okapi.steps.wordcount.common.GMX;
import net.sf.okapi.steps.wordcount.common.TokenCharacterCountStep;

public abstract class TokenCountStep
extends BaseCountStep {
    protected abstract String[] getTokenNames();

    protected Tokens filterTokens(Tokens allTokens) {
        return allTokens.getFilteredList(this.getTokenNames());
    }

    protected Tokens getTokens(TextContainer textContainer, LocaleId locale) {
        TokensAnnotation ta = textContainer.getAnnotation(TokensAnnotation.class);
        Tokens allTokens = ta != null ? ta.getTokens() : Tokenizer.tokenize(textContainer, locale, new String[0]);
        return this.filterTokens(allTokens);
    }

    @Override
    protected long count(TextContainer textContainer, LocaleId locale) {
        Tokens tokens = this.getTokens(textContainer, locale);
        if (GMX.isLogographicScript(locale)) {
            long characterCount = TokenCharacterCountStep.countTokenChars(tokens, locale);
            return WordCounter.countFromLogographicCharacterCount(characterCount, locale);
        }
        return tokens == null ? 0L : (long)tokens.size();
    }

    protected Tokens getTokens(Segment segment, LocaleId locale) {
        TokensAnnotation ta = segment.getAnnotation(TokensAnnotation.class);
        Tokens allTokens = ta != null ? ta.getTokens() : Tokenizer.tokenize(segment.getContent(), locale, new String[0]);
        return this.filterTokens(allTokens);
    }

    @Override
    protected long count(Segment segment, LocaleId locale) {
        Tokens tokens = this.getTokens(segment, locale);
        if (GMX.isLogographicScript(locale)) {
            long characterCount = TokenCharacterCountStep.countTokenChars(tokens, locale);
            return WordCounter.countFromLogographicCharacterCount(characterCount, locale);
        }
        return tokens == null ? 0L : (long)tokens.size();
    }

    @Override
    protected long countInTextUnit(ITextUnit textUnit) {
        if (textUnit == null) {
            return 0L;
        }
        LocaleId srcLocale = this.getSourceLocale();
        TextContainer source = textUnit.getSource();
        long segCount = 0L;
        long segmentsCount = 0L;
        long textContainerCount = 0L;
        ISegments segs = source.getSegments();
        if (segs != null) {
            for (Segment seg : segs) {
                segCount = this.count(seg, srcLocale);
                segmentsCount += segCount;
                this.saveToMetrics(seg, segCount);
            }
        }
        textContainerCount = this.count(source, srcLocale);
        this.saveToMetrics(source, textContainerCount);
        if (textContainerCount > 0L) {
            return textContainerCount;
        }
        if (segmentsCount > 0L) {
            return segmentsCount;
        }
        return 0L;
    }
}

