/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.codesimplifier;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;
import net.sf.okapi.steps.common.codesimplifier.Parameters;

@UsingParameters(value=Parameters.class)
public class CodeSimplifierStep
extends BasePipelineStep {
    private Parameters params = new Parameters();

    @Override
    public String getDescription() {
        return "Merges adjacent inline codes in the source part of a text unit. Also where possible, moves leading and trailing codes of the source to the skeleton (Only for GenericSkeleton!). Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Inline Codes Simplifier";
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
        if (Util.isEmpty(this.params.getRules())) {
            return;
        }
        SimplifierRules r = new SimplifierRules(this.params.getRules(), new Code());
        try {
            r.parse();
        }
        catch (ParseException e) {
            throw new OkapiBadStepInputException("Simplifier Rules are Invalid", e);
        }
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        TextUnitUtil.simplifyCodes(tu, this.getParameters().getRules(), this.params.getRemoveLeadingTrailingCodes() && tu.getSkeleton() instanceof GenericSkeleton, this.params.getMergeCodes());
        return super.handleTextUnit(event);
    }
}

