/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.writer;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.NSContext;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.changeTracking.ChangeTrack;
import net.sf.okapi.lib.xliff2.changeTracking.Item;
import net.sf.okapi.lib.xliff2.changeTracking.Revision;
import net.sf.okapi.lib.xliff2.changeTracking.Revisions;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.IExtChild;
import net.sf.okapi.lib.xliff2.core.IWithChangeTrack;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithExtElements;
import net.sf.okapi.lib.xliff2.core.IWithMetadata;
import net.sf.okapi.lib.xliff2.core.IWithNotes;
import net.sf.okapi.lib.xliff2.core.IWithValidation;
import net.sf.okapi.lib.xliff2.core.InheritedData;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Notes;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Skeleton;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Store;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.glossary.GlossEntry;
import net.sf.okapi.lib.xliff2.glossary.Translation;
import net.sf.okapi.lib.xliff2.its.AnnotatorsRef;
import net.sf.okapi.lib.xliff2.its.ITSWriter;
import net.sf.okapi.lib.xliff2.matches.Match;
import net.sf.okapi.lib.xliff2.metadata.IMetadataItem;
import net.sf.okapi.lib.xliff2.metadata.Meta;
import net.sf.okapi.lib.xliff2.metadata.MetaGroup;
import net.sf.okapi.lib.xliff2.metadata.Metadata;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.validation.Rule;
import net.sf.okapi.lib.xliff2.validation.Validation;
import net.sf.okapi.lib.xliff2.writer.ExtensionsWriter;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriterException;

public class XLIFFWriter
implements Closeable {
    private PrintWriter writer = null;
    private String lb = System.getProperty("line.separator");
    private boolean useIndentation = false;
    private boolean useInsignificantParts = false;
    private boolean indentNonUnit = this.useIndentation && !this.useInsignificantParts;
    private String indent;
    private String nonUnitLb;
    private boolean inDocument;
    private boolean inFile;
    private StartFileData startFileData;
    private boolean withData = true;
    private String sourceLang;
    private String targetLang;
    private Stack<NSContext> nsStack;
    private Stack<InheritedData> context;
    private Stack<StartGroupData> groupStack;
    private int autoFileId;
    private int autoGroupId;
    private ITSWriter itsWriter;
    private ExtensionsWriter extWriter;

    public void create(File file, String sourceLang, String targetLang) {
        try {
            File dir = file.getParentFile();
            if (dir != null && !dir.exists() && !dir.mkdirs()) {
                throw new XLIFFWriterException("Could not create one or more directories for " + file);
            }
            this.create(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), StandardCharsets.UTF_8), sourceLang, targetLang);
        }
        catch (FileNotFoundException e) {
            throw new XLIFFWriterException(String.format("Cannot create the document (%s).", file), e);
        }
    }

    public void create(File file, String sourceLang) {
        this.create(file, sourceLang, null);
    }

    public void create(Writer output, String sourceLang, String targetLang) {
        this.sourceLang = sourceLang;
        this.targetLang = targetLang;
        this.writer = new PrintWriter(output);
        this.indent = "";
        this.nonUnitLb = this.useInsignificantParts ? "" : this.lb;
        this.inFile = false;
        this.inDocument = false;
        this.autoFileId = 0;
        this.autoGroupId = 0;
        this.itsWriter = new ITSWriter();
        this.nsStack = new Stack();
        this.nsStack.push(new NSContext("", "urn:oasis:names:tc:xliff:document:2.0"));
        this.groupStack = new Stack();
    }

    public void create(Writer output, String sourceLang) {
        this.create(output, sourceLang, null);
    }

    public void setWithOriginalData(boolean withOriginalData) {
        this.withData = withOriginalData;
    }

    public boolean getWithOriginalData() {
        return this.withData;
    }

    public void setLineBreak(String lineBreak) {
        this.lb = lineBreak;
        this.nonUnitLb = this.useInsignificantParts ? "" : this.lb;
    }

    public String getLineBreak() {
        return this.lb;
    }

    public void setUseIndentation(boolean useIndentation) {
        this.useIndentation = useIndentation;
        this.indentNonUnit = useIndentation && !this.useInsignificantParts;
        this.nonUnitLb = this.useInsignificantParts ? "" : this.lb;
    }

    public void setUseInsignificantParts(boolean useInsignificantParts) {
        this.useInsignificantParts = useInsignificantParts;
        this.indentNonUnit = this.useIndentation && !useInsignificantParts;
        this.nonUnitLb = useInsignificantParts ? "" : this.lb;
    }

    @Override
    public void close() {
        if (this.writer != null) {
            if (this.inDocument) {
                this.writeEndDocument();
            }
            this.writer.close();
            this.writer = null;
        }
    }

    public void writeEvent(Event event) {
        switch (event.getType()) {
            case START_XLIFF: {
                StartXliffData dd = event.getStartXliffData();
                this.sourceLang = dd.getSourceLanguage();
                if (dd.getTargetLanguage() == null && this.targetLang != null) {
                    dd.setTargetLanguage(this.targetLang);
                } else {
                    this.targetLang = dd.getTargetLanguage();
                }
                this.writeStartDocument(dd, null);
                break;
            }
            case START_FILE: {
                this.writeStartFile(event.getStartFileData());
                break;
            }
            case SKELETON: {
                this.writeSkeleton(event.getSkeletonData());
                break;
            }
            case MID_FILE: {
                this.writeMidFile(event.getMidFileData());
                break;
            }
            case START_GROUP: {
                this.writeStartGroup(event.getStartGroupData());
                break;
            }
            case TEXT_UNIT: {
                this.writeUnit(event.getUnit());
                break;
            }
            case END_GROUP: {
                this.writeEndGroup();
                break;
            }
            case END_FILE: {
                this.writeEndFile();
                break;
            }
            case END_XLIFF: {
                this.writeEndDocument();
                break;
            }
            case INSIGNIFICANT_PART: {
                if (!this.useInsignificantParts) break;
                this.writeText(event.getInsingnificantPartData().getData());
                break;
            }
        }
    }

    private void writeText(String text) {
        this.writer.print(text.replace("\n", this.lb));
    }

    public void writeUnit(Unit unit) {
        if (unit.getPartCount() == 0) {
            return;
        }
        if (unit.getSegmentCount() == 0) {
            unit.appendSegment();
        }
        if (!this.inFile) {
            this.writeStartFile(null);
        }
        this.context.push(new InheritedData(unit));
        this.nsStack.push(this.nsStack.peek().clone());
        this.writer.print(this.indent + "<unit id=\"" + Util.toXML(unit.getId(), true) + "\"");
        this.writeInheritedAttributes(unit);
        if (unit.getName() != null) {
            this.writer.print(" name=\"" + Util.toXML(unit.getName(), true) + "\"");
        }
        if (unit.getType() != null) {
            this.writer.print(" type=\"" + Util.toXML(unit.getType(), true) + "\"");
        }
        AnnotatorsRef unitAR = this.context.peek().getAnnotatorsRef();
        AnnotatorsRef.update(unitAR, unit);
        AnnotatorsRef parentAR = null;
        if (this.context.size() > 1) {
            parentAR = ((InheritedData)this.context.elementAt(this.context.size() - 2)).getAnnotatorsRef();
        }
        this.writer.print(this.itsWriter.outputAttributes(unit, unitAR, parentAR));
        this.writeExtAttributes(unit);
        this.writer.print(">" + this.lb);
        if (this.useIndentation) {
            this.indent = this.indent + " ";
        }
        this.writer.print(this.itsWriter.outputStandOffElements(this.indent, this.lb, unit));
        this.writeMatches(unit);
        this.writeGlossary(unit);
        this.writeMetadata(unit);
        this.writeValidation(unit);
        this.writeChangeTracking(unit);
        this.writeExtElements(unit);
        this.writeNotes(unit);
        if (this.withData) {
            this.writeOriginalData(unit.getStore());
        }
        for (Part part : unit) {
            Segment seg = null;
            if (part.isSegment()) {
                seg = (Segment)part;
                this.writer.print(this.indent + "<segment");
                if (seg.getId() != null) {
                    this.writer.print(" id=\"" + seg.getId() + "\"");
                }
                if (seg.getCanResegment() != this.context.peek().getCanResegment()) {
                    this.writer.print(" canResegment=\"" + (seg.getCanResegment() ? "yes" : "no") + "\"");
                }
                if (!seg.getState().equals((Object)Segment.STATE_DEFAULT) || seg.getSubState() != null) {
                    this.writer.print(" state=\"" + seg.getState().toString() + "\"");
                }
                if (seg.getSubState() != null) {
                    this.writer.print(" subState=\"" + Util.toXML(seg.getSubState(), true) + "\"");
                }
            } else {
                this.writer.print(this.indent + "<ignorable");
                if (part.getId() != null) {
                    this.writer.print(" id=\"" + part.getId() + "\"");
                }
            }
            this.writer.print(">" + this.lb);
            if (this.useIndentation) {
                this.indent = this.indent + " ";
            }
            this.writeFragment("source", unit, part.getSource(), 0, part.getPreserveWS(), unit.getSourceDir());
            if (part.hasTarget()) {
                this.writeFragment("target", unit, part.getTarget(Part.GetTarget.CREATE_EMPTY), part.getTargetOrder(), part.getPreserveWS(), unit.getTargetDir());
            }
            if (this.useIndentation) {
                this.indent = this.indent.substring(1);
            }
            if (seg != null) {
                this.writer.print(this.indent + "</segment>" + this.lb);
                continue;
            }
            this.writer.print(this.indent + "</ignorable>" + this.lb);
        }
        if (this.useIndentation) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</unit>" + this.lb);
        this.context.pop();
        this.nsStack.pop();
    }

    private void writeChangeTracking(IWithChangeTrack parent) {
        if (parent.hasChangeTrack()) {
            this.writer.print(this.indent + ChangeTrack.getCompleteOpeningTag(true) + this.lb);
            if (this.useIndentation) {
                this.indent = this.indent + " ";
            }
            for (Revisions revs : parent.getChangeTrack()) {
                this.writeRevisions(revs);
            }
            if (this.indentNonUnit) {
                this.indent = this.indent.substring(1);
            }
            this.writer.print(this.indent + ChangeTrack.getClosingTag() + this.lb);
        }
    }

    private void writeRevisions(Revisions revisions) {
        this.writer.print(this.indent + "<" + revisions.getOpeningTagName());
        this.writer.print(revisions.getAttributesString());
        this.writeExtAttributes(revisions);
        this.writer.print(">" + this.lb);
        if (this.useIndentation) {
            this.indent = this.indent + " ";
        }
        for (Revision rev : revisions) {
            this.writeRevision(rev);
        }
        if (this.indentNonUnit) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + revisions.getClosingTag() + this.lb);
    }

    private void writeRevision(Revision revision) {
        this.writer.print(this.indent + "<" + revision.getOpeningTagName());
        this.writer.print(revision.getAttributesString());
        this.writeExtAttributes(revision);
        this.writer.print(">" + this.lb);
        if (this.useIndentation) {
            this.indent = this.indent + " ";
        }
        for (Item item : revision) {
            this.writeItem(item);
        }
        if (this.indentNonUnit) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + revision.getClosingTag() + this.lb);
    }

    private void writeItem(Item item) {
        this.writer.print(this.indent + "<" + item.getOpeningTagName());
        this.writer.print(item.getAttributesString());
        this.writeExtAttributes(item);
        this.writer.print(">");
        this.writer.print(item.getText());
        this.writer.print(item.getClosingTag() + this.lb);
    }

    private void writeMatches(Unit unit) {
        if (!unit.hasMatch()) {
            return;
        }
        this.writer.print(this.indent + "<mtc:matches xmlns:mtc=\"urn:oasis:names:tc:xliff:matches:2.0\">" + this.lb);
        for (Match match : unit.getMatches()) {
            this.writer.print(this.indent + "<mtc:match ref=\"" + match.getRef() + "\"");
            if (match.getId() != null) {
                this.writer.print(" id=\"" + match.getId() + "\"");
            }
            if (!match.getType().equals("tm") || match.getSubType() != null) {
                this.writer.print(" type=\"" + match.getType() + "\"");
            }
            if (match.getSubType() != null) {
                this.writer.print(" subType=\"" + Util.toXML(match.getSubType(), true) + "\"");
            }
            if (match.getSimilarity() != null) {
                this.writer.print(" similarity=\"" + match.getSimilarity() + "\"");
            }
            if (match.getMatchQuality() != null) {
                this.writer.print(" matchQuality=\"" + match.getMatchQuality() + "\"");
            }
            if (match.getMatchSuitability() != null) {
                this.writer.print(" matchSuitability=\"" + match.getMatchSuitability() + "\"");
            }
            if (match.getOrigin() != null) {
                this.writer.print(" origin=\"" + match.getOrigin() + "\"");
            }
            this.writer.print(AnnotatorsRef.printDCIfDifferent("mt-confidence", match.getAnnotatorRef(), this.context.peek().getAnnotatorsRef()));
            this.writeExtAttributes(match);
            this.writer.print(">" + this.lb);
            this.writeMetadata(match);
            if (this.withData) {
                this.writeOriginalData(match.getStore());
            }
            this.writeFragment("source", unit, match.getSource(), 0, false, Directionality.INHERITED);
            this.writeFragment("target", unit, match.getTarget(), 0, false, Directionality.INHERITED);
            this.writeExtElements(match);
            this.writer.print(this.indent + "</mtc:match>" + this.lb);
        }
        this.writer.print("</mtc:matches>" + this.lb);
    }

    private void writeGlossary(Unit unit) {
        if (!unit.hasGlossEntry()) {
            return;
        }
        this.nsStack.push(this.nsStack.peek().clone());
        this.writer.print(this.indent + "<gls:glossary xmlns:gls=\"urn:oasis:names:tc:xliff:glossary:2.0\">" + this.lb);
        for (GlossEntry entry : unit.getGlossary()) {
            this.nsStack.push(this.nsStack.peek().clone());
            this.writer.print(this.indent + "<gls:glossEntry");
            if (entry.getId() != null) {
                this.writer.print(" id=\"" + entry.getId() + "\"");
            }
            if (entry.getRef() != null) {
                this.writer.print(" ref=\"" + entry.getRef() + "\"");
            }
            this.writeExtAttributes(entry);
            this.writer.print(">" + this.lb);
            this.writer.print(this.indent + "<gls:term");
            if (entry.getTerm().getSource() != null) {
                this.writer.print(" source=\"" + entry.getTerm().getSource() + "\"");
            }
            this.writeExtAttributes(entry.getTerm());
            this.writer.print(">" + Util.toXML(entry.getTerm().getText(), false) + "</gls:term>" + this.lb);
            for (Translation trans : entry) {
                this.writer.print(this.indent + "<gls:translation");
                if (trans.getId() != null) {
                    this.writer.print(" id=\"" + trans.getId() + "\"");
                }
                if (trans.getRef() != null) {
                    this.writer.print(" ref=\"" + trans.getRef() + "\"");
                }
                if (trans.getSource() != null) {
                    this.writer.print(" source=\"" + trans.getSource() + "\"");
                }
                this.writeExtAttributes(trans);
                this.writer.print(">" + Util.toXML(trans.getText(), false) + "</gls:translation>" + this.lb);
            }
            if (entry.getDefinition() != null && entry.getDefinition().getText() != null) {
                this.writer.print(this.indent + "<gls:definition");
                if (entry.getDefinition().getSource() != null) {
                    this.writer.print(" source=\"" + entry.getDefinition().getSource() + "\"");
                }
                this.writeExtAttributes(entry.getDefinition());
                this.writer.print(">" + Util.toXML(entry.getDefinition().getText(), false) + "</gls:definition>" + this.lb);
            }
            this.writeExtElements(entry);
            this.writer.print(this.indent + "</gls:glossEntry>" + this.lb);
            this.nsStack.pop();
        }
        this.writer.print("</gls:glossary>" + this.lb);
        this.nsStack.pop();
    }

    private void writeMetadata(IWithMetadata parent) {
        if (!parent.hasMetadata()) {
            return;
        }
        NSContext nsCtx = this.nsStack.push(this.nsStack.peek().clone());
        Object ns = "";
        String prefix = nsCtx.getPrefix("urn:oasis:names:tc:xliff:metadata:2.0");
        if (prefix == null) {
            prefix = "mda";
            ns = " xmlns:" + prefix + "=\"urn:oasis:names:tc:xliff:metadata:2.0\"";
            nsCtx.put(prefix, "urn:oasis:names:tc:xliff:metadata:2.0");
        }
        this.writer.print(this.indent + "<" + prefix + ":metadata");
        Metadata md = parent.getMetadata();
        if (md.getId() != null) {
            this.writer.print(" id=\"" + md.getId() + "\"");
        }
        this.writer.print((String)ns + ">" + this.lb);
        for (MetaGroup group : md) {
            this.writeMetaGroup(group, prefix);
        }
        this.writer.print("</" + prefix + ":metadata>" + this.lb);
        this.nsStack.pop();
    }

    private void writeMetaGroup(MetaGroup group, String prefix) {
        this.writer.print(this.indent + "<" + prefix + ":metaGroup");
        if (group.getId() != null) {
            this.writer.print(" id=\"" + group.getId() + "\"");
        }
        if (group.getCategory() != null) {
            this.writer.print(" category=\"" + Util.toXML(group.getCategory(), true) + "\"");
        }
        if (group.getAppliesTo() != MetaGroup.AppliesTo.UNDEFINED) {
            this.writer.print(" appliesTo=\"" + group.getAppliesTo().toString() + "\"");
        }
        this.writer.print(">" + this.lb);
        for (IMetadataItem item : group) {
            if (item.isGroup()) {
                this.writeMetaGroup((MetaGroup)item, prefix);
                continue;
            }
            Meta m = (Meta)item;
            this.writer.print(this.indent + "<" + prefix + ":meta");
            if (m.getType() != null) {
                this.writer.print(" type=\"" + Util.toXML(m.getType(), true) + "\"");
            }
            this.writer.print(">");
            this.writer.print(Util.toXML(m.getData(), false));
            this.writer.print("</" + prefix + ":meta>" + this.lb);
        }
        this.writer.print(this.indent + "</" + prefix + ":metaGroup>" + this.lb);
    }

    private void writeValidation(IWithValidation parent) {
        if (!parent.hasValidation()) {
            return;
        }
        Validation validation = parent.getValidation();
        if (!validation.hasNonInheritedRule()) {
            return;
        }
        NSContext nsCtx = this.nsStack.push(this.nsStack.peek().clone());
        Object ns = "";
        String prefix = nsCtx.getPrefix("urn:oasis:names:tc:xliff:validation:2.0");
        if (prefix == null) {
            prefix = "val";
            ns = " xmlns:" + prefix + "=\"urn:oasis:names:tc:xliff:validation:2.0\"";
            nsCtx.put(prefix, "urn:oasis:names:tc:xliff:validation:2.0");
        }
        this.writer.print(this.indent + "<" + prefix + ":validation");
        this.writeExtAttributes(validation);
        this.writer.print((String)ns + ">" + this.lb);
        for (Rule rule : validation) {
            this.writeValidationRule(rule, prefix);
        }
        this.writer.print("</" + prefix + ":validation>" + this.lb);
        this.nsStack.pop();
    }

    private void writeValidationRule(Rule rule, String prefix) {
        if (rule.isInherited()) {
            return;
        }
        this.nsStack.push(this.nsStack.peek().clone());
        this.writer.print(this.indent + "<" + prefix + ":rule");
        if (rule.getType() != Rule.Type.CUSTOM) {
            this.writer.print(" " + rule.getType() + "=\"" + Util.toXML(rule.getData(), true) + "\"");
        }
        if (!rule.isEnabled()) {
            this.writer.print(" disabled=\"" + (rule.isEnabled() ? "no" : "yes") + "\"");
        }
        if (!rule.isCaseSensitive()) {
            this.writer.print(" caseSensitive=\"" + (rule.isCaseSensitive() ? "yes" : "no") + "\"");
        }
        if (rule.getNormalization() != Rule.Normalization.NFC) {
            this.writer.print(" normalization=\"" + rule.getNormalization().toString() + "\"");
        }
        switch (rule.getType()) {
            case CUSTOM: 
            case ISNOTPRESENT: {
                break;
            }
            case ISPRESENT: {
                if (rule.getOccurs() > 0) {
                    this.writer.print(" occurs=\"" + rule.getOccurs() + "\"");
                }
            }
            case ENDSWITH: 
            case STARTSWITH: {
                if (!rule.getExistsInSource()) break;
                this.writer.print(" existsInSource=\"" + (rule.getExistsInSource() ? "yes" : "no") + "\"");
            }
        }
        this.writeExtAttributes(rule);
        this.writer.print("/>" + this.lb);
        this.nsStack.pop();
    }

    private void writeExtAttributes(IWithExtAttributes parent) {
        if (!parent.hasExtAttribute()) {
            return;
        }
        if (this.extWriter == null) {
            this.extWriter = new ExtensionsWriter(this.getLineBreak());
        }
        this.writer.print(this.extWriter.buildExtAttributes(parent.getExtAttributes(), this.nsStack));
    }

    private void writeNotes(IWithNotes parent) {
        if (parent.getNoteCount() == 0) {
            return;
        }
        Notes notes = parent.getNotes();
        this.writer.print(this.indent + "<notes");
        this.nsStack.push(this.nsStack.peek().clone());
        this.writeExtAttributes(notes);
        this.writer.print(">" + this.lb);
        if (this.useIndentation) {
            this.indent = this.indent + " ";
        }
        for (Note note : notes) {
            this.writer.print(this.indent + "<note");
            this.nsStack.push(this.nsStack.peek().clone());
            if (!Util.isNoE(note.getId())) {
                this.writer.print(" id=\"" + Util.toXML(note.getId(), true) + "\"");
            }
            switch (note.getAppliesTo()) {
                case SOURCE: {
                    this.writer.print(" appliesTo=\"source\"");
                    break;
                }
                case TARGET: {
                    this.writer.print(" appliesTo=\"target\"");
                    break;
                }
            }
            if (note.getPriority() != 1) {
                this.writer.print(" priority=\"" + note.getPriority() + "\"");
            }
            if (note.getCategory() != null) {
                this.writer.print(" category=\"" + Util.toXML(note.getCategory(), true) + "\"");
            }
            this.writeExtAttributes(note);
            this.writer.print(">" + Util.toXML(note.getText(), false));
            this.writer.print("</note>" + this.lb);
            this.nsStack.pop();
        }
        if (this.useIndentation) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</notes>" + this.lb);
        this.nsStack.pop();
    }

    private void writeExtElements(IWithExtElements parent) {
        if (!parent.hasExtElements()) {
            return;
        }
        if (this.extWriter == null) {
            this.extWriter = new ExtensionsWriter(this.getLineBreak());
        }
        this.writer.print(this.extWriter.buildExtElements(parent, this.nsStack));
    }

    public void writeStartDocument(StartXliffData docData, String comment) {
        if (docData == null) {
            docData = new StartXliffData("2.0");
        } else {
            if (docData.getSourceLanguage() != null) {
                this.sourceLang = docData.getSourceLanguage();
            }
            if (docData.getTargetLanguage() != null) {
                this.targetLang = docData.getTargetLanguage();
            }
        }
        this.writer.print("<?xml version=\"1.0\"?>" + this.lb);
        this.writer.print("<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"" + docData.getVersion() + "\"");
        this.nsStack.push(this.nsStack.peek().clone());
        if (Util.isNoE(this.sourceLang)) {
            throw new InvalidParameterException("Source language cannot be null or empty.");
        }
        this.writer.print(" srcLang=\"" + this.sourceLang + "\"");
        if (!Util.isNoE(this.targetLang)) {
            this.writer.print(" trgLang=\"" + this.targetLang + "\"");
        }
        this.writeExtAttributes(docData);
        this.writer.print(">" + this.nonUnitLb);
        if (this.indentNonUnit) {
            this.indent = this.indent + " ";
        }
        this.inDocument = true;
        if (!Util.isNoE(comment)) {
            this.writer.print(this.indent + "<!-- " + Util.toXML(comment, false) + " -->" + this.nonUnitLb);
        }
    }

    public void writeEndDocument() {
        if (this.inFile) {
            this.writeEndFile();
        }
        if (this.inDocument) {
            if (this.indentNonUnit) {
                this.indent = this.indent.substring(1);
            }
            this.writer.print("</xliff>" + this.nonUnitLb);
            this.nsStack.pop();
            this.inDocument = false;
        }
    }

    public void setStartFileData(StartFileData startFileData) {
        this.startFileData = startFileData;
    }

    public void writeStartFile(StartFileData newFileData) {
        if (!this.inDocument) {
            this.writeStartDocument(null, null);
        }
        if (this.startFileData == null) {
            this.startFileData = newFileData == null ? new StartFileData(null) : newFileData;
        }
        if (this.startFileData.getId() == null) {
            ++this.autoFileId;
            this.startFileData.setId("f" + this.autoFileId);
        }
        this.context = new Stack();
        this.context.push(new InheritedData());
        this.context.push(new InheritedData(this.startFileData));
        this.nsStack.push(this.nsStack.peek().clone());
        this.writer.print(this.indent + "<file");
        this.writer.print(" id=\"" + Util.toXML(this.startFileData.getId(), true) + "\"");
        this.writeInheritedAttributes(this.startFileData);
        if (!Util.isNoE(this.startFileData.getOriginal())) {
            this.writer.print(" original=\"" + Util.toXML(this.startFileData.getOriginal(), true) + "\"");
        }
        this.writeExtAttributes(this.startFileData);
        this.writer.print(">" + this.nonUnitLb);
        if (this.indentNonUnit) {
            this.indent = this.indent + " ";
        }
        this.inFile = true;
    }

    public void writeMidFile(MidFileData midFileData) {
        if (!this.inFile) {
            this.writeStartFile(null);
        }
        if (midFileData != null) {
            this.writeExtElements(midFileData);
            this.writeMetadata(midFileData);
            this.writeValidation(midFileData);
            this.writeChangeTracking(midFileData);
            this.writeNotes(midFileData);
        }
    }

    private void writeInheritedAttributes(InheritedData data) {
        InheritedData parentData = (InheritedData)this.context.elementAt(this.context.size() - 2);
        if (data.getCanResegment() != parentData.getCanResegment()) {
            this.writer.print(" canResegment=\"" + (data.getCanResegment() ? "yes" : "no") + "\"");
        }
        if (data.getTranslate() != parentData.getTranslate()) {
            this.writer.print(" translate=\"" + (data.getTranslate() ? "yes" : "no") + "\"");
        }
        this.writeDirectionality("srcDir", data.getSourceDir(), parentData.getSourceDir());
        this.writeDirectionality("trgDir", data.getTargetDir(), parentData.getTargetDir());
    }

    public void writeSkeleton(Skeleton skelData) {
        List<IExtChild> list;
        if (!this.inFile) {
            this.writeStartFile(null);
        }
        if ((list = skelData.getChildren()) != null && list.isEmpty() && skelData.getHref() == null) {
            return;
        }
        this.writer.print(this.indent + "<skeleton");
        if (this.indentNonUnit) {
            this.indent = this.indent + " ";
        }
        if (skelData.getHref() != null) {
            this.writer.print(" href=\"" + Util.toXML(skelData.getHref(), true) + "\">");
        } else {
            this.writer.print(">");
            if (this.extWriter == null) {
                this.extWriter = new ExtensionsWriter(this.getLineBreak());
            }
            this.writer.print(this.extWriter.buildExtChildren(skelData.getChildren(), null));
        }
        if (this.indentNonUnit) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print("</skeleton>" + this.nonUnitLb);
    }

    public void writeEndFile() {
        if (this.inFile) {
            while (this.groupStack.size() > 0) {
                this.writeEndGroup();
            }
            if (this.indentNonUnit) {
                this.indent = this.indent.substring(1);
            }
            this.writer.print(this.indent + "</file>" + this.nonUnitLb);
            this.nsStack.pop();
            this.inFile = false;
            this.startFileData = null;
        }
    }

    public void writeStartGroup(StartGroupData startGroupData) {
        if (!this.inFile) {
            this.writeStartFile(null);
        }
        if (startGroupData == null) {
            ++this.autoGroupId;
            startGroupData = new StartGroupData("g" + this.autoGroupId);
        }
        this.context.push(new InheritedData(startGroupData));
        this.nsStack.push(this.nsStack.peek().clone());
        this.writer.print(this.indent + "<group");
        if (startGroupData.getId() != null) {
            this.writer.print(" id=\"" + Util.toXML(startGroupData.getId(), true) + "\"");
        }
        this.writeInheritedAttributes(startGroupData);
        if (startGroupData.getName() != null) {
            this.writer.print(" name=\"" + Util.toXML(startGroupData.getName(), true) + "\"");
        }
        if (startGroupData.getType() != null) {
            this.writer.print(" type=\"" + Util.toXML(startGroupData.getType(), true) + "\"");
        }
        this.writeExtAttributes(startGroupData);
        this.writer.print(">" + this.nonUnitLb);
        if (this.indentNonUnit) {
            this.indent = this.indent + " ";
        }
        this.groupStack.push(startGroupData);
        this.writeExtElements(startGroupData);
        this.writeMetadata(startGroupData);
        this.writeValidation(startGroupData);
        this.writeChangeTracking(startGroupData);
        this.writeNotes(startGroupData);
    }

    public void writeEndGroup() {
        this.groupStack.pop();
        this.context.pop();
        if (this.indentNonUnit) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</group>" + this.nonUnitLb);
        this.nsStack.pop();
    }

    private void writeFragment(String name, Unit parent, Fragment fragment, int order, boolean preserveSpace, Directionality inheritedDir) {
        if (order > 0) {
            this.writer.print(this.indent + String.format("<%s order=\"%d\"", name, order));
        } else {
            this.writer.print(this.indent + "<" + name);
        }
        if (preserveSpace) {
            this.writer.print(" xml:space=\"preserve\"");
        } else if (parent.getPreserveWS()) {
            this.writer.print(" xml:space=\"default\"");
        }
        this.writer.print(">" + fragment.toXLIFF(this.nsStack, this.context, this.withData));
        this.writer.print("</" + name + ">" + this.lb);
    }

    private void writeOriginalData(Store store) {
        if (!store.hasCTagWithData()) {
            return;
        }
        store.calculateDataToIdsMap();
        Map<String, String> map = store.getOutsideRepresentationMap();
        this.writer.print(this.indent + "<originalData>" + this.lb);
        if (this.useIndentation) {
            this.indent = this.indent + " ";
        }
        for (String originalDataKey : map.keySet()) {
            String id = map.get(originalDataKey);
            this.writer.print(this.indent + "<data id=\"" + id + "\"");
            switch (originalDataKey.charAt(originalDataKey.length() - 1)) {
                case 'r': {
                    this.writer.print(" dir=\"rtl\"");
                    break;
                }
                case 'l': {
                    this.writer.print(" dir=\"ltr\"");
                }
            }
            this.writer.print(">" + Util.toSafeXML(originalDataKey.substring(0, originalDataKey.length() - 1)));
            this.writer.print("</data>" + this.lb);
        }
        if (this.useIndentation) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</originalData>" + this.lb);
        store.setOutsideRepresentationMap(map);
    }

    public NamespaceContext getNamespaceContext() {
        return this.nsStack.peek();
    }

    private void writeDirectionality(String name, Directionality value, Directionality context) {
        if (value == context) {
            return;
        }
        this.writer.print(String.format(" %s=\"%s\"", name, value.toString()));
    }
}

