/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.writer;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff2.NSContext;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.ExtAttribute;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.ExtChildType;
import net.sf.okapi.lib.xliff2.core.ExtContent;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.IExtChild;
import net.sf.okapi.lib.xliff2.core.IWithExtElements;
import net.sf.okapi.lib.xliff2.core.ProcessingInstruction;

public class ExtensionsWriter {
    private StringBuilder sb;
    private String lb;
    private Stack<NSContext> nsStack;

    public ExtensionsWriter() {
        this.lb = System.getProperty("line.separator");
    }

    public ExtensionsWriter(String lineBreak) {
        this.setLineBreak(lineBreak);
    }

    public void setLineBreak(String lineBreak) {
        this.lb = lineBreak;
    }

    public String buildExtChildren(List<IExtChild> list, Stack<NSContext> nsStack) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        this.sb = new StringBuilder();
        if (nsStack == null) {
            this.nsStack = new Stack();
            this.nsStack.push(new NSContext("", "urn:oasis:names:tc:xliff:document:2.0"));
        } else {
            this.nsStack = nsStack;
        }
        for (IExtChild child : list) {
            switch (child.getType()) {
                case ELEMENT: {
                    ExtElement xe = (ExtElement)child;
                    this.writeExtElement(xe, this.gatherNamespaces(null, xe));
                    break;
                }
                case TEXT: {
                    this.sb.append(Util.toXML(((ExtContent)child).getText().replace("\n", this.lb), false));
                    break;
                }
                case CDATA: {
                    this.sb.append("<![CDATA[" + ((ExtContent)child).getText().replace("\n", this.lb) + "]]>");
                    break;
                }
                case PI: {
                    this.sb.append(((ProcessingInstruction)child).getPI().replace("\n", this.lb));
                }
            }
        }
        return this.sb.toString();
    }

    public String buildExtElements(IWithExtElements parent, Stack<NSContext> nsStack) {
        if (!parent.hasExtElements()) {
            return "";
        }
        this.sb = new StringBuilder();
        if (nsStack == null) {
            this.nsStack = new Stack();
            this.nsStack.push(new NSContext("", "urn:oasis:names:tc:xliff:document:2.0"));
        } else {
            this.nsStack = nsStack;
        }
        for (ExtElement elem : parent.getExtElements()) {
            this.writeExtElement(elem, this.gatherNamespaces(null, elem));
        }
        this.sb.append(this.lb);
        return this.sb.toString();
    }

    public String buildExtAttributes(ExtAttributes attributes, Stack<NSContext> nsStack) {
        if (attributes == null || attributes.isEmpty()) {
            return "";
        }
        this.sb = new StringBuilder();
        if (nsStack == null) {
            this.nsStack = new Stack();
            this.nsStack.push(new NSContext("", "urn:oasis:names:tc:xliff:document:2.0"));
        } else {
            this.nsStack = nsStack;
        }
        this.writeExtAttributes(attributes);
        return this.sb.toString();
    }

    private void writeExtAttributes(ExtAttributes attributes) {
        String prefix;
        if (attributes == null) {
            return;
        }
        NSContext nsCtx = this.nsStack.peek();
        for (String namespaceURI : attributes.getNamespaces()) {
            if (namespaceURI.isEmpty() || this.nsStack.peek().getPrefix(namespaceURI) != null || (prefix = attributes.getNamespacePrefix(namespaceURI)) == null) continue;
            this.sb.append(" xmlns" + (String)(prefix.isEmpty() ? "" : ":" + prefix) + "=\"" + namespaceURI + "\"");
            nsCtx.put(prefix, namespaceURI);
        }
        for (ExtAttribute att : attributes) {
            prefix = nsCtx.getPrefix(att.getNamespaceURI());
            this.sb.append(" " + (String)(Util.isNoE(prefix) ? "" : prefix + ":") + att.getLocalPart() + "=\"" + Util.toXML(att.getValue(), true) + "\"");
        }
    }

    private void writeExtElement(ExtElement element, Map<String, String> childrenNS) {
        QName qn = element.getQName();
        Object prefix = "";
        if (!qn.getPrefix().isEmpty()) {
            prefix = qn.getPrefix() + ":";
        }
        this.sb.append("<" + (String)prefix + qn.getLocalPart());
        NSContext nsCtx = this.nsStack.push(this.nsStack.peek().clone());
        String ctxPrfx = nsCtx.getPrefix(qn.getNamespaceURI());
        if (ctxPrfx == null || !ctxPrfx.equals(qn.getPrefix())) {
            this.sb.append(" xmlns" + (String)(qn.getPrefix().isEmpty() ? "" : ":" + qn.getPrefix()) + "=\"" + qn.getNamespaceURI() + "\"");
            nsCtx.put(qn.getPrefix(), qn.getNamespaceURI());
        }
        if (childrenNS != null) {
            for (String uri : childrenNS.keySet()) {
                ctxPrfx = nsCtx.getPrefix(uri);
                String locPrfx = childrenNS.get(uri);
                if (ctxPrfx != null && nsCtx.containsPair(ctxPrfx, uri)) continue;
                this.sb.append(" xmlns" + (String)(locPrfx.isEmpty() ? "" : ":" + locPrfx) + "=\"" + uri + "\"");
                nsCtx.put(locPrfx, uri);
            }
        }
        this.writeExtAttributes(element.getExtAttributes());
        this.sb.append(">");
        for (IExtChild child : element.getChildren()) {
            switch (child.getType()) {
                case ELEMENT: {
                    this.writeExtElement((ExtElement)child, null);
                    break;
                }
                case TEXT: {
                    this.sb.append(Util.toXML(((ExtContent)child).getText().replace("\n", this.lb), false));
                    break;
                }
                case CDATA: {
                    this.sb.append("<![CDATA[" + ((ExtContent)child).getText().replace("\n", this.lb) + "]]>");
                    break;
                }
                case PI: {
                    this.sb.append(((ProcessingInstruction)child).getPI().replace("\n", this.lb));
                }
            }
        }
        this.sb.append("</" + (String)prefix + qn.getLocalPart() + ">");
        this.nsStack.pop();
    }

    private Map<String, String> gatherNamespaces(Map<String, String> map, ExtElement element) {
        if (map == null) {
            map = new LinkedHashMap<String, String>();
        }
        String prefix = element.getQName().getPrefix();
        String uri = element.getQName().getNamespaceURI();
        if (!(map.containsValue(prefix) || prefix.isEmpty() && uri.equals("urn:oasis:names:tc:xliff:document:2.0"))) {
            map.put(uri, prefix);
        }
        for (IExtChild child : element.getChildren()) {
            if (child.getType() != ExtChildType.ELEMENT) continue;
            this.gatherNamespaces(map, (ExtElement)child);
        }
        return map;
    }
}

