/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff2.core.ExtAttribute;

public class ExtAttributes
implements Iterable<ExtAttribute> {
    private ArrayList<ExtAttribute> attrs;
    private Map<String, String> namespaces;
    private int autoPrefixCount = 1;

    public ExtAttributes() {
    }

    public ExtAttributes(ExtAttributes original) {
        for (ExtAttribute attr : original) {
            this.setAttribute(new ExtAttribute(attr));
        }
        if (original.hasNamespace()) {
            for (String key : original.getNamespaces()) {
                this.setNamespace(original.getNamespacePrefix(key), key);
            }
        }
        this.autoPrefixCount = original.autoPrefixCount;
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        if (this.attrs == null) {
            return null;
        }
        for (ExtAttribute att : this.attrs) {
            if (!att.getLocalPart().equals(localName) || !att.getNamespaceURI().equals(namespaceURI)) continue;
            return att.getValue();
        }
        return null;
    }

    public ExtAttribute getAttribute(String namespaceURI, String localName) {
        if (this.attrs == null) {
            return null;
        }
        for (ExtAttribute att : this.attrs) {
            if (!att.getLocalPart().equals(localName) || !att.getNamespaceURI().equals(namespaceURI)) continue;
            return att;
        }
        return null;
    }

    public ExtAttribute setAttribute(ExtAttribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList(2);
        }
        this.ensureNamespaceAndPrefix(attribute.getNamespaceURI(), attribute.getPrefix());
        int pos = 0;
        for (ExtAttribute att : this.attrs) {
            if (att.getLocalPart().equals(attribute.getLocalPart()) && att.getNamespaceURI().equals(attribute.getNamespaceURI())) {
                this.attrs.set(pos, attribute);
                return attribute;
            }
            ++pos;
        }
        this.attrs.add(attribute);
        return attribute;
    }

    public ExtAttribute setAttribute(String namespaceURI, String localName, String value) {
        if (this.attrs == null) {
            this.attrs = new ArrayList(2);
        }
        this.ensureNamespaceAndPrefix(namespaceURI, null);
        ExtAttribute att = this.getAttribute(namespaceURI, localName);
        if (att == null) {
            att = new ExtAttribute(new QName(namespaceURI, localName, this.getNamespacePrefix(namespaceURI)), value);
            this.attrs.add(att);
        }
        att.setValue(value);
        return att;
    }

    public ExtAttribute setAttribute(String localName, String value) {
        return this.setAttribute("", localName, value);
    }

    private void ensureNamespaceAndPrefix(String namespaceURI, String oriPrefix) {
        if (this.getNamespacePrefix(namespaceURI) == null) {
            Object prefix;
            if (this.namespaces == null) {
                this.namespaces = new LinkedHashMap<String, String>();
            }
            if (oriPrefix != null && !this.namespaces.containsValue(oriPrefix)) {
                prefix = oriPrefix;
            } else {
                while (this.namespaces.containsValue(prefix = "x" + this.autoPrefixCount)) {
                    ++this.autoPrefixCount;
                }
            }
            this.setNamespace((String)prefix, namespaceURI);
        }
    }

    public void deleteAttribute(String namespaceURI, String localName) {
        if (this.attrs == null) {
            return;
        }
        ExtAttribute att = this.getAttribute(namespaceURI, localName);
        if (att == null) {
            return;
        }
        this.attrs.remove(att);
    }

    public boolean isEmpty() {
        if (this.attrs != null && this.attrs.size() > 0) {
            return false;
        }
        return this.namespaces == null || this.namespaces.size() <= 0;
    }

    public int size() {
        if (this.attrs == null) {
            return 0;
        }
        return this.attrs.size();
    }

    @Override
    public Iterator<ExtAttribute> iterator() {
        if (this.attrs == null) {
            this.attrs = new ArrayList(2);
        }
        return this.attrs.iterator();
    }

    public void setNamespace(String prefix, String namespaceURI) {
        if (this.namespaces == null) {
            this.namespaces = new LinkedHashMap<String, String>();
        }
        this.namespaces.put(namespaceURI, prefix);
    }

    public String getNamespacePrefix(String namespaceURI) {
        if (this.namespaces == null) {
            return null;
        }
        return this.namespaces.get(namespaceURI);
    }

    public boolean hasNamespace() {
        if (this.namespaces == null) {
            return false;
        }
        return this.namespaces.size() > 0;
    }

    public Set<String> getNamespaces() {
        if (this.namespaces == null) {
            return Collections.emptySet();
        }
        return this.namespaces.keySet();
    }
}

