/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff.iws;

import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.filters.xliff.Parameters;
import net.sf.okapi.filters.xliff.XLIFFSkeletonWriter;
import net.sf.okapi.filters.xliff.iws.IwsProperty;
import net.sf.okapi.filters.xliff.iws.IwsStatusAttribute;

public class IwsXliffSkeletonWriter
extends XLIFFSkeletonWriter {
    public static final String IWS_TRANS_STATUS_MARKER = "[@#$IWSTRANSSTATUS$#@]";
    public static final String IWS_TRANS_TYPE_MARKER = "[@#$IWSTRANSTYPE$#@]";

    public IwsXliffSkeletonWriter(Parameters params) {
        super(params);
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        LocaleId tl;
        if (!resource.getTargetLocales().isEmpty() && resource.hasTarget(tl = resource.getTargetLocales().iterator().next()) && resource.isTranslatable()) {
            resource.setSkeleton(this.updateIwsTransStatus(resource.getTarget(tl), (GenericSkeleton)resource.getSkeleton()));
            resource.setSkeleton(this.updateIwsTransType(resource.getTarget(tl), (GenericSkeleton)resource.getSkeleton()));
        }
        return super.processTextUnit(resource);
    }

    private ISkeleton updateIwsTransStatus(TextContainer target, GenericSkeleton skeleton) {
        for (GenericSkeletonPart p : skeleton.getParts()) {
            Property s = target.getProperty(new IwsStatusAttribute(IwsProperty.TRANSLATION_STATUS).getAttributeNamePrefixed());
            String d = p.getData().toString();
            d = s != null ? d.replace(IWS_TRANS_STATUS_MARKER, !Util.isEmpty(s.getValue()) ? s.getValue() : this.getParams().getIwsTransStatusValue()) : d.replace(IWS_TRANS_STATUS_MARKER, this.getParams().getIwsTransStatusValue());
            if (this.getParams().isIwsRemoveTmOrigin()) {
                d = d.replaceFirst("(tm_origin\\=)(\\\")([^\\\"]+)(\\\")", "");
            }
            p.setData(d);
        }
        return skeleton;
    }

    private ISkeleton updateIwsTransType(TextContainer target, GenericSkeleton skeleton) {
        for (GenericSkeletonPart p : skeleton.getParts()) {
            Property s = target.getProperty(new IwsStatusAttribute(IwsProperty.TRANSLATION_TYPE).getAttributeNamePrefixed());
            String d = p.getData().toString();
            d = s != null ? d.replace(IWS_TRANS_TYPE_MARKER, !Util.isEmpty(s.getValue()) ? s.getValue() : this.getParams().getIwsTransTypeValue()) : d.replace(IWS_TRANS_TYPE_MARKER, this.getParams().getIwsTransTypeValue());
            p.setData(d);
        }
        return skeleton;
    }
}

