/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff.its;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.filters.xliff.its.ITSLQI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITSLQICollection {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String resource;
    private String xmlid;
    private String version;
    private List<ITSLQI> issues = new LinkedList<ITSLQI>();

    public ITSLQICollection(Iterator<Attribute> attrs, String resource) {
        this.resource = resource;
        while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            String prefix = attr.getName().getPrefix();
            Object name = attr.getName().getLocalPart();
            String value = attr.getValue();
            if (!prefix.isEmpty()) {
                name = prefix + ":" + (String)name;
            }
            if (((String)name).equals("xml:id")) {
                this.xmlid = value;
                continue;
            }
            if (((String)name).equals("version")) {
                this.version = value;
                continue;
            }
            if (((String)name).equals("xmlns:its")) continue;
            this.logger.warn("Unrecognized attribute '{}'.", name);
        }
    }

    public ITSLQICollection(List<ITSLQI> issues, String resource, String xmlid, String version) {
        this.issues = issues;
        this.resource = resource;
        this.xmlid = xmlid;
        this.version = version;
    }

    public void addLQI(Iterator<Attribute> attrs) {
        this.issues.add(new ITSLQI(attrs));
    }

    public String getXMLId() {
        return this.xmlid;
    }

    public String getVersion() {
        return this.version;
    }

    public String getURI() {
        return this.resource + "#" + this.xmlid;
    }

    public Iterator<ITSLQI> iterator() {
        return this.issues.iterator();
    }
}

