/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff.its;

import java.util.Iterator;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.IssueAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.filters.xliff.XLIFFITSFilterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITSLQI {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IssueAnnotation ann = new IssueAnnotation();

    public ITSLQI(Iterator<Attribute> attrs) {
        String itsType = null;
        block26: while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            String prefix = attr.getName().getPrefix();
            String name = attr.getName().getLocalPart();
            String ns = attr.getName().getNamespaceURI();
            String value = attr.getValue();
            Object prefixedName = name;
            if (!prefix.isEmpty() && !prefix.equals("its")) {
                prefixedName = prefix + ":" + name;
            }
            if (ns.isEmpty() || ns.equals("http://www.w3.org/2005/11/its")) {
                switch (name) {
                    case "locQualityIssueType": {
                        this.ann.setITSType(value);
                        itsType = value;
                        break;
                    }
                    case "locQualityIssueComment": {
                        this.ann.setComment(value);
                        break;
                    }
                    case "locQualityIssueSeverity": {
                        this.ann.setSeverity(Double.parseDouble(value));
                        break;
                    }
                    case "locQualityIssueProfileRef": {
                        this.ann.setProfileRef(value);
                        break;
                    }
                    case "locQualityIssueEnabled": {
                        this.ann.setEnabled(value.equals("yes"));
                        break;
                    }
                    default: {
                        this.logger.warn("Unknown attribute '{}'.", prefixedName);
                        break;
                    }
                }
                continue;
            }
            if (ns.equals("okapi-framework:xliff-extensions")) {
                switch (name) {
                    case "lqiType": {
                        this.ann.setIssueType(IssueType.valueOf(value));
                        if (itsType == null) continue block26;
                        this.ann.setITSType(itsType);
                        break;
                    }
                    case "lqiPos": {
                        int[] positions = XLIFFITSFilterExtension.parseXLQIPos(value, this.logger);
                        this.ann.setSourcePosition(positions[0], positions[1]);
                        this.ann.setTargetPosition(positions[2], positions[3]);
                        break;
                    }
                    case "lqiCodes": {
                        this.ann.setCodes(value);
                        break;
                    }
                    case "lqiSegId": {
                        this.ann.setSegId(value);
                        break;
                    }
                    default: {
                        this.logger.warn("Unknown attribute '{}'.", prefixedName);
                        break;
                    }
                }
                continue;
            }
            this.logger.warn("Unknown attribute '{}'.", prefixedName);
        }
    }

    public ITSLQI(IssueAnnotation ann) {
        this.ann = (IssueAnnotation)ann.clone();
    }

    public String getType() {
        return this.ann.getITSType();
    }

    public double getSeverity() {
        return this.ann.getSeverity();
    }

    public String getComment() {
        return this.ann.getComment();
    }

    public String getProfileRef() {
        return this.ann.getProfileRef();
    }

    public boolean getEnabled() {
        return this.ann.getEnabled();
    }

    public GenericAnnotation getAnnotation() {
        if (this.ann.getFieldCount() == 0) {
            return null;
        }
        return this.ann;
    }
}

