/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DifferentialFormat;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.StyleDefinition;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleDefinitionsReader;
import net.sf.okapi.filters.openxml.StyleType;
import net.sf.okapi.filters.openxml.WordStyleDefinition;
import net.sf.okapi.filters.openxml.WordStyleDefinitionsReader;

class WordStyleDefinitions
implements StyleDefinitions {
    static final String STYLES = "styles";
    static final String DOC_DEFAULTS = "docDefaults";
    static final String LATENT_STYLES = "latentStyles";
    static final String STYLE = "style";
    private final ConditionalParameters conditionalParameters;
    private final XMLEventFactory eventFactory;
    private StartDocument startDocument;
    private StartElement startElement;
    private StyleDefinition documentDefaults;
    private StyleDefinition latentStyles;
    private Map<StyleType, String> defaultStylesByStyleTypes;
    private Map<String, StyleType> styleTypesByStyleIds;
    private Map<String, String> parentStylesByStyleIds;
    private Map<String, String> linkedStylesByStyleIds;
    private Map<String, WordStyleDefinition> stylesByStyleIds;
    private EndElement endElement;
    private EndDocument endDocument;
    private Ids ids;
    private String placedId;

    WordStyleDefinitions(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory) {
        this.conditionalParameters = conditionalParameters;
        this.eventFactory = eventFactory;
    }

    @Override
    public void readWith(StyleDefinitionsReader reader) throws XMLStreamException {
        this.defaultStylesByStyleTypes = new EnumMap<StyleType, String>(StyleType.class);
        this.styleTypesByStyleIds = new HashMap<String, StyleType>();
        this.parentStylesByStyleIds = new HashMap<String, String>();
        this.linkedStylesByStyleIds = new HashMap<String, String>();
        this.stylesByStyleIds = new LinkedHashMap<String, WordStyleDefinition>();
        this.ids = new Ids(new IdGenerator(STYLE, STYLE), this);
        WordStyleDefinitionsReader styleDefinitionsReader = (WordStyleDefinitionsReader)reader;
        this.startDocument = styleDefinitionsReader.startDocument();
        this.startElement = styleDefinitionsReader.startElement();
        this.documentDefaults = styleDefinitionsReader.documentDefaults();
        this.latentStyles = styleDefinitionsReader.latent();
        while (styleDefinitionsReader.nextGeneralAvailable()) {
            this.place(styleDefinitionsReader.nextGeneral());
        }
        this.endElement = styleDefinitionsReader.endElement();
        this.endDocument = styleDefinitionsReader.endDocument();
    }

    private void place(WordStyleDefinition styleDefinition) {
        if (styleDefinition.isDefault()) {
            this.defaultStylesByStyleTypes.put(styleDefinition.type(), styleDefinition.id());
        }
        this.styleTypesByStyleIds.put(styleDefinition.id(), styleDefinition.type());
        this.parentStylesByStyleIds.put(styleDefinition.id(), styleDefinition.parentId());
        this.linkedStylesByStyleIds.put(styleDefinition.id(), styleDefinition.linkedId());
        this.stylesByStyleIds.put(styleDefinition.id(), styleDefinition);
    }

    @Override
    public void place(String parentId, ParagraphBlockProperties paragraphBlockProperties, RunProperties runProperties) {
        this.placedId = this.ids.next(parentId, paragraphBlockProperties, runProperties);
        if (this.stylesByStyleIds.containsKey(this.placedId)) {
            return;
        }
        WordStyleDefinition.General styleDefinition = new WordStyleDefinition.General(this.conditionalParameters, this.eventFactory, this.startElementForGeneral(this.placedId));
        styleDefinition.parentId(this.ids.parent());
        styleDefinition.paragraphProperties(new ParagraphBlockProperties.Word(new BlockProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "pPr"), this.conditionalParameters, this.eventFactory, new StrippableAttributes.Default(this.eventFactory)));
        styleDefinition.runProperties(runProperties);
        this.place(styleDefinition);
    }

    @Override
    public String placedId() {
        return this.placedId;
    }

    private StartElement startElementForGeneral(String id) {
        List<Attribute> attributes = Arrays.asList(this.eventFactory.createAttribute(new QName(this.startElement.getName().getNamespaceURI(), "type", this.startElement.getName().getPrefix()), StyleType.PARAGRAPH.toString()), this.eventFactory.createAttribute(new QName(this.startElement.getName().getNamespaceURI(), "styleId", this.startElement.getName().getPrefix()), id));
        return this.eventFactory.createStartElement(new QName(this.startElement.getName().getNamespaceURI(), STYLE, this.startElement.getName().getPrefix()), attributes.iterator(), null);
    }

    @Override
    public ParagraphBlockProperties combinedParagraphBlockProperties(ParagraphBlockProperties paragraphBlockProperties) {
        String paragraphStyle = paragraphBlockProperties.paragraphStyle();
        ParagraphBlockProperties paragraphProperties = paragraphBlockProperties.withoutParagraphStyle();
        if (null == this.stylesByStyleIds.get(paragraphStyle)) {
            String defaultStyle = this.defaultStylesByStyleTypes.get((Object)StyleType.PARAGRAPH);
            if (null == defaultStyle) {
                return this.documentDefaults.paragraphProperties().mergedWith(paragraphProperties);
            }
            return this.documentDefaults.paragraphProperties().mergedWith(this.combinedThroughoutParentStylesProperties(defaultStyle, paragraphProperties));
        }
        return this.documentDefaults.paragraphProperties().mergedWith(this.combinedThroughoutParentStylesProperties(paragraphStyle, paragraphProperties));
    }

    private ParagraphBlockProperties combinedThroughoutParentStylesProperties(String styleId, ParagraphBlockProperties paragraphProperties) {
        if (null == this.stylesByStyleIds.get(styleId)) {
            return paragraphProperties;
        }
        if (null == this.parentStylesByStyleIds.get(styleId) || this.styleTypesByStyleIds.get(this.parentStylesByStyleIds.get(styleId)) != StyleType.PARAGRAPH) {
            return this.stylesByStyleIds.get(styleId).paragraphProperties().mergedWith(paragraphProperties);
        }
        return this.combinedThroughoutParentStylesProperties(this.parentStylesByStyleIds.get(styleId), this.stylesByStyleIds.get(styleId).paragraphProperties()).mergedWith(paragraphProperties);
    }

    @Override
    public RunProperties combinedRunProperties(String paragraphStyle, String runStyle, RunProperties runProperties) {
        RunProperties combinedRunProperties = RunProperties.copiedRunProperties(this.documentDefaults.runProperties(), false, false, true);
        combinedRunProperties = combinedRunProperties.combineDistinct(this.getParagraphStyleProperties(paragraphStyle), StyleDefinitions.TraversalStage.VERTICAL);
        combinedRunProperties = combinedRunProperties.combineDistinct(this.getRunStyleProperties(runStyle, paragraphStyle), StyleDefinitions.TraversalStage.VERTICAL);
        combinedRunProperties = combinedRunProperties.combineDistinct(RunProperties.copiedToggleRunProperties(this.documentDefaults.runProperties()), StyleDefinitions.TraversalStage.DOCUMENT_DEFAULT);
        combinedRunProperties = combinedRunProperties.combineDistinct(RunProperties.copiedRunProperties(runProperties, false, true, false), StyleDefinitions.TraversalStage.DIRECT);
        return combinedRunProperties;
    }

    private RunProperties getParagraphStyleProperties(String paragraphStyle) {
        return this.getPropertiesByTypeAndStyle(StyleType.PARAGRAPH, paragraphStyle, null);
    }

    private RunProperties getRunStyleProperties(String runStyle, String linkedStyle) {
        return this.getPropertiesByTypeAndStyle(StyleType.CHARACTER, runStyle, linkedStyle);
    }

    private RunProperties getPropertiesByTypeAndStyle(StyleType styleType, String styleId, String linkedStyleId) {
        if (null == styleId || !this.styleTypesByStyleIds.containsKey(styleId) || !this.styleTypesByStyleIds.get(styleId).equals((Object)styleType)) {
            String defaultStyleId = this.defaultStylesByStyleTypes.get((Object)styleType);
            return this.combineParentStyleProperties(styleType, defaultStyleId, new RunProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "rPr"));
        }
        return this.combineLinkedAndParentStyleProperties(styleType, styleId, linkedStyleId, new RunProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "rPr"));
    }

    private RunProperties combineLinkedAndParentStyleProperties(StyleType styleType, String styleId, String linkedStyleId, RunProperties runProperties) {
        if (null == linkedStyleId || StyleType.CHARACTER != styleType || null == this.linkedStylesByStyleIds.get(linkedStyleId) || StyleType.PARAGRAPH != this.styleTypesByStyleIds.get(linkedStyleId)) {
            return this.combineParentStyleProperties(styleType, styleId, runProperties);
        }
        RunProperties paragraphProperties = this.combineParentStyleProperties(StyleType.PARAGRAPH, this.linkedStylesByStyleIds.get(linkedStyleId), new RunProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "rPr"));
        RunProperties characterProperties = this.combineParentStyleProperties(StyleType.CHARACTER, styleId, new RunProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "rPr"));
        return paragraphProperties.combineDistinct(characterProperties, StyleDefinitions.TraversalStage.HORIZONTAL);
    }

    private RunProperties combineParentStyleProperties(StyleType styleType, String styleId, RunProperties runProperties) {
        if (null == this.stylesByStyleIds.get(styleId)) {
            return runProperties;
        }
        if (null == this.parentStylesByStyleIds.get(styleId) || this.styleTypesByStyleIds.get(this.parentStylesByStyleIds.get(styleId)) != styleType) {
            return RunProperties.copiedRunProperties(this.stylesByStyleIds.get(styleId).runProperties()).combineDistinct(runProperties, StyleDefinitions.TraversalStage.HORIZONTAL);
        }
        return this.combineParentStyleProperties(styleType, this.parentStylesByStyleIds.get(styleId), RunProperties.copiedRunProperties(this.stylesByStyleIds.get(styleId).runProperties())).combineDistinct(runProperties, StyleDefinitions.TraversalStage.HORIZONTAL);
    }

    @Override
    public DifferentialFormat.Combined combinedDifferentialFormatFor(int cellFormatIndex) {
        throw new UnsupportedOperationException("The operation is unsupported");
    }

    @Override
    public StyleDefinitions mergedWith(StyleDefinitions other) {
        throw new UnsupportedOperationException("The operation is unsupported");
    }

    @Override
    public Markup asMarkup() {
        Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
        markup.addComponent(new MarkupComponent.General(Collections.singletonList(this.startDocument)));
        markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.startElement));
        markup.addMarkup(this.documentDefaults.asMarkup());
        markup.addMarkup(this.latentStyles.asMarkup());
        for (Map.Entry<String, WordStyleDefinition> entry : this.stylesByStyleIds.entrySet()) {
            markup.addMarkup(entry.getValue().asMarkup());
        }
        markup.addComponent(new MarkupComponent.End(this.endElement));
        markup.addComponent(new MarkupComponent.General(Collections.singletonList(this.endDocument)));
        return markup;
    }

    private static class Ids {
        private final IdGenerator idGenerator;
        private final WordStyleDefinitions styleDefinitions;
        private String parent;

        Ids(IdGenerator idGenerator, WordStyleDefinitions styleDefinitions) {
            this.idGenerator = idGenerator;
            this.styleDefinitions = styleDefinitions;
        }

        String next(String paragraphStyle, ParagraphBlockProperties paragraphBlockProperties, RunProperties runProperties) {
            if (null != paragraphStyle && this.styleDefinitions.stylesByStyleIds.containsKey(paragraphStyle)) {
                return this.parentBased(StyleType.PARAGRAPH, paragraphStyle, paragraphBlockProperties, runProperties);
            }
            return this.defaultBased(StyleType.PARAGRAPH, paragraphBlockProperties, runProperties);
        }

        private String parentBased(StyleType type, String parentId, ParagraphBlockProperties paragraphBlockProperties, RunProperties runProperties) {
            this.parent = parentId;
            Optional<String> existing = this.styleDefinitions.stylesByStyleIds.entrySet().stream().filter(e -> type == ((WordStyleDefinition)e.getValue()).type()).filter(e -> parentId.equals(((WordStyleDefinition)e.getValue()).parentId())).filter(e -> paragraphBlockProperties.mergeableWith(((WordStyleDefinition)e.getValue()).paragraphProperties())).filter(e -> runProperties.equals(((WordStyleDefinition)e.getValue()).runProperties())).map(e -> (String)e.getKey()).findFirst();
            return existing.orElseGet(() -> this.parentBasedGenerated(parentId));
        }

        private String parentBasedGenerated(String parentId) {
            String parentBasedId;
            while (this.styleDefinitions.stylesByStyleIds.containsKey(parentBasedId = this.idGenerator.createId(parentId))) {
            }
            return parentBasedId;
        }

        private String defaultBased(StyleType type, ParagraphBlockProperties paragraphBlockProperties, RunProperties runProperties) {
            String defaultStyle = this.styleDefinitions.defaultStylesByStyleTypes.get((Object)type);
            if (null != defaultStyle) {
                return this.parentBased(type, defaultStyle, paragraphBlockProperties, runProperties);
            }
            return this.documentDefaultBased(type, runProperties);
        }

        private String documentDefaultBased(StyleType type, RunProperties runProperties) {
            this.parent = null;
            Optional<String> existing = this.styleDefinitions.stylesByStyleIds.entrySet().stream().filter(e -> type == ((WordStyleDefinition)e.getValue()).type()).filter(e -> null == ((WordStyleDefinition)e.getValue()).parentId()).filter(e -> runProperties.equals(((WordStyleDefinition)e.getValue()).runProperties())).map(e -> (String)e.getKey()).findFirst();
            return existing.orElseGet(() -> this.documentDefaultBasedGenerated());
        }

        private String documentDefaultBasedGenerated() {
            return this.idGenerator.createIdNotInList(new ArrayList<String>(this.styleDefinitions.stylesByStyleIds.keySet()));
        }

        String parent() {
            return this.parent;
        }
    }
}

