/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import net.sf.okapi.filters.openxml.BlockPropertiesClarification;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.RunPropertiesClarification;
import net.sf.okapi.filters.openxml.StyleType;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface StylesClarification {
    public void performWith(ListIterator<MarkupComponent> var1);

    public static final class Word
    implements StylesClarification {
        private final BlockPropertiesClarification tablePropertiesClarification;
        private final BlockPropertiesClarification paragraphPropertiesClarification;
        private final RunPropertiesClarification runPropertiesClarification;
        private final Set<String> clarifiableWordStyleTypes;

        Word(BlockPropertiesClarification tablePropertiesClarification, BlockPropertiesClarification paragraphPropertiesClarification, RunPropertiesClarification runPropertiesClarification) {
            this(tablePropertiesClarification, paragraphPropertiesClarification, runPropertiesClarification, new HashSet<String>(Arrays.asList(StyleType.TABLE.toString(), StyleType.PARAGRAPH.toString(), StyleType.CHARACTER.toString())));
        }

        Word(BlockPropertiesClarification tablePropertiesClarification, BlockPropertiesClarification paragraphPropertiesClarification, RunPropertiesClarification runPropertiesClarification, Set<String> clarifiableWordStyleTypes) {
            this.tablePropertiesClarification = tablePropertiesClarification;
            this.paragraphPropertiesClarification = paragraphPropertiesClarification;
            this.runPropertiesClarification = runPropertiesClarification;
            this.clarifiableWordStyleTypes = clarifiableWordStyleTypes;
        }

        @Override
        public void performWith(ListIterator<MarkupComponent> iterator) {
            while (iterator.hasNext()) {
                MarkupComponent component = iterator.next();
                if (MarkupComponent.isWordDocumentDefaultsStart(component)) {
                    this.clarifyWordDocumentDefaultsWith(iterator);
                    continue;
                }
                if (MarkupComponent.isWordStyleStart(component)) {
                    this.clarifyWordStyleWith((MarkupComponent.Start)component, iterator);
                    continue;
                }
                if (!MarkupComponent.isWordStylesEnd(component)) continue;
                break;
            }
        }

        private void clarifyWordDocumentDefaultsWith(ListIterator<MarkupComponent> iterator) {
            while (iterator.hasNext()) {
                MarkupComponent component = iterator.next();
                if (MarkupComponent.isWordParagraphPropertiesDefaultStart(component)) {
                    this.paragraphPropertiesClarification.performWith(iterator);
                    this.clarifiableWordStyleTypes.remove(StyleType.PARAGRAPH.toString());
                    continue;
                }
                if (MarkupComponent.isWordRunPropertiesDefaultStart(component)) {
                    this.clarifyDefaultRunPropertiesWith(iterator);
                    this.clarifiableWordStyleTypes.remove(StyleType.CHARACTER.toString());
                    continue;
                }
                if (!MarkupComponent.isWordDocumentDefaultsEnd(component)) continue;
                break;
            }
        }

        private void clarifyDefaultRunPropertiesWith(ListIterator<MarkupComponent> iterator) {
            while (iterator.hasNext()) {
                MarkupComponent component = iterator.next();
                if (MarkupComponent.isRunProperties(component)) {
                    this.runPropertiesClarification.performFor(component);
                    iterator.set(component);
                    continue;
                }
                if (!MarkupComponent.isWordRunPropertiesDefaultEnd(component)) continue;
                break;
            }
        }

        private void clarifyWordStyleWith(MarkupComponent.Start startComponent, ListIterator<MarkupComponent> iterator) {
            if (!startComponent.containsAttributeWithAnyOfValues("type", this.clarifiableWordStyleTypes) || !startComponent.containsAttributeWithAnyOfValues("default", XMLEventHelpers.booleanAttributeTrueValues())) {
                return;
            }
            while (iterator.hasNext()) {
                MarkupComponent component = iterator.next();
                if (MarkupComponent.isParagraphBlockProperties(component)) {
                    iterator.previous();
                    this.paragraphPropertiesClarification.performWith(iterator);
                    continue;
                }
                if (MarkupComponent.isRunProperties(component)) {
                    this.runPropertiesClarification.performFor(component);
                    iterator.set(component);
                    continue;
                }
                if (MarkupComponent.isTableBlockProperties(component)) {
                    iterator.previous();
                    this.tablePropertiesClarification.performWith(iterator);
                    continue;
                }
                if (!MarkupComponent.isWordStyleEnd(component)) continue;
                break;
            }
        }
    }
}

