/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Set;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinition;
import net.sf.okapi.filters.openxml.StyleDefinitionsReader;

final class PowerpointStyleDefinitionsReader
implements StyleDefinitionsReader {
    private static final String UNSUPPORTED_STRUCTURE = "Unsupported structure of %s";
    private final ConditionalParameters conditionalParameters;
    private final XMLEventFactory eventFactory;
    private final XMLEventReader eventReader;
    private final String style;
    private final String paragraphDefault;
    private final Set<String> paragraphLevels;
    private final Cache cache;

    PowerpointStyleDefinitionsReader(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, XMLEventReader eventReader, StartElement startElement, String style) {
        this(conditionalParameters, eventFactory, eventReader, startElement, style, "defPPr", PowerpointStyleDefinition.PARAGRAPH_LEVELS);
    }

    PowerpointStyleDefinitionsReader(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, XMLEventReader eventReader, StartElement startElement, String style, String paragraphDefault, Set<String> paragraphLevels) {
        this.conditionalParameters = conditionalParameters;
        this.eventFactory = eventFactory;
        this.eventReader = eventReader;
        this.style = style;
        this.paragraphDefault = paragraphDefault;
        this.paragraphLevels = paragraphLevels;
        this.cache = new Cache(startElement);
    }

    @Override
    public StartElement startElement() throws XMLStreamException {
        if (this.cache.hasStartElement()) {
            return this.cache.startElement;
        }
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (!event.isStartElement() || !this.style.equals(event.asStartElement().getName().getLocalPart())) continue;
            this.cache.startElement = event.asStartElement();
            return this.cache.startElement;
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_STRUCTURE, this.style));
    }

    PowerpointStyleDefinition paragraphDefaults() throws XMLStreamException {
        if (!this.cache.hasStartElement()) {
            this.startElement();
        }
        if (this.cache.hasParagraphDefaults()) {
            return this.cache.paragraphDefaults;
        }
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (event.isStartElement() && this.paragraphDefault.equals(event.asStartElement().getName().getLocalPart())) {
                this.cache.paragraphDefaults = new PowerpointStyleDefinition.ParagraphDefault(this.conditionalParameters, this.eventFactory, event.asStartElement());
                this.cache.paragraphDefaults.readWith(this.eventReader);
                return this.cache.paragraphDefaults;
            }
            if (event.isStartElement() && this.paragraphLevels.contains(event.asStartElement().getName().getLocalPart())) {
                this.cache.paragraphStyleStartElement = event.asStartElement();
                break;
            }
            if (!event.isEndElement() || !this.style.equals(event.asEndElement().getName().getLocalPart())) continue;
            this.cache.endElement = event.asEndElement();
            break;
        }
        this.cache.paragraphDefaults = new PowerpointStyleDefinition.ParagraphDefault(this.conditionalParameters, this.eventFactory, this.cache.startElement.getName().getNamespaceURI(), this.cache.startElement.getName().getPrefix());
        return this.cache.paragraphDefaults;
    }

    boolean nextParagraphLevelAvailable() throws XMLStreamException {
        if (!this.cache.hasParagraphDefaults()) {
            this.paragraphDefaults();
        }
        if (this.cache.hasEndElement()) {
            return false;
        }
        if (this.cache.hasParagraphStyleStartElement()) {
            return true;
        }
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.peek();
            if (event.isStartElement() && this.paragraphLevels.contains(event.asStartElement().getName().getLocalPart())) {
                return true;
            }
            if (event.isEndElement() && this.style.equals(event.asEndElement().getName().getLocalPart())) {
                this.cache.endElement = event.asEndElement();
                this.eventReader.nextEvent();
                return false;
            }
            this.eventReader.nextEvent();
        }
        return false;
    }

    PowerpointStyleDefinition nextParagraphLevel() throws XMLStreamException {
        if (!this.cache.hasParagraphDefaults()) {
            this.paragraphDefaults();
        }
        if (this.cache.hasParagraphStyleStartElement()) {
            PowerpointStyleDefinition styleDefinition = this.powerpointStyleDefinition(this.cache.paragraphStyleStartElement);
            styleDefinition.readWith(this.eventReader);
            this.cache.invalidateParagraphStyleStartElement();
            return styleDefinition;
        }
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (event.isStartElement() && this.paragraphLevels.contains(event.asStartElement().getName().getLocalPart())) {
                PowerpointStyleDefinition styleDefinition = this.powerpointStyleDefinition(event.asStartElement());
                styleDefinition.readWith(this.eventReader);
                return styleDefinition;
            }
            if (!event.isEndElement() || !this.style.equals(event.asEndElement().getName().getLocalPart())) continue;
            break;
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_STRUCTURE, this.style));
    }

    private PowerpointStyleDefinition powerpointStyleDefinition(StartElement paragraphStyleStartElement) {
        return new PowerpointStyleDefinition.ParagraphLevel(new PowerpointStyleDefinition.ParagraphDefault(this.conditionalParameters, this.eventFactory, paragraphStyleStartElement));
    }

    @Override
    public EndElement endElement() throws XMLStreamException {
        if (this.cache.hasEndElement()) {
            return this.cache.endElement;
        }
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (!event.isEndElement() || !this.style.equals(event.asEndElement().getName().getLocalPart())) continue;
            this.cache.endElement = event.asEndElement();
            return this.cache.endElement;
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_STRUCTURE, this.style));
    }

    private static final class Cache {
        private StartElement startElement;
        private PowerpointStyleDefinition paragraphDefaults;
        private StartElement paragraphStyleStartElement;
        private EndElement endElement;

        Cache(StartElement startElement) {
            this.startElement = startElement;
        }

        boolean hasStartElement() {
            return null != this.startElement;
        }

        boolean hasParagraphDefaults() {
            return null != this.paragraphDefaults;
        }

        boolean hasParagraphStyleStartElement() {
            return null != this.paragraphStyleStartElement;
        }

        void invalidateParagraphStyleStartElement() {
            this.paragraphStyleStartElement = null;
        }

        boolean hasEndElement() {
            return null != this.endElement;
        }
    }
}

