/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.DifferentialFormat;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinition;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinitionsReader;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleDefinitionsReader;

final class PowerpointStyleDefinitions
implements StyleDefinitions {
    static final String DEFAULT_TEXT_STYLE = "defaultTextStyle";
    static final String LST_STYLE = "lstStyle";
    static final String BODY_STYLE = "bodyStyle";
    static final String OTHER_STYLE = "otherStyle";
    static final String TITLE_STYLE = "titleStyle";
    static final String NOTES_STYLE = "notesStyle";
    static final Set<String> NAMES = new HashSet<String>(Arrays.asList("defaultTextStyle", "lstStyle", "bodyStyle", "otherStyle", "titleStyle", "notesStyle"));
    private final XMLEventFactory eventFactory;
    private StartElement startElement;
    private PowerpointStyleDefinition paragraphDefaults;
    private Map<String, PowerpointStyleDefinition> stylesByStyleIds;
    private EndElement endElement;

    PowerpointStyleDefinitions(XMLEventFactory eventFactory) {
        this.eventFactory = eventFactory;
    }

    @Override
    public void readWith(StyleDefinitionsReader reader) throws XMLStreamException {
        this.stylesByStyleIds = new LinkedHashMap<String, PowerpointStyleDefinition>();
        PowerpointStyleDefinitionsReader styleDefinitionsReader = (PowerpointStyleDefinitionsReader)reader;
        this.startElement = styleDefinitionsReader.startElement();
        this.paragraphDefaults = styleDefinitionsReader.paragraphDefaults();
        while (styleDefinitionsReader.nextParagraphLevelAvailable()) {
            this.place(styleDefinitionsReader.nextParagraphLevel());
        }
        this.endElement = styleDefinitionsReader.endElement();
    }

    private void place(PowerpointStyleDefinition styleDefinition) {
        this.stylesByStyleIds.put(styleDefinition.id(), styleDefinition);
    }

    @Override
    public void place(String parentId, ParagraphBlockProperties paragraphBlockProperties, RunProperties runProperties) {
    }

    @Override
    public String placedId() {
        return null;
    }

    @Override
    public ParagraphBlockProperties combinedParagraphBlockProperties(ParagraphBlockProperties paragraphBlockProperties) {
        return (this.stylesByStyleIds.containsKey(paragraphBlockProperties.paragraphStyle()) ? this.stylesByStyleIds.get(paragraphBlockProperties.paragraphStyle()).paragraphProperties() : this.paragraphDefaults.paragraphProperties()).mergedWith(paragraphBlockProperties);
    }

    @Override
    public RunProperties combinedRunProperties(String paragraphLevelId, String runStyle, RunProperties runProperties) {
        RunProperties combinedRunProperties = RunProperties.copiedRunProperties(this.getParagraphLevelProperties(paragraphLevelId));
        combinedRunProperties = combinedRunProperties.combineDistinct(RunProperties.copiedRunProperties(runProperties), StyleDefinitions.TraversalStage.DIRECT);
        return combinedRunProperties;
    }

    private RunProperties getParagraphLevelProperties(String paragraphLevelId) {
        String idAsString = this.paragraphLevel(paragraphLevelId);
        return this.stylesByStyleIds.containsKey(idAsString) ? this.stylesByStyleIds.get(idAsString).runProperties() : this.paragraphDefaults.runProperties();
    }

    private String paragraphLevel(String paragraphLevelId) {
        int id = null == paragraphLevelId ? 1 : Integer.valueOf(paragraphLevelId) + 1;
        return String.valueOf(id);
    }

    @Override
    public DifferentialFormat.Combined combinedDifferentialFormatFor(int cellFormatIndex) {
        throw new UnsupportedOperationException("The operation is unsupported");
    }

    @Override
    public StyleDefinitions mergedWith(StyleDefinitions other) {
        if (other instanceof StyleDefinitions.Empty) {
            return this;
        }
        if (!(other instanceof PowerpointStyleDefinitions)) {
            throw new IllegalArgumentException("The provided argument is illegal: ".concat(other.getClass().getSimpleName()));
        }
        PowerpointStyleDefinitions that = (PowerpointStyleDefinitions)other;
        PowerpointStyleDefinitions merged = new PowerpointStyleDefinitions(this.eventFactory);
        merged.startElement = this.startElement;
        merged.paragraphDefaults = this.paragraphDefaults.mergedWith(that.paragraphDefaults);
        merged.stylesByStyleIds = new LinkedHashMap<String, PowerpointStyleDefinition>(this.stylesByStyleIds.size());
        Map<String, PowerpointStyleDefinition> common = this.stylesByStyleIds.entrySet().stream().filter(e -> that.stylesByStyleIds.containsKey(e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (PowerpointStyleDefinition)e.getValue()));
        this.stylesByStyleIds.entrySet().stream().filter(e -> !common.containsKey(e.getKey())).forEach(e -> merged.stylesByStyleIds.put((String)e.getKey(), (PowerpointStyleDefinition)e.getValue()));
        that.stylesByStyleIds.entrySet().stream().filter(e -> !common.containsKey(e.getKey())).forEach(e -> merged.stylesByStyleIds.put((String)e.getKey(), (PowerpointStyleDefinition)e.getValue()));
        common.forEach((key, value) -> merged.stylesByStyleIds.put((String)key, this.stylesByStyleIds.get(key).mergedWith(that.stylesByStyleIds.get(key))));
        merged.endElement = this.endElement;
        return merged;
    }

    @Override
    public Markup asMarkup() {
        Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
        markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.startElement));
        markup.addMarkup(this.paragraphDefaults.asMarkup());
        for (Map.Entry<String, PowerpointStyleDefinition> entry : this.stylesByStyleIds.entrySet()) {
            markup.addMarkup(entry.getValue().asMarkup());
        }
        markup.addComponent(new MarkupComponent.End(this.endElement));
        return markup;
    }
}

